/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.define.iterator;

import com.orion.lang.utils.Exceptions;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;

public class SingletonIterator<E>
implements Iterator<E>,
Iterable<E> {
    private final E element;
    private boolean hasNext = true;

    public SingletonIterator(E element) {
        this.element = element;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public E next() {
        if (this.hasNext) {
            this.hasNext = false;
            return this.element;
        }
        throw Exceptions.noSuchElement();
    }

    @Override
    public void remove() {
        throw Exceptions.unsupported();
    }

    @Override
    public void forEachRemaining(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        if (this.hasNext) {
            action.accept(this.element);
            this.hasNext = false;
        }
    }

    @Override
    public Iterator<E> iterator() {
        return this;
    }
}

