/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.define.io;

import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.io.Streams;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.function.Consumer;

public class OutputAppender
extends OutputStream
implements Iterable<OutputAppender> {
    private final OutputStream out;
    private OutputAppender prev;
    private OutputAppender next;
    private boolean closeOnClose;

    public OutputAppender(OutputStream out) {
        this.out = out;
        this.closeOnClose = true;
    }

    public static OutputAppender create(OutputStream logStream) {
        return new OutputAppender(logStream);
    }

    public OutputAppender then(OutputStream logStream) {
        OutputAppender appender = new OutputAppender(logStream);
        appender.prev = this;
        this.next = appender;
        return appender;
    }

    public OutputAppender onClose(boolean onClose) {
        this.closeOnClose = onClose;
        return this;
    }

    public OutputAppender getRoot() {
        return this.findPrev(this);
    }

    private OutputAppender findPrev(OutputAppender appender) {
        if (appender.prev == null) {
            return appender;
        }
        return this.findPrev(appender.prev);
    }

    public void handle(Consumer<OutputStream> c) {
        for (OutputAppender appender : this) {
            c.accept(appender.out);
        }
    }

    @Override
    public void write(int b) throws IOException {
        for (OutputAppender appender : this) {
            appender.out.write(b);
        }
    }

    @Override
    public void write(byte[] bs) throws IOException {
        for (OutputAppender appender : this) {
            appender.out.write(bs);
        }
    }

    @Override
    public void write(byte[] bs, int off, int len) throws IOException {
        for (OutputAppender appender : this) {
            appender.out.write(bs, off, len);
        }
    }

    @Override
    public void close() {
        for (OutputAppender appender : this) {
            if (!appender.closeOnClose) continue;
            Streams.close(appender.out);
        }
    }

    @Override
    public void flush() {
        for (OutputAppender appender : this) {
            Streams.flush(appender.out);
        }
    }

    @Override
    public Iterator<OutputAppender> iterator() {
        return new OutputAppenderIterator(this.getRoot());
    }

    public OutputStream getOut() {
        return this.out;
    }

    static class OutputAppenderIterator
    implements Iterator<OutputAppender> {
        private OutputAppender current;

        private OutputAppenderIterator(OutputAppender current) {
            this.current = current;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public OutputAppender next() {
            if (this.current == null) {
                throw Exceptions.noSuchElement("there are no more elements");
            }
            OutputAppender tmp = this.current;
            this.current = this.current.next;
            return tmp;
        }
    }
}

