/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.define.collect;

import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.math.Numbers;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PartitionSet<T>
extends AbstractSet<Set<T>>
implements Iterator<Set<T>> {
    private final Iterator<T> iterator;
    private final int size;
    private final int totalSize;
    private int current;

    public PartitionSet(Set<T> set, int size) {
        this.iterator = set.iterator();
        this.size = size;
        this.totalSize = set.size();
    }

    @Override
    public int size() {
        return (this.totalSize + this.size - 1) / this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.totalSize == 0;
    }

    @Override
    public Iterator<Set<T>> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.size() > this.current;
    }

    @Override
    public Set<T> next() {
        if (!this.hasNext()) {
            throw Exceptions.noSuchElement("there are no more elements");
        }
        ++this.current;
        HashSet<T> set = new HashSet<T>(Numbers.getMin2Power(this.size));
        for (int i = 0; i < this.size && this.iterator.hasNext(); ++i) {
            set.add(this.iterator.next());
        }
        return set;
    }
}

