/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.define.collect;

import com.orion.lang.utils.Valid;
import java.util.AbstractList;
import java.util.List;

public class PartitionList<T>
extends AbstractList<List<T>> {
    private final List<T> list;
    private final int size;

    public PartitionList(List<T> list, int size) {
        this.list = list;
        this.size = size;
    }

    @Override
    public List<T> get(int index) {
        int listSize = this.size();
        Valid.gte(index, 0, "index {} must not be negative", index);
        Valid.lt(index, listSize, "index {} must be less than size {}", index, listSize);
        int start = index * this.size;
        int end = Math.min(start + this.size, this.list.size());
        return this.list.subList(start, end);
    }

    @Override
    public int size() {
        return (this.list.size() + this.size - 1) / this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }
}

