/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.define.collect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;

public interface MultiMap<E, K, V, M extends Map<K, V>>
extends Map<E, M> {
    public M computeSpace(E var1);

    default public V put(E elem, K key, V value) {
        return this.computeSpace(elem).put(key, value);
    }

    default public void putAll(E elem, Map<K, V> map) {
        this.computeSpace(elem).putAll(map);
    }

    default public V removeKey(E elem, K key) {
        Map r = (Map)this.get(elem);
        if (r == null || r.isEmpty()) {
            return null;
        }
        return r.remove(key);
    }

    default public boolean removeKey(E elem, K key, V value) {
        Map r = (Map)this.get(elem);
        if (r == null || r.isEmpty()) {
            return false;
        }
        return r.remove(key, value);
    }

    default public V get(E elem, K key) {
        Map r = (Map)this.get(elem);
        if (r == null || r.isEmpty()) {
            return null;
        }
        return r.get(key);
    }

    default public int size(E elem) {
        Map r = (Map)this.get(elem);
        if (r == null || r.isEmpty()) {
            return 0;
        }
        return r.size();
    }

    default public boolean isEmpty(E elem) {
        Map r = (Map)this.get(elem);
        if (r == null) {
            return true;
        }
        return r.isEmpty();
    }

    default public void clear(E elem) {
        Map r = (Map)this.get(elem);
        if (r != null) {
            r.clear();
        }
    }

    default public boolean containsKey(E elem, K key) {
        Map r = (Map)this.get(elem);
        if (r == null || r.isEmpty()) {
            return false;
        }
        return r.containsKey(key);
    }

    default public Collection<V> values(E elem) {
        Map r = (Map)this.get(elem);
        if (r == null || r.isEmpty()) {
            return new ArrayList(1);
        }
        return r.values();
    }

    default public Set<Map.Entry<K, V>> entrySet(E elem) {
        Map r = (Map)this.get(elem);
        if (r == null || r.isEmpty()) {
            return new HashSet<Map.Entry<K, V>>(1);
        }
        return r.entrySet();
    }

    default public void forEach(E elem, BiConsumer<? super K, ? super V> action) {
        Map r = (Map)this.get(elem);
        if (r == null || r.isEmpty()) {
            return;
        }
        r.forEach(action);
    }
}

