/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.define.cache;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class LruCache<K, V>
extends LinkedHashMap<K, V> {
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int DEFAULT_MAX_CAPACITY = 10;
    private final Lock lock;
    private volatile int maxCapacity;

    public LruCache() {
        this(10);
    }

    public LruCache(int maxCapacity) {
        super(16, 0.75f, true);
        this.maxCapacity = maxCapacity;
        this.lock = new ReentrantLock();
    }

    public static <K, V> LruCache<K, V> newLru() {
        return new LruCache<K, V>();
    }

    public static <K, V> LruCache<K, V> newLru(int maxCapacity) {
        return new LruCache<K, V>(maxCapacity);
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.maxCapacity;
    }

    @Override
    public boolean containsKey(Object key) {
        this.lock.lock();
        try {
            boolean bl = super.containsKey(key);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public V get(Object key) {
        this.lock.lock();
        try {
            Object v = super.get(key);
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        this.lock.lock();
        try {
            V v = super.put(key, value);
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public V remove(Object key) {
        this.lock.lock();
        try {
            Object v = super.remove(key);
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int size() {
        this.lock.lock();
        try {
            int n = super.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            super.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public void setMaxCapacity(int maxCapacity) {
        this.maxCapacity = maxCapacity;
    }
}

