/*
 * Decompiled with CFR 0.152.
 */
package com.orion.http.parse;

import com.orion.http.BaseHttpRequest;
import com.orion.http.parse.ParseRequestConfig;
import com.orion.http.parse.ParseResponse;
import com.orion.http.support.HttpCookie;
import com.orion.lang.able.Awaitable;
import com.orion.lang.utils.Charsets;
import com.orion.lang.utils.Exceptions;
import java.io.IOException;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class ParseRequest
extends BaseHttpRequest
implements Awaitable<ParseResponse> {
    private Connection connection;
    private Connection.Request request;
    private ParseRequestConfig config;

    public ParseRequest() {
        this(null);
    }

    public ParseRequest(String url) {
        this.userAgent(DEFAULT_USERAGENT);
        this.url = url;
    }

    public ParseRequest config(ParseRequestConfig config) {
        this.config = config;
        return this;
    }

    @Override
    protected void buildRequest() {
        super.buildRequest();
        this.connection = Jsoup.connect((String)this.url).method(Connection.Method.valueOf((String)this.method));
        this.request = this.connection.request();
        if (this.headers != null) {
            this.headers.forEach((arg_0, arg_1) -> ((Connection)this.connection).header(arg_0, arg_1));
        }
        if (this.cookies != null) {
            this.cookies.stream().map(HttpCookie::getValues).forEach(s -> s.forEach((arg_0, arg_1) -> ((Connection)this.connection).cookie(arg_0, arg_1)));
        }
        if (this.ignoreHeaders != null) {
            this.ignoreHeaders.forEach(arg_0 -> ((Connection.Request)this.request).removeHeader(arg_0));
        }
        this.connection.header("Content-Type", this.contentType + "; charset=" + this.charset);
        this.configuration();
        if (!super.isNoBodyRequest()) {
            return;
        }
        if (this.body != null) {
            this.connection.requestBody(new String(this.body, this.bodyOffset, this.bodyLen, Charsets.of((String)this.charset)));
        } else if (this.formParts != null) {
            this.connection.data(this.formParts);
        }
    }

    protected void configuration() {
        if (this.config == null) {
            this.config = new ParseRequestConfig();
        }
        if (this.config.getProxyHost() != null && this.config.getProxyPort() != 0) {
            this.request.proxy(this.config.getProxyHost(), this.config.getProxyPort());
        }
        this.request.sslSocketFactory();
        this.request.maxBodySize(this.config.getMaxBodySize()).followRedirects(this.config.isFollowRedirects()).ignoreContentType(this.config.isIgnoreContentType()).ignoreHttpErrors(this.config.isIgnoreError()).timeout(this.config.getTimeout()).postDataCharset(this.charset).sslSocketFactory(this.config.getSslSocketFactory());
    }

    public ParseResponse await() {
        this.buildRequest();
        try {
            return new ParseResponse(this.url, this.connection.execute());
        }
        catch (IOException e) {
            throw Exceptions.httpRequest((String)this.url, (Throwable)e);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Connection.Request getRequest() {
        return this.request;
    }

    public ParseRequestConfig getConfig() {
        return this.config;
    }
}

