/*
 * Decompiled with CFR 0.152.
 */
package com.orion.http.ok.ws;

import com.orion.http.ok.OkRequests;
import com.orion.http.ok.ws.handler.CloseHandler;
import com.orion.http.ok.ws.handler.FailureHandler;
import com.orion.http.ok.ws.handler.MessageByteHandler;
import com.orion.http.ok.ws.handler.MessageHandler;
import com.orion.http.ok.ws.handler.OpenHandler;
import com.orion.http.ok.ws.handler.SendMessageByteHandler;
import com.orion.http.ok.ws.handler.SendMessageHandler;
import com.orion.lang.id.Sequences;
import com.orion.lang.utils.Threads;
import java.io.EOFException;
import java.net.SocketException;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkWebSocketClient
extends WebSocketListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(OkWebSocketClient.class);
    private final String url;
    private final String sessionId;
    private final OkHttpClient client;
    private WebSocket webSocket;
    private int errorReconnectionTimes;
    private int nowReconnectionTimes;
    private volatile int connectionState;
    private int errorReconnectionInterval;
    private int closeCode;
    private String closeReason;
    private Throwable throwable;
    private OpenHandler openHandler;
    private MessageHandler messageHandler;
    private MessageByteHandler messageByteHandler;
    private CloseHandler closeHandler;
    private FailureHandler failureHandler;
    private SendMessageHandler sendMessageHandler;
    private SendMessageByteHandler sendMessageByteHandler;
    private Request request;

    public OkWebSocketClient(String url) {
        this.url = url;
        this.sessionId = Sequences.nextId() + "";
        this.client = OkRequests.getClient();
    }

    public void start() {
        this.connectionState = 1;
        this.errorReconnectionInterval = 30000;
        this.request = new Request.Builder().url(this.url).addHeader("Mock-Client-Session-Id", this.sessionId).build();
        this.webSocket = this.client.newWebSocket(this.request, (WebSocketListener)this);
    }

    public void send(String text) {
        if (this.webSocket != null) {
            if (this.sendMessageHandler != null) {
                this.sendMessageHandler.send(this.webSocket, text);
            }
            this.webSocket.send(text);
        }
    }

    public void send(byte[] bs) {
        this.send(ByteString.of((byte[])bs));
    }

    public void send(byte[] bs, int offset, int len) {
        this.send(ByteString.of((byte[])bs, (int)offset, (int)len));
    }

    public void send(ByteString byteString) {
        if (this.webSocket != null) {
            if (this.sendMessageByteHandler != null) {
                this.sendMessageByteHandler.send(this.webSocket, byteString);
            }
            this.webSocket.send(byteString);
        }
    }

    public void close() {
        this.close(3005, "Client \u5173\u95ed\u8fde\u63a5");
    }

    public void close(int code, String reason) {
        if (this.webSocket != null) {
            this.webSocket.close(code, reason);
        }
    }

    public OkWebSocketClient reconnection(int times) {
        this.errorReconnectionTimes = times;
        return this;
    }

    public OkWebSocketClient reconnection(int times, int interval) {
        this.errorReconnectionTimes = times;
        this.errorReconnectionInterval = interval;
        return this;
    }

    public void onOpen(WebSocket webSocket, Response response) {
        if (this.connectionState == 2) {
            LOGGER.warn("WebSocketClient \u8fde\u63a5\u5f02\u5e38\u65ad\u5f00-\u91cd\u8fde\u6210\u529f-\u5c1d\u8bd5\u6b21\u6570 {}\u6b21", (Object)this.nowReconnectionTimes);
            this.nowReconnectionTimes = 0;
            this.connectionState = 3;
        } else {
            LOGGER.info("WebSocketClient \u5df2\u5efa\u7acb\u8fde\u63a5 response: [{}]", (Object)response);
            if (this.openHandler != null) {
                this.openHandler.open(webSocket, response);
            }
        }
    }

    public void onMessage(WebSocket webSocket, String text) {
        LOGGER.debug("WebSocketClient \u6536\u5230Server Text\u4fe1\u606f msg: '{}'", (Object)text);
        if (this.messageHandler != null) {
            this.messageHandler.message(webSocket, text);
        }
    }

    public void onMessage(WebSocket webSocket, ByteString bytes) {
        LOGGER.debug("WebSocketClient \u6536\u5230Server Byte\u4fe1\u606f size: '{}'", (Object)bytes.size());
        if (this.messageByteHandler != null) {
            this.messageByteHandler.message(webSocket, bytes);
        }
    }

    public void onClosing(WebSocket webSocket, int code, String reason) {
        LOGGER.info("WebSocketClient \u51c6\u5907\u5173\u95ed\u8fde\u63a5 code: {}, reason: '{}'", (Object)code, (Object)reason);
        if (this.closeHandler != null) {
            this.closeHandler.close(webSocket, code, reason);
        }
        boolean close = webSocket.close(code, reason);
        LOGGER.info("WebSocketClient \u5173\u95ed\u8fde\u63a5\u5b8c\u6210 code: {}, reason: '{}', close: {}", new Object[]{code, reason, close});
    }

    public void onClosed(WebSocket webSocket, int code, String reason) {
        LOGGER.info("WebSocketClient \u8fde\u63a5\u5df2\u5173\u95ed, code: {}, reason: '{}'", (Object)code, (Object)reason);
        this.closeCode = code;
        this.closeReason = reason;
        this.connectionState = 0;
    }

    public void onFailure(WebSocket failWebSocket, Throwable t, Response response) {
        if (this.failureHandler != null) {
            this.failureHandler.failure(failWebSocket, t, response);
        }
        if ((this.connectionState == 1 || this.connectionState == 3) && this.nowReconnectionTimes == 0 && this.errorReconnectionTimes != 0) {
            this.connectionState = 2;
        }
        boolean close = failWebSocket.close(3004, "Client \u5173\u95edFail\u8fde\u63a5");
        this.closeCode = 3004;
        this.closeReason = "Client \u5173\u95edFail\u8fde\u63a5";
        this.throwable = t;
        LOGGER.error("WebSocketClient \u5904\u7406\u8fde\u63a5\u5931\u8d25 close: {}, error: {}-{}, response: {}", new Object[]{close, t.getClass().getName(), t.getMessage(), response});
        if (this.connectionState == 2 && (t instanceof SocketException || t instanceof EOFException)) {
            if (this.nowReconnectionTimes < this.errorReconnectionTimes && this.errorReconnectionTimes - this.nowReconnectionTimes > 0) {
                Threads.sleep((long)this.errorReconnectionInterval);
                this.webSocket = this.client.newWebSocket(this.request, (WebSocketListener)this);
                ++this.nowReconnectionTimes;
                LOGGER.warn("WebSocketClient \u8fde\u63a5\u5f02\u5e38\u65ad\u5f00-\u7b2c{}\u6b21\u5c1d\u8bd5\u91cd\u65b0\u8fde\u63a5", (Object)this.nowReconnectionTimes);
            } else {
                LOGGER.warn("WebSocketClient \u8fde\u63a5\u5f02\u5e38\u65ad\u5f00-\u65e0\u6cd5\u91cd\u8fde");
            }
        }
    }

    public OkWebSocketClient openHandler(OpenHandler openHandler) {
        this.openHandler = openHandler;
        return this;
    }

    public OkWebSocketClient messageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
        return this;
    }

    public OkWebSocketClient messageByteHandler(MessageByteHandler messageByteHandler) {
        this.messageByteHandler = messageByteHandler;
        return this;
    }

    public OkWebSocketClient closeHandler(CloseHandler closeHandler) {
        this.closeHandler = closeHandler;
        return this;
    }

    public OkWebSocketClient failureHandler(FailureHandler failureHandler) {
        this.failureHandler = failureHandler;
        return this;
    }

    public OkWebSocketClient sendMessageHandler(SendMessageHandler sendMessageHandler) {
        this.sendMessageHandler = sendMessageHandler;
        return this;
    }

    public OkWebSocketClient sendMessageByteHandler(SendMessageByteHandler sendMessageByteHandler) {
        this.sendMessageByteHandler = sendMessageByteHandler;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public WebSocket getWebSocket() {
        return this.webSocket;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public int getErrorReconnectionTimes() {
        return this.errorReconnectionTimes;
    }

    public int getErrorReconnectionInterval() {
        return this.errorReconnectionInterval;
    }

    public int getCloseCode() {
        return this.closeCode;
    }

    public String getCloseReason() {
        return this.closeReason;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public int getNowReconnectionTimes() {
        return this.nowReconnectionTimes;
    }

    public int getConnectionState() {
        return this.connectionState;
    }
}

