/*
 * Decompiled with CFR 0.152.
 */
package com.orion.http.ok.file;

import com.orion.http.ok.OkRequest;
import com.orion.http.ok.OkResponse;
import com.orion.lang.utils.io.Files1;
import com.orion.lang.utils.io.Streams;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import okhttp3.OkHttpClient;

public class OkDownload {
    private final OkRequest request;
    private OkResponse response;

    public OkDownload(String url) {
        this(new OkRequest(url), null);
    }

    public OkDownload(String url, OkHttpClient client) {
        this(new OkRequest(url), client);
    }

    public OkDownload(OkRequest request) {
        this(request, null);
    }

    public OkDownload(OkRequest request, OkHttpClient client) {
        this.request = request;
        if (client != null) {
            this.request.client(client);
        }
    }

    public OkDownload client(OkHttpClient client) {
        this.request.client(client);
        return this;
    }

    public OkDownload download(String file) throws IOException {
        Files1.touch((String)file);
        this.download(Files1.openOutputStream((String)file), true);
        return this;
    }

    public OkDownload download(File file) throws IOException {
        Files1.touch((File)file);
        this.download(Files1.openOutputStream((File)file), true);
        return this;
    }

    public OkDownload download(OutputStream out) throws IOException {
        this.download(out, false);
        return this;
    }

    public OkDownload download(OutputStream out, boolean autoClose) throws IOException {
        this.response = this.request.await();
        out.write(this.response.getBody());
        if (autoClose) {
            Streams.close((AutoCloseable)out);
        }
        return this;
    }

    public OkRequest getRequest() {
        return this.request;
    }

    public OkResponse getResponse() {
        return this.response;
    }
}

