/*
 * Decompiled with CFR 0.152.
 */
package com.orion.http.ok.file;

import com.orion.http.ok.BaseOkRequest;
import com.orion.http.ok.OkRequests;
import com.orion.http.ok.OkResponse;
import com.orion.lang.able.Asyncable;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Valid;
import com.orion.lang.utils.io.Files1;
import com.orion.lang.utils.io.Streams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Consumer;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class OkAsyncDownload
extends BaseOkRequest
implements Asyncable<Consumer<OkResponse>> {
    private OutputStream out;
    private boolean autoClose;
    private boolean asyncFailThrows;

    public OkAsyncDownload(String url) {
        this(url, OkRequests.getClient());
    }

    public OkAsyncDownload(String url, OkHttpClient client) {
        this.url = url;
        this.client = client;
    }

    public OkAsyncDownload asyncFailThrows(boolean asyncFailThrows) {
        this.asyncFailThrows = asyncFailThrows;
        return this;
    }

    public OkAsyncDownload asyncFailThrows() {
        this.asyncFailThrows = true;
        return this;
    }

    public OkAsyncDownload download(String file) {
        Files1.touch((String)file);
        this.out = Files1.openOutputStreamSafe((String)file);
        this.autoClose = true;
        return this;
    }

    public OkAsyncDownload download(File file) {
        Files1.touch((File)file);
        this.out = Files1.openOutputStreamSafe((File)file);
        this.autoClose = true;
        return this;
    }

    public OkAsyncDownload download(OutputStream out) {
        this.out = out;
        this.autoClose = false;
        return this;
    }

    public OkAsyncDownload download(OutputStream out, boolean autoClose) {
        this.out = out;
        this.autoClose = autoClose;
        return this;
    }

    public void async(final Consumer<OkResponse> callback) {
        Valid.notNull(callback, (String)"async call back is null", (Object[])new Object[0]);
        super.buildRequest();
        this.call = this.client.newCall(this.request);
        final OkResponse response = new OkResponse(this.url, this.tag);
        this.call.enqueue(new Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response res) throws IOException {
                ResponseBody body;
                response.asyncSetResponse(res, false);
                if (response.isOk() && (body = res.body()) != null) {
                    try {
                        Streams.transfer((InputStream)body.byteStream(), (OutputStream)OkAsyncDownload.this.out);
                    }
                    finally {
                        if (OkAsyncDownload.this.autoClose) {
                            Streams.close((AutoCloseable)OkAsyncDownload.this.out);
                        }
                    }
                }
                callback.accept(response);
            }

            public void onFailure(Call call, IOException e) {
                response.error(e);
                if (OkAsyncDownload.this.autoClose) {
                    Streams.close((AutoCloseable)OkAsyncDownload.this.out);
                }
                if (OkAsyncDownload.this.asyncFailThrows) {
                    throw Exceptions.httpRequest((String)OkAsyncDownload.this.url, (String)("async ok download file on failure: " + OkAsyncDownload.super.getRequestMessage()), (Throwable)e);
                }
                callback.accept(response);
            }
        });
    }
}

