/*
 * Decompiled with CFR 0.152.
 */
package com.orion.http.ok;

import com.orion.http.ok.OkClientBuilder;
import com.orion.http.ok.OkRequest;
import com.orion.http.ok.OkResponse;
import com.orion.http.ok.file.OkAsyncDownload;
import com.orion.http.ok.file.OkAsyncUpload;
import com.orion.http.ok.file.OkDownload;
import com.orion.http.ok.file.OkUpload;
import com.orion.http.ok.ws.OkWebSocketClient;
import com.orion.http.ok.ws.OkWebSocketServer;
import com.orion.http.support.HttpContentType;
import com.orion.http.support.HttpMethod;
import java.net.InetAddress;
import java.util.Map;
import okhttp3.OkHttpClient;

public class OkRequests {
    private static OkHttpClient client = OkClientBuilder.create().logInterceptor().build();

    private OkRequests() {
    }

    public static OkResponse get(String url) {
        return new OkRequest(url).await();
    }

    public static OkResponse get(String url, Map<String, ?> params) {
        OkRequest request = new OkRequest(url);
        request.queryParams(params);
        return request.await();
    }

    public static OkResponse post(String url) {
        OkRequest request = new OkRequest(url);
        request.method(HttpMethod.POST);
        return request.await();
    }

    public static OkResponse post(String url, byte[] body) {
        OkRequest request = new OkRequest(url);
        request.method(HttpMethod.POST).contentType(HttpContentType.APPLICATION_JSON).body(body);
        return request.await();
    }

    public static OkResponse post(String url, String body) {
        OkRequest request = new OkRequest(url);
        request.method(HttpMethod.POST).contentType(HttpContentType.APPLICATION_JSON).body(body);
        return request.await();
    }

    public static OkResponse post(String url, String contentType, byte[] body) {
        OkRequest request = new OkRequest(url);
        request.method(HttpMethod.POST).contentType(contentType).body(body);
        return request.await();
    }

    public static OkResponse post(String url, String contentType, String body) {
        OkRequest request = new OkRequest(url);
        request.method(HttpMethod.POST).contentType(contentType).body(body);
        return request.await();
    }

    public static OkResponse post(String url, Map<String, String> formParts) {
        OkRequest request = new OkRequest(url);
        request.method(HttpMethod.POST).formParts(formParts);
        return request.await();
    }

    public static OkRequest get() {
        return new OkRequest();
    }

    public static OkRequest post() {
        OkRequest request = new OkRequest();
        request.method(HttpMethod.POST);
        return request;
    }

    public static OkAsyncDownload downloadAsync(String url) {
        return new OkAsyncDownload(url);
    }

    public static OkAsyncDownload downloadAsync(String url, OkHttpClient client) {
        return new OkAsyncDownload(url, client);
    }

    public static OkDownload download(String url) {
        return new OkDownload(url);
    }

    public static OkDownload download(String url, OkHttpClient client) {
        return new OkDownload(url, client);
    }

    public static OkAsyncUpload uploadAsync(String url) {
        return new OkAsyncUpload(url);
    }

    public static OkAsyncUpload uploadAsync(String url, OkHttpClient client) {
        return new OkAsyncUpload(url, client);
    }

    public static OkUpload upload(String url) {
        return new OkUpload(url);
    }

    public static OkUpload upload(String url, OkHttpClient client) {
        return new OkUpload(url, client);
    }

    public static OkWebSocketClient getWebSocketClient(String url) {
        return new OkWebSocketClient(url);
    }

    public static OkWebSocketServer getWebSocketServer(int port) {
        return new OkWebSocketServer(port);
    }

    public static OkWebSocketServer getWebSocketServer(InetAddress address, int port) {
        return new OkWebSocketServer(address, port);
    }

    public static OkHttpClient getClient() {
        return client;
    }

    public static void setClient(OkHttpClient client) {
        OkRequests.client = client;
    }
}

