/*
 * Decompiled with CFR 0.152.
 */
package com.orion.http.ok;

import com.orion.http.ok.BaseOkRequest;
import com.orion.http.ok.OkRequests;
import com.orion.http.ok.OkResponse;
import com.orion.lang.able.Asyncable;
import com.orion.lang.able.Awaitable;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Valid;
import java.io.IOException;
import java.util.function.Consumer;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Response;

public class OkRequest
extends BaseOkRequest
implements Awaitable<OkResponse>,
Asyncable<Consumer<OkResponse>> {
    private boolean async;
    private boolean asyncFailThrows;
    private Consumer<OkResponse> asyncCallback;

    public OkRequest() {
        this(null, OkRequests.getClient());
    }

    public OkRequest(OkHttpClient client) {
        this(null, client);
    }

    public OkRequest(String url) {
        this(url, OkRequests.getClient());
    }

    public OkRequest(String url, OkHttpClient client) {
        this.url = url;
        this.client = client;
        this.userAgent(DEFAULT_USERAGENT);
    }

    public OkRequest asyncFailThrows(boolean asyncFailThrows) {
        this.asyncFailThrows = asyncFailThrows;
        return this;
    }

    public OkRequest asyncFailThrows() {
        this.asyncFailThrows = true;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OkResponse await() {
        super.buildRequest();
        this.call = this.client.newCall(this.request);
        try (Response resp = this.call.execute();){
            OkResponse okResponse = new OkResponse(this.url, this.tag, resp);
            return okResponse;
        }
        catch (IOException e) {
            throw Exceptions.httpRequest((String)this.url, (Throwable)e);
        }
    }

    public void async(Consumer<OkResponse> callback) {
        Valid.notNull(callback, (String)"async call back is null", (Object[])new Object[0]);
        this.asyncCallback = callback;
        this.async = true;
        super.buildRequest();
        this.call = this.client.newCall(this.request);
        final OkResponse response = new OkResponse(this.url, this.tag);
        this.call.enqueue(new Callback(){

            public void onResponse(Call call, Response res) {
                response.asyncSetResponse(res);
                OkRequest.this.asyncCallback.accept(response);
            }

            public void onFailure(Call call, IOException e) {
                response.error(e);
                if (OkRequest.this.asyncFailThrows) {
                    throw Exceptions.httpRequest((String)OkRequest.this.url, (String)("async ok request on failure: " + OkRequest.this.getRequestMessage()), (Throwable)e);
                }
                OkRequest.this.asyncCallback.accept(response);
            }
        });
    }

    public boolean isAsync() {
        return this.async;
    }

    public Consumer<OkResponse> getAsyncCallback() {
        return this.asyncCallback;
    }
}

