/*
 * Decompiled with CFR 0.152.
 */
package com.orion.http.ok;

import com.orion.lang.id.UUIds;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkLoggerInterceptor
implements Interceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(OkLoggerInterceptor.class);
    private static final String DEF = "OK-Request ";
    private String suffix;

    public OkLoggerInterceptor() {
        this(DEF);
    }

    public OkLoggerInterceptor(String suffix) {
        this.suffix = suffix;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        long start = System.currentTimeMillis();
        String traceId = UUIds.random32();
        LOGGER.info(this.suffix + "START method: [{}], url: [{}], tag: [{}], traceId: [{}]", new Object[]{request.method(), request.url(), request.tag(), traceId});
        try {
            Response response = chain.proceed(request);
            long end = System.currentTimeMillis();
            LOGGER.info(this.suffix + "END [use: {}ms], code: {}, success: {}, method: [{}], url: [{}], tag: [{}], traceId: [{}]", new Object[]{end - start, response.code(), response.isSuccessful(), request.method(), request.url(), request.tag(), traceId});
            return response;
        }
        catch (IOException e) {
            long end = System.currentTimeMillis();
            LOGGER.error(this.suffix + "ERROR [use: {}ms], method: [{}], url: [{}], tag: [{}], traceId: [{}], errorMessage: [{}]", new Object[]{end - start, request.method(), request.url(), request.tag(), traceId, e.getMessage()});
            throw e;
        }
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }
}

