/*
 * Decompiled with CFR 0.152.
 */
package com.orion.http.apache;

import java.io.InterruptedIOException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;

public enum ApacheClientRetryPolicy {
    NO_RETRY((exception, executionCount, context) -> false),
    AUTO_RETRY((e, i, httpContext) -> {
        if (i > 3) {
            return false;
        }
        if (e instanceof NoHttpResponseException) {
            return true;
        }
        if (e instanceof SSLHandshakeException) {
            return false;
        }
        if (e instanceof InterruptedIOException) {
            return false;
        }
        if (e instanceof UnknownHostException) {
            return false;
        }
        if (e instanceof SSLException) {
            return false;
        }
        HttpClientContext context = HttpClientContext.adapt((HttpContext)httpContext);
        HttpRequest request = context.getRequest();
        return !(request instanceof HttpEntityEnclosingRequest);
    });

    private final HttpRequestRetryHandler handler;

    private ApacheClientRetryPolicy(HttpRequestRetryHandler handler) {
        this.handler = handler;
    }

    public HttpRequestRetryHandler getHandler() {
        return this.handler;
    }
}

