/*
 * Decompiled with CFR 0.152.
 */
package com.orion.http.apache;

import com.orion.http.KitHttpConfiguration;
import com.orion.http.apache.ApacheClientRetryPolicy;
import com.orion.http.apache.ApacheLoggerInterceptor;
import com.orion.lang.able.Buildable;
import com.orion.lang.config.KitConfig;
import com.orion.lang.utils.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;

public class ApacheClientBuilder
implements Buildable<CloseableHttpClient> {
    private int connectTimeout = 3000;
    private int socketTimeout = 15000;
    private int requestTimeout = 15000;
    private boolean logInterceptor;
    private int maxRoute;
    private int maxRequest;
    private long connTimeToLive;
    private TimeUnit connTimeToLiveTimeUnit;
    private String userAgent;
    private String proxyHost;
    private int proxyPort;
    private CookieStore cookies;
    private List<HttpRequestInterceptor> requestInterceptors;
    private List<HttpResponseInterceptor> responseInterceptors;
    private HttpClientConnectionManager connectionManager;
    private HttpRequestRetryHandler requestRetryHandler;
    private SSLContext sslContext;
    private LayeredConnectionSocketFactory sslSocketFactory;

    public ApacheClientBuilder() {
        this.userAgent = (String)KitConfig.get((String)KitHttpConfiguration.CONFIG.HTTP_DEFAULT_USERAGENT);
        this.maxRoute = 12;
        this.maxRequest = 64;
        this.connTimeToLive = -1L;
        this.connTimeToLiveTimeUnit = TimeUnit.MILLISECONDS;
    }

    public static ApacheClientBuilder create() {
        return new ApacheClientBuilder();
    }

    public ApacheClientBuilder proxy(String host, int port) {
        this.proxyHost = host;
        this.proxyPort = port;
        return this;
    }

    public ApacheClientBuilder logInterceptor(boolean open) {
        this.logInterceptor = open;
        return this;
    }

    public ApacheClientBuilder logInterceptor() {
        this.logInterceptor = true;
        return this;
    }

    public ApacheClientBuilder connectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public ApacheClientBuilder socketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    public ApacheClientBuilder requestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public ApacheClientBuilder maxRoute(int route) {
        this.maxRoute = route;
        return this;
    }

    public ApacheClientBuilder maxRequest(int maxRequest) {
        this.maxRequest = maxRequest;
        return this;
    }

    public ApacheClientBuilder connTimeToLive(long connTimeToLive) {
        this.connTimeToLive = connTimeToLive;
        return this;
    }

    public ApacheClientBuilder connTimeToLive(long connTimeToLive, TimeUnit connTimeToLiveTimeUnit) {
        this.connTimeToLive = connTimeToLive;
        this.connTimeToLiveTimeUnit = connTimeToLiveTimeUnit;
        return this;
    }

    public ApacheClientBuilder userAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public ApacheClientBuilder cookies(CookieStore cookies) {
        this.cookies = cookies;
        return this;
    }

    public ApacheClientBuilder requestInterceptor(HttpRequestInterceptor interceptor) {
        if (this.requestInterceptors == null) {
            this.requestInterceptors = new ArrayList<HttpRequestInterceptor>();
        }
        this.requestInterceptors.add(interceptor);
        return this;
    }

    public ApacheClientBuilder responseInterceptor(HttpResponseInterceptor interceptor) {
        if (this.responseInterceptors == null) {
            this.responseInterceptors = new ArrayList<HttpResponseInterceptor>();
        }
        this.responseInterceptors.add(interceptor);
        return this;
    }

    public ApacheClientBuilder connectionManager(HttpClientConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        return this;
    }

    public ApacheClientBuilder noRetry() {
        this.requestRetryHandler = ApacheClientRetryPolicy.NO_RETRY.getHandler();
        return this;
    }

    public ApacheClientBuilder requestRetryHandler(HttpRequestRetryHandler requestRetryHandler) {
        this.requestRetryHandler = requestRetryHandler;
        return this;
    }

    public ApacheClientBuilder requestRetryHandler(ApacheClientRetryPolicy policy) {
        this.requestRetryHandler = policy.getHandler();
        return this;
    }

    public ApacheClientBuilder sslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public ApacheClientBuilder sslSocketFactory(LayeredConnectionSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
        return this;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public boolean isLogInterceptor() {
        return this.logInterceptor;
    }

    public int getMaxRoute() {
        return this.maxRoute;
    }

    public int getMaxRequest() {
        return this.maxRequest;
    }

    public long getConnTimeToLive() {
        return this.connTimeToLive;
    }

    public TimeUnit getConnTimeToLiveTimeUnit() {
        return this.connTimeToLiveTimeUnit;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public CookieStore getCookies() {
        return this.cookies;
    }

    public HttpClientConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public HttpRequestRetryHandler getRequestRetryHandler() {
        return this.requestRetryHandler;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public LayeredConnectionSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public HttpClientBuilder buildClientBuilder() {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.connectTimeout).setSocketTimeout(this.socketTimeout).setConnectionRequestTimeout(this.requestTimeout).build();
        HttpClientBuilder builder = HttpClients.custom().setConnectionTimeToLive(this.connTimeToLive, this.connTimeToLiveTimeUnit).setMaxConnTotal(this.maxRequest).setMaxConnPerRoute(this.maxRoute).setDefaultRequestConfig(requestConfig);
        if (this.connectionManager != null) {
            builder.setConnectionManager(this.connectionManager);
        }
        if (this.requestRetryHandler != null) {
            builder.setRetryHandler(this.requestRetryHandler);
        }
        if (this.userAgent != null) {
            builder.setUserAgent(this.userAgent);
        }
        if (this.logInterceptor) {
            ApacheLoggerInterceptor loggerInterceptor = new ApacheLoggerInterceptor();
            builder.addInterceptorFirst((HttpRequestInterceptor)loggerInterceptor).addInterceptorLast((HttpResponseInterceptor)loggerInterceptor);
        }
        if (!Lists.isEmpty(this.requestInterceptors)) {
            this.requestInterceptors.forEach(arg_0 -> ((HttpClientBuilder)builder).addInterceptorFirst(arg_0));
        }
        if (!Lists.isEmpty(this.responseInterceptors)) {
            this.requestInterceptors.forEach(arg_0 -> ((HttpClientBuilder)builder).addInterceptorLast(arg_0));
        }
        if (this.proxyHost != null && this.proxyPort != 0) {
            builder.setProxy(new HttpHost(this.proxyHost, this.proxyPort));
        }
        if (this.cookies != null) {
            builder.setDefaultCookieStore(this.cookies);
        }
        if (this.sslContext != null) {
            builder.setSSLContext(this.sslContext);
        }
        if (this.sslSocketFactory != null) {
            builder.setSSLSocketFactory(this.sslSocketFactory);
        }
        return builder;
    }

    public CloseableHttpClient build() {
        return this.buildClientBuilder().build();
    }

    public String toString() {
        return "ApacheConfig{connectTimeout=" + this.connectTimeout + ", socketTimeout=" + this.socketTimeout + ", requestTimeout=" + this.requestTimeout + ", logInterceptor=" + this.logInterceptor + ", route=" + this.maxRoute + ", userAgent='" + this.userAgent + '\'' + ", proxyHost='" + this.proxyHost + '\'' + ", proxyPort=" + this.proxyPort + '}';
    }
}

