/*
 * Decompiled with CFR 0.152.
 */
package com.orion.http;

import com.orion.http.KitHttpConfiguration;
import com.orion.http.support.HttpContentType;
import com.orion.http.support.HttpCookie;
import com.orion.http.support.HttpMethod;
import com.orion.lang.config.KitConfig;
import com.orion.lang.utils.Strings;
import com.orion.lang.utils.Urls;
import com.orion.lang.utils.Valid;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class BaseHttpRequest {
    protected static final String DEFAULT_USERAGENT = (String)KitConfig.get((String)KitHttpConfiguration.CONFIG.HTTP_DEFAULT_USERAGENT);
    protected String url;
    protected String method = HttpMethod.GET.method();
    protected Map<String, Object> queryParams;
    protected String queryString;
    protected boolean queryStringEncode = true;
    protected String charset = "UTF-8";
    protected String contentType = HttpContentType.TEXT_PLAIN.getType();
    protected Map<String, String> headers;
    protected Collection<String> ignoreHeaders;
    protected Collection<HttpCookie> cookies;
    protected Map<String, String> formParts;
    protected byte[] body;
    protected int bodyOffset;
    protected int bodyLen;

    public BaseHttpRequest url(String url) {
        this.url = url;
        return this;
    }

    public BaseHttpRequest format(Object ... o) {
        this.url = Strings.format((String)this.url, (Object[])o);
        return this;
    }

    public BaseHttpRequest format(Map<String, Object> map) {
        this.url = Strings.format((String)this.url, map);
        return this;
    }

    public BaseHttpRequest method(String method) {
        this.method = method;
        return this;
    }

    public BaseHttpRequest method(HttpMethod method) {
        this.method = method.method();
        return this;
    }

    public BaseHttpRequest queryParam(String key, Object value) {
        if (this.queryParams == null) {
            this.queryParams = new LinkedHashMap<String, Object>();
        }
        this.queryParams.put(key, value);
        return this;
    }

    public BaseHttpRequest queryParams(Map<String, ?> queryParams) {
        if (this.queryParams == null) {
            this.queryParams = new LinkedHashMap<String, Object>();
        }
        this.queryParams.putAll(queryParams);
        return this;
    }

    public BaseHttpRequest queryStringEncode(boolean queryStringEncode) {
        this.queryStringEncode = queryStringEncode;
        return this;
    }

    public BaseHttpRequest charset(String charset) {
        this.charset = charset;
        return this;
    }

    public BaseHttpRequest header(String key, String value) {
        if (this.headers == null) {
            this.headers = new LinkedHashMap<String, String>();
        }
        this.headers.put(key, value);
        return this;
    }

    public BaseHttpRequest headers(Map<String, String> headers) {
        if (this.headers == null) {
            this.headers = headers;
        } else {
            this.headers.putAll(headers);
        }
        return this;
    }

    public BaseHttpRequest userAgent(String value) {
        return this.header("User-Agent", value);
    }

    public BaseHttpRequest referer(String value) {
        return this.header("Referer", value);
    }

    public BaseHttpRequest contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public BaseHttpRequest contentType(HttpContentType contentType) {
        this.contentType = contentType.getType();
        return this;
    }

    public BaseHttpRequest ignoreHeader(String ignoreHeader) {
        if (ignoreHeader == null) {
            return this;
        }
        if (this.ignoreHeaders == null) {
            this.ignoreHeaders = new ArrayList<String>();
        }
        this.ignoreHeaders.add(ignoreHeader);
        return this;
    }

    public BaseHttpRequest ignoreHeaders(String ... ignoreHeaders) {
        if (ignoreHeaders == null) {
            return this;
        }
        if (this.ignoreHeaders == null) {
            this.ignoreHeaders = new ArrayList<String>();
        }
        this.ignoreHeaders.addAll(Arrays.asList(ignoreHeaders));
        return this;
    }

    public BaseHttpRequest ignoreHeaders(Collection<String> ignoreHeaders) {
        if (this.ignoreHeaders == null) {
            this.ignoreHeaders = ignoreHeaders;
        } else {
            this.ignoreHeaders.addAll(ignoreHeaders);
        }
        return this;
    }

    public BaseHttpRequest cookie(HttpCookie cookie) {
        if (this.cookies == null) {
            this.cookies = new ArrayList<HttpCookie>();
        }
        this.cookies.add(cookie);
        return this;
    }

    public BaseHttpRequest cookies(Collection<HttpCookie> cookies) {
        if (this.cookies == null) {
            this.cookies = cookies;
        } else {
            this.cookies.addAll(cookies);
        }
        return this;
    }

    public BaseHttpRequest formPart(String key, String value) {
        if (this.formParts == null) {
            this.formParts = new LinkedHashMap<String, String>();
        }
        this.formParts.put(key, value);
        return this;
    }

    public BaseHttpRequest formParts(Map<String, String> formParts) {
        if (this.formParts == null) {
            this.formParts = formParts;
        } else {
            this.formParts.putAll(formParts);
        }
        return this;
    }

    public BaseHttpRequest body(String body) {
        if (body == null) {
            return this;
        }
        this.body = Strings.bytes((String)body, (String)this.charset);
        this.bodyOffset = 0;
        this.bodyLen = this.body.length;
        return this;
    }

    public BaseHttpRequest body(byte[] body) {
        this.body = body;
        this.bodyOffset = 0;
        this.bodyLen = body.length;
        return this;
    }

    public BaseHttpRequest body(byte[] body, int offset, int len) {
        this.body = body;
        this.bodyOffset = offset;
        this.bodyLen = len;
        return this;
    }

    protected void buildRequest() {
        Valid.notNull((Object)this.url, (String)"request url is null", (Object[])new Object[0]);
        this.method = this.method.trim().toUpperCase();
        if (this.isNoBodyRequest() && this.formParts != null) {
            if (this.queryParams == null) {
                this.queryParams = new LinkedHashMap<String, Object>();
            }
            this.queryParams.putAll(this.formParts);
        }
        if (this.queryParams != null) {
            this.queryString = Urls.buildQueryString(this.queryParams, (boolean)this.queryStringEncode);
            this.url = this.url + "?" + this.queryString;
        }
    }

    protected boolean isNoBodyRequest() {
        return HttpMethod.GET.method().equals(this.method) || HttpMethod.HEAD.method().equals(this.method) || HttpMethod.DELETE.method().equals(this.method) || HttpMethod.OPTIONS.method().equals(this.method) || HttpMethod.TRACE.method().equals(this.method);
    }

    public String getUrl() {
        return this.url;
    }

    public String getMethod() {
        return this.method;
    }

    public Map<String, Object> getQueryParams() {
        return this.queryParams;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public boolean isQueryStringEncode() {
        return this.queryStringEncode;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Collection<String> getIgnoreHeaders() {
        return this.ignoreHeaders;
    }

    public Collection<HttpCookie> getCookies() {
        return this.cookies;
    }

    public Map<String, String> getFormParts() {
        return this.formParts;
    }

    public byte[] getBody() {
        return this.body;
    }

    public int getBodyOffset() {
        return this.bodyOffset;
    }

    public int getBodyLen() {
        return this.bodyLen;
    }

    public String toString() {
        return this.method + " " + this.url;
    }
}

