/*
 * Decompiled with CFR 0.152.
 */
package com.orion.ext.watch.folder;

import com.orion.ext.watch.folder.WatchEventKind;
import com.orion.ext.watch.folder.handler.WatchHandler;
import com.orion.lang.able.SafeCloseable;
import com.orion.lang.able.Stoppable;
import com.orion.lang.able.Watchable;
import com.orion.lang.utils.Arrays1;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Valid;
import com.orion.lang.utils.io.Streams;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class FolderWatcher
implements Runnable,
Watchable,
Stoppable,
SafeCloseable {
    protected WatchHandler handler;
    protected WatchEvent.Kind<?>[] kinds;
    protected WatchEvent.Modifier[] modifiers;
    protected volatile boolean run;
    protected WatchService watchService;
    protected Map<WatchKey, Path> watchKeys = new LinkedHashMap<WatchKey, Path>();

    protected FolderWatcher(WatchHandler handler, WatchEventKind ... kinds) {
        this(handler, (WatchEvent.Modifier[])null, (WatchEvent.Kind<?>[])((WatchEvent.Kind[])Arrays1.mapper((Object[])kinds, WatchEvent.Kind[]::new, WatchEventKind::getValue)));
    }

    protected FolderWatcher(WatchHandler handler, WatchEvent.Kind<?> ... kinds) {
        this(handler, (WatchEvent.Modifier[])null, kinds);
    }

    protected FolderWatcher(WatchHandler handler, WatchEvent.Modifier[] modifiers, WatchEventKind ... kinds) {
        this(handler, modifiers, (WatchEvent.Kind[])Arrays1.mapper((Object[])kinds, WatchEvent.Kind[]::new, WatchEventKind::getValue));
    }

    protected FolderWatcher(WatchHandler handler, WatchEvent.Modifier[] modifiers, WatchEvent.Kind<?> ... kinds) {
        Valid.notNull((Object)handler, (String)"watch handler is null", (Object[])new Object[0]);
        this.handler = handler;
        this.modifiers = modifiers;
        this.kinds = (WatchEvent.Kind[])Arrays1.def((Object[])kinds, (Object[])WatchEventKind.ALL);
        this.init();
    }

    protected void init() {
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
        }
        catch (IOException e) {
            throw Exceptions.watch((Throwable)e);
        }
    }

    public void registerPath(String path) {
        this.registerPath(Paths.get(path, new String[0]), 1);
    }

    public void registerPath(File path) {
        this.registerPath(Paths.get(path.getAbsolutePath(), new String[0]), 1);
    }

    public void registerPath(URI path) {
        this.registerPath(Paths.get(path), 1);
    }

    public void registerPath(Path path) {
        this.registerPath(path, 1);
    }

    public void registerPath(String path, int maxDepth) {
        this.registerPath(Paths.get(path, new String[0]), maxDepth);
    }

    public void registerPath(File path, int maxDepth) {
        this.registerPath(Paths.get(path.getAbsolutePath(), new String[0]), maxDepth);
    }

    public void registerPath(URI path, int maxDepth) {
        this.registerPath(Paths.get(path), maxDepth);
    }

    public void registerPath(Path path, int maxDepth) {
        block6: {
            boolean exists = Files.exists(path, LinkOption.NOFOLLOW_LINKS);
            boolean isDir = Files.isDirectory(path, new LinkOption[0]);
            if (!exists || !isDir) {
                try {
                    Files.createDirectories(path, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw Exceptions.ioRuntime((Throwable)e);
                }
            }
            try {
                WatchKey key = Arrays1.isEmpty((Object[])this.modifiers) ? path.register(this.watchService, this.kinds) : path.register(this.watchService, this.kinds, this.modifiers);
                this.watchKeys.put(key, path);
                if (maxDepth > 1) {
                    Files.walkFileTree(path, EnumSet.noneOf(FileVisitOption.class), maxDepth, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                            FolderWatcher.this.registerPath(dir, 0);
                            return super.postVisitDirectory(dir, exc);
                        }
                    });
                }
            }
            catch (IOException e) {
                if (e instanceof AccessDeniedException) break block6;
                throw Exceptions.watch((Throwable)e);
            }
        }
    }

    @Override
    public void run() {
        this.run = true;
        this.watch();
    }

    public void stop() {
        this.run = false;
    }

    public void close() {
        this.stop();
        Streams.close((AutoCloseable)this.watchService);
    }

    public Collection<Path> getWatchPaths() {
        return this.watchKeys.values();
    }
}

