/*
 * Decompiled with CFR 0.152.
 */
package com.orion.ext.watch.folder;

import com.orion.ext.watch.folder.FolderWatcher;
import com.orion.ext.watch.folder.WatchEventKind;
import com.orion.ext.watch.folder.handler.WatchHandler;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;

public class BlockFolderWatcher
extends FolderWatcher {
    public BlockFolderWatcher(WatchHandler handler, WatchEventKind ... kinds) {
        super(handler, kinds);
    }

    public BlockFolderWatcher(WatchHandler handler, WatchEvent.Kind<?> ... kinds) {
        super(handler, kinds);
    }

    public BlockFolderWatcher(WatchHandler handler, WatchEvent.Modifier[] modifiers, WatchEventKind ... kinds) {
        super(handler, modifiers, kinds);
    }

    public BlockFolderWatcher(WatchHandler handler, WatchEvent.Modifier[] modifiers, WatchEvent.Kind<?> ... kinds) {
        super(handler, modifiers, kinds);
    }

    public void watch() {
        while (this.run) {
            WatchKey wk;
            try {
                wk = this.watchService.take();
            }
            catch (InterruptedException | ClosedWatchServiceException e) {
                return;
            }
            Path currentPath = (Path)this.watchKeys.get(wk);
            for (WatchEvent<?> event : wk.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW) {
                    this.handler.onOverflow(event, currentPath);
                    continue;
                }
                if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                    this.handler.onModify(event, currentPath);
                    continue;
                }
                if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                    this.handler.onCreate(event, currentPath);
                    continue;
                }
                if (kind != StandardWatchEventKinds.ENTRY_DELETE) continue;
                this.handler.onDelete(event, currentPath);
            }
            wk.reset();
        }
    }
}

