/*
 * Decompiled with CFR 0.152.
 */
package com.orion.ext.watch.file;

import com.orion.ext.watch.file.FileWatchEvent;
import com.orion.ext.watch.file.FileWatcher;
import com.orion.ext.watch.file.handler.EventHandler;
import com.orion.lang.utils.Arrays1;
import com.orion.lang.utils.Threads;
import com.orion.lang.utils.Valid;
import com.orion.lang.utils.io.FileAttribute;
import com.orion.lang.utils.io.Files1;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DelayFileWatcher
extends FileWatcher {
    private final int delayMillis;
    private final Map<File, FileAttribute> watchKeys;
    private final FileWatchEvent[] events;
    private final EventHandler eventHandler;
    private final boolean inCreateEvent;
    private volatile boolean run;

    public DelayFileWatcher(EventHandler handler, FileWatchEvent ... events) {
        this(5000, handler, events);
    }

    public DelayFileWatcher(int delayMillis, EventHandler handler, FileWatchEvent ... events) {
        Valid.notNull((Object)handler, (String)"event handler is null", (Object[])new Object[0]);
        this.delayMillis = delayMillis;
        this.eventHandler = handler;
        this.events = (FileWatchEvent[])Arrays1.def((Object[])events, (Object[])FileWatchEvent.ALL);
        this.inCreateEvent = Arrays1.contains((Object[])this.events, (Object)((Object)FileWatchEvent.CREATE));
        this.watchKeys = new LinkedHashMap<File, FileAttribute>();
    }

    public DelayFileWatcher addFile(String ... files) {
        for (String file : files) {
            this.add(new File(file));
        }
        return this;
    }

    public DelayFileWatcher addFile(File ... files) {
        for (File file : files) {
            this.add(file);
        }
        return this;
    }

    public DelayFileWatcher addFiles(String file) {
        return this.addFiles(new File(file), false);
    }

    public DelayFileWatcher addFiles(File file) {
        return this.addFiles(file, false);
    }

    public DelayFileWatcher addFiles(String file, boolean child) {
        return this.addFiles(new File(file), child);
    }

    public DelayFileWatcher addFiles(File file, boolean child) {
        List files = Files1.listFiles((File)file, (boolean)child);
        for (File f : files) {
            this.add(f);
        }
        return this;
    }

    private void add(File file) {
        boolean exists = file.exists();
        if (exists && file.isDirectory()) {
            return;
        }
        if (!exists && !this.inCreateEvent) {
            return;
        }
        this.watchKeys.put(file, Files1.getAttribute((File)file));
    }

    public void watch() {
        this.run = true;
        while (this.run) {
            for (File file : this.watchKeys.keySet()) {
                FileAttribute currAttr = Files1.getAttribute((File)file);
                FileAttribute beforeAttr = this.watchKeys.put(file, currAttr);
                block8: for (FileWatchEvent event : this.events) {
                    switch (event) {
                        case ACCESS: {
                            if (beforeAttr == null || currAttr == null || beforeAttr.getAccessTime() == currAttr.getAccessTime()) continue block8;
                            this.eventHandler.onAccess(file, beforeAttr, currAttr);
                            continue block8;
                        }
                        case MODIFIED: {
                            if (beforeAttr == null || currAttr == null || beforeAttr.getModifiedTime() == currAttr.getModifiedTime()) continue block8;
                            this.eventHandler.onModified(file, beforeAttr, currAttr);
                            continue block8;
                        }
                        case CREATE: {
                            if (beforeAttr != null || currAttr == null) continue block8;
                            this.eventHandler.onCreate(file, currAttr);
                            continue block8;
                        }
                        case DELETE: {
                            if (beforeAttr == null || currAttr != null) continue block8;
                            this.eventHandler.onDelete(file, beforeAttr);
                            continue block8;
                        }
                    }
                }
            }
            Threads.sleep((long)this.delayMillis);
        }
    }

    public void stop() {
        this.run = false;
    }

    @Override
    public boolean isRun() {
        return this.run;
    }
}

