/*
 * Decompiled with CFR 0.152.
 */
package com.orion.ext.vcs.git;

import com.orion.ext.vcs.git.info.BranchInfo;
import com.orion.ext.vcs.git.info.LogInfo;
import com.orion.lang.able.SafeCloseable;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.io.Streams;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.RebaseCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;

public abstract class Gits
implements SafeCloseable {
    private final Git git;
    private CredentialsProvider credentialsProvider;

    protected Gits(Git git) {
        this.git = git;
    }

    public static Gits of(Git git) {
        return new Gits(git){};
    }

    public static Gits of(File path) {
        try {
            return new Gits(Git.open((File)path)){};
        }
        catch (IOException e) {
            throw Exceptions.vcs((Throwable)e);
        }
    }

    public static Gits of(Repository repo) {
        return new Gits(Git.wrap((Repository)repo)){};
    }

    public static Gits clone(String url, File path) {
        return Gits.clone(url, path, null, (char[])null);
    }

    public static Gits clone(String url, File path, String username, String password) {
        return Gits.clone(url, path, username, password.toCharArray());
    }

    public static Gits clone(String url, File path, String username, char[] password) {
        try {
            CloneCommand clone = Git.cloneRepository().setURI(url).setDirectory(path);
            UsernamePasswordCredentialsProvider credential = null;
            if (username != null && password != null) {
                credential = new UsernamePasswordCredentialsProvider(username, password);
                clone.setCredentialsProvider((CredentialsProvider)credential);
            }
            Gits gits = new Gits(clone.call()){};
            gits.credentialsProvider = credential;
            return gits;
        }
        catch (Exception e) {
            throw Exceptions.vcs((Throwable)e);
        }
    }

    public Gits auth(String username, String password) {
        return this.auth(username, password.toCharArray());
    }

    public Gits auth(String username, char[] password) {
        this.credentialsProvider = new UsernamePasswordCredentialsProvider(username, password);
        return this;
    }

    public Gits checkout(String branchName) {
        try {
            this.git.checkout().setName(branchName).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.NOTRACK).setCreateBranch(false).call();
            return this;
        }
        catch (Exception e) {
            throw Exceptions.vcs((Throwable)e);
        }
    }

    public Gits pull() {
        return this.pull(null, null);
    }

    public Gits pull(String remote) {
        return this.pull(remote, null);
    }

    public Gits pull(String remote, String remoteBranch) {
        try {
            PullCommand pull = this.git.pull();
            if (this.credentialsProvider != null) {
                pull.setCredentialsProvider(this.credentialsProvider);
            }
            if (remote != null) {
                pull.setRemote(remote);
            }
            if (remoteBranch != null) {
                pull.setRemoteBranchName(remoteBranch);
            }
            pull.call();
            return this;
        }
        catch (Exception e) {
            throw Exceptions.vcs((Throwable)e);
        }
    }

    public Gits push(String remote) {
        try {
            PushCommand push = this.git.push();
            if (this.credentialsProvider != null) {
                push.setCredentialsProvider(this.credentialsProvider);
            }
            if (remote != null) {
                push.setRemote(remote);
            }
            push.call();
            return this;
        }
        catch (Exception e) {
            throw Exceptions.vcs((Throwable)e);
        }
    }

    public Gits fetch() {
        return this.fetch(null);
    }

    public Gits fetch(String remote) {
        try {
            FetchCommand fetch = this.git.fetch();
            if (this.credentialsProvider != null) {
                fetch.setCredentialsProvider(this.credentialsProvider);
            }
            if (remote != null) {
                fetch.setRemote(remote);
            }
            fetch.call();
            return this;
        }
        catch (Exception e) {
            throw Exceptions.vcs((Throwable)e);
        }
    }

    public Gits rebase() {
        return this.rebase(RebaseCommand.Operation.CONTINUE);
    }

    public Gits rebase(RebaseCommand.Operation operation) {
        try {
            this.git.rebase().setOperation(operation).call();
            return this;
        }
        catch (Exception e) {
            throw Exceptions.vcs((Throwable)e);
        }
    }

    public Gits reset(String commitId) {
        return this.reset(commitId, ResetCommand.ResetType.HARD);
    }

    public Gits reset(String commitId, ResetCommand.ResetType type) {
        try {
            this.git.reset().setRef(commitId).setMode(type).call();
            return this;
        }
        catch (Exception e) {
            throw Exceptions.vcs((Throwable)e);
        }
    }

    public List<BranchInfo> branchList() {
        return this.branchList(null);
    }

    public List<BranchInfo> branchList(String branch) {
        try {
            List refs = this.git.branchList().setContains(branch).setListMode(ListBranchCommand.ListMode.REMOTE).call();
            return refs.stream().filter(r -> r.getName().startsWith("refs/remotes")).map(ref -> {
                BranchInfo info = new BranchInfo();
                String name = ref.getName().substring(13);
                info.setId(ref.getObjectId().getName());
                info.setRemote(name.substring(0, name.indexOf("/")));
                info.setName(name.substring(name.indexOf("/") + 1));
                return info;
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw Exceptions.vcs((Throwable)e);
        }
    }

    public List<LogInfo> logList() {
        try {
            return this.logList(this.git.getRepository().getBranch(), 10);
        }
        catch (Exception e) {
            throw Exceptions.vcs((Throwable)e);
        }
    }

    public List<LogInfo> logList(int count) {
        try {
            return this.logList(this.git.getRepository().getBranch(), count);
        }
        catch (Exception e) {
            throw Exceptions.vcs((Throwable)e);
        }
    }

    public List<LogInfo> logList(String branch) {
        return this.logList(branch, 10);
    }

    public List<LogInfo> logList(String branch, int count) {
        try {
            Repository repo = this.git.getRepository();
            Ref b = (Ref)this.git.branchList().setContains(branch).setListMode(ListBranchCommand.ListMode.ALL).call().get(0);
            if (b == null) {
                return new ArrayList<LogInfo>();
            }
            ObjectId bid = repo.resolve(b.getName());
            Iterable commits = this.git.log().setMaxCount(count).add((AnyObjectId)bid).call();
            ArrayList<LogInfo> logs = new ArrayList<LogInfo>();
            for (RevCommit commit : commits) {
                LogInfo log = new LogInfo();
                log.setId(commit.getId().name());
                log.setEmail(commit.getCommitterIdent().getName());
                log.setName(commit.getCommitterIdent().getName());
                log.setTime(commit.getCommitTime());
                log.setMessage(commit.getFullMessage());
                logs.add(log);
            }
            return logs;
        }
        catch (Exception e) {
            throw Exceptions.vcs((Throwable)e);
        }
    }

    public Gits clean() {
        try {
            this.git.clean().setForce(true).setCleanDirectories(true).call();
            return this;
        }
        catch (Exception e) {
            throw Exceptions.vcs((Throwable)e);
        }
    }

    public String getDirectory() {
        return this.git.getRepository().getDirectory().getParent();
    }

    public String getRemoteUrl() {
        return this.git.getRepository().getConfig().getString("remote", "origin", "url");
    }

    public String getBranch() {
        try {
            return this.git.getRepository().getBranch();
        }
        catch (Exception e) {
            throw Exceptions.vcs((Throwable)e);
        }
    }

    public boolean hasRef(String name) {
        try {
            return this.git.getRepository().findRef(name) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Ref getRef(String name) {
        try {
            return this.git.getRepository().findRef(name);
        }
        catch (Exception e) {
            throw Exceptions.vcs((Throwable)e);
        }
    }

    public Git getGit() {
        return this.git;
    }

    public Repository getRepository() {
        return this.git.getRepository();
    }

    public void close() {
        Streams.close((AutoCloseable)this.git);
    }
}

