/*
 * Decompiled with CFR 0.152.
 */
package com.orion.ext.tail.delay;

import com.orion.ext.tail.delay.AbstractDelayTracker;
import com.orion.ext.tail.handler.LineHandler;
import com.orion.lang.utils.Spells;
import com.orion.lang.utils.Strings;
import com.orion.lang.utils.Valid;
import com.orion.lang.utils.io.FileReaders;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class DelayTracker
extends AbstractDelayTracker {
    private int accessCount;
    private final LineHandler handler;

    public DelayTracker(String tailFile, LineHandler handler) {
        this(new File(tailFile), handler);
    }

    public DelayTracker(File tailFile, LineHandler handler) {
        super(tailFile);
        this.handler = (LineHandler)Valid.notNull((Object)handler, (String)"line handler is null", (Object[])new Object[0]);
    }

    @Override
    protected void read() throws IOException {
        String[] lines;
        String read = FileReaders.readAllLines((RandomAccessFile)this.reader, (String)this.charset);
        if (read == null || read.isEmpty()) {
            return;
        }
        for (String line : lines = Strings.replaceCRLF((String)read).split("\n")) {
            this.handler.readLine(line, this.accessCount++, this);
        }
    }

    private static String cleanMissCode(String str) {
        int testCount;
        for (int i = testCount = Math.min(str.length(), 2); i > 0; --i) {
            if (!Spells.isMessyCode((String)String.valueOf(str.charAt(i - 1)))) continue;
            str = str.substring(i);
            break;
        }
        return str;
    }
}

