/*
 * Decompiled with CFR 0.152.
 */
package com.orion.ext.process;

import com.orion.ext.process.BaseProcessExecutor;
import com.orion.lang.define.thread.HookRunnable;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Strings;
import com.orion.lang.utils.Threads;
import com.orion.lang.utils.io.Streams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class ProcessAwaitExecutor
extends BaseProcessExecutor {
    private ProcessBuilder pb;
    private Process process;
    private InputStream inputStream;
    private InputStream errorStream;
    private OutputStream outputStream;
    private boolean inherit;
    private long waitFor = -1L;
    private Consumer<InputStream> streamHandler;
    private Consumer<InputStream> errorStreamHandler;
    protected Runnable callback;
    protected ExecutorService scheduler;
    private boolean sync;
    private volatile boolean done;
    private volatile boolean close;

    public ProcessAwaitExecutor(String command) {
        this(new String[]{command}, null);
    }

    public ProcessAwaitExecutor(String[] command) {
        this(command, null);
    }

    public ProcessAwaitExecutor(String command, String dir) {
        this(new String[]{command}, dir);
    }

    public ProcessAwaitExecutor(String[] command, String dir) {
        super(command, dir);
    }

    public ProcessAwaitExecutor inherit() {
        this.inherit = true;
        return this;
    }

    public ProcessAwaitExecutor waitFor() {
        this.waitFor = 0L;
        return this;
    }

    public ProcessAwaitExecutor waitFor(long timeout) {
        this.waitFor = timeout;
        return this;
    }

    public ProcessAwaitExecutor sync() {
        this.sync = true;
        this.waitFor = 0L;
        return this;
    }

    public ProcessAwaitExecutor streamHandler(Consumer<InputStream> streamHandler) {
        this.streamHandler = streamHandler;
        return this;
    }

    public ProcessAwaitExecutor errorStreamHandler(Consumer<InputStream> errorStreamHandler) {
        this.errorStreamHandler = errorStreamHandler;
        return this;
    }

    public ProcessAwaitExecutor scheduler(ExecutorService scheduler) {
        this.scheduler = scheduler;
        return this;
    }

    public ProcessAwaitExecutor callback(Runnable callback) {
        this.callback = callback;
        return this;
    }

    public ProcessAwaitExecutor write(String command) {
        return this.write(Strings.bytes((String)command), false);
    }

    public ProcessAwaitExecutor writeLine(String command) {
        return this.write(Strings.bytes((String)command), true);
    }

    public ProcessAwaitExecutor write(String command, String charset) {
        return this.write(Strings.bytes((String)command, (String)charset), false);
    }

    public ProcessAwaitExecutor writeLine(String command, String charset) {
        return this.write(Strings.bytes((String)command, (String)charset), true);
    }

    public ProcessAwaitExecutor write(byte[] command) {
        return this.write(command, false);
    }

    public ProcessAwaitExecutor write(byte[] command, boolean lf) {
        try {
            this.outputStream.write(command);
            if (lf) {
                this.outputStream.write(10);
            }
            this.outputStream.flush();
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime((Throwable)e);
        }
        return this;
    }

    public ProcessAwaitExecutor interrupt() {
        return this.write(new byte[]{3}, true);
    }

    public ProcessAwaitExecutor hangUp() {
        return this.write(new byte[]{24}, true);
    }

    public ProcessAwaitExecutor exit() {
        return this.write(Strings.bytes((String)"exit 0"), true);
    }

    public void exec() {
        if (this.streamHandler == null) {
            throw Exceptions.runtime((String)"streamHandler is null");
        }
        try {
            this.pb = new ProcessBuilder(this.command);
            this.env = this.pb.environment();
            if (this.removeEnv != null) {
                for (String key : this.removeEnv) {
                    this.env.remove(key);
                }
            }
            if (this.addEnv != null) {
                this.env.putAll(this.addEnv);
            }
            this.pb.directory(this.dir == null ? null : new File(this.dir));
            if (this.inherit) {
                this.pb.inheritIO();
            }
            this.process = this.pb.redirectErrorStream(this.redirectError).start();
            this.outputStream = this.process.getOutputStream();
            this.inputStream = this.process.getInputStream();
            this.errorStream = this.process.getErrorStream();
            this.listenerInputAndError();
            if (this.waitFor != -1L) {
                if (this.waitFor != 0L) {
                    this.process.waitFor(this.waitFor, TimeUnit.MILLISECONDS);
                } else {
                    this.process.waitFor();
                }
            }
        }
        catch (Exception e) {
            throw Exceptions.runtime((Throwable)e);
        }
    }

    @Override
    public void close() {
        this.close(false);
    }

    public void close(boolean exit) {
        this.close = true;
        if (exit && this.outputStream != null) {
            try {
                this.write(Strings.bytes((String)"exit 0"));
            }
            catch (Exception e1) {
                Exceptions.printStacks((Throwable)e1);
            }
        }
        if (this.process != null) {
            this.process.destroy();
        }
        Streams.close((AutoCloseable)this.inputStream);
        Streams.close((AutoCloseable)this.outputStream);
        Streams.close((AutoCloseable)this.errorStream);
    }

    @Override
    public boolean isAlive() {
        return this.process.isAlive();
    }

    @Override
    public int getExitCode() {
        if (!this.process.isAlive()) {
            return this.process.exitValue();
        }
        return -1;
    }

    @Override
    public Process getProcess() {
        return this.process;
    }

    @Override
    public ProcessBuilder getProcessBuilder() {
        return this.pb;
    }

    private void listenerInputAndError() {
        if (!this.sync) {
            HookRunnable runnable = new HookRunnable(() -> {
                this.streamHandler.accept(this.inputStream);
                if (this.errorStreamHandler != null && !this.redirectError) {
                    this.errorStreamHandler.accept(this.errorStream);
                }
            }, () -> {
                this.done = true;
                if (this.callback != null) {
                    this.callback.run();
                }
            }, true);
            Threads.start((Runnable)runnable, (ExecutorService)this.scheduler);
        } else {
            try {
                this.streamHandler.accept(this.inputStream);
            }
            finally {
                this.done = true;
                if (this.callback != null) {
                    this.callback.run();
                }
            }
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public InputStream getErrorStream() {
        return this.errorStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public boolean isInherit() {
        return this.inherit;
    }

    public long getWaitFor() {
        return this.waitFor;
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean isClose() {
        return this.close;
    }
}

