/*
 * Decompiled with CFR 0.152.
 */
package com.orion.ext.process;

import com.orion.lang.able.Executable;
import com.orion.lang.able.SafeCloseable;
import com.orion.lang.utils.Systems;
import com.orion.lang.utils.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseProcessExecutor
implements Executable,
SafeCloseable {
    private static final ArrayList<String> COMMAND = new ArrayList();
    protected String[] command;
    protected String dir;
    protected boolean redirectError;
    protected Map<String, String> env;
    protected Map<String, String> addEnv;
    protected List<String> removeEnv;

    protected BaseProcessExecutor(String command) {
        this(new String[]{command}, null);
    }

    protected BaseProcessExecutor(String[] command) {
        this(command, null);
    }

    protected BaseProcessExecutor(String command, String dir) {
        this(new String[]{command}, dir);
    }

    protected BaseProcessExecutor(String[] command, String dir) {
        this.command = command;
        this.dir = dir;
    }

    public abstract void close();

    public abstract boolean isAlive();

    public abstract int getExitCode();

    public abstract Process getProcess();

    public abstract ProcessBuilder getProcessBuilder();

    public BaseProcessExecutor terminal() {
        List<String> c = BaseProcessExecutor.getTerminalCommand();
        for (String s : this.command) {
            c.add(s.replaceAll("\n", " ").replaceAll("\r", " "));
        }
        this.command = c.toArray(new String[0]);
        return this;
    }

    public BaseProcessExecutor dir(String dir) {
        this.dir = dir;
        return this;
    }

    public BaseProcessExecutor redirectError() {
        this.redirectError = true;
        return this;
    }

    public BaseProcessExecutor addEnv(String key, String value) {
        if (this.addEnv == null) {
            this.addEnv = new HashMap<String, String>();
        }
        this.addEnv.put(key, value);
        return this;
    }

    public BaseProcessExecutor addEnv(Map<String, String> env) {
        if (this.addEnv == null) {
            this.addEnv = new HashMap<String, String>();
        }
        this.addEnv.putAll(env);
        return this;
    }

    public BaseProcessExecutor removeEnv(String ... keys) {
        if (this.removeEnv == null) {
            this.removeEnv = new ArrayList<String>();
        }
        if (keys != null) {
            this.removeEnv.addAll(Arrays.asList(keys));
        }
        return this;
    }

    public BaseProcessExecutor removeEnv(List<String> keys) {
        if (this.removeEnv == null) {
            this.removeEnv = new ArrayList<String>();
        }
        if (keys != null) {
            this.removeEnv.addAll(keys);
        }
        return this;
    }

    protected static List<String> getTerminalCommand() {
        return (List)COMMAND.clone();
    }

    public String[] getCommand() {
        return this.command;
    }

    public String getDir() {
        return this.dir;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public Map<String, String> getAddEnv() {
        return this.addEnv;
    }

    public String toString() {
        return Lists.join((Collection)Lists.of((Object[])this.command), (String)" ");
    }

    static {
        if (Systems.BE_WINDOWS) {
            COMMAND.add("cmd");
            COMMAND.add("/c");
        } else {
            COMMAND.add("/bin/bash");
            COMMAND.add("-c");
        }
    }
}

