/*
 * Decompiled with CFR 0.152.
 */
package com.orion.ext.mail;

import com.orion.lang.utils.Valid;
import com.orion.lang.utils.io.Files1;
import com.orion.lang.utils.io.Streams;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeUtility;
import javax.mail.util.ByteArrayDataSource;

public class MailAttachment
implements Serializable {
    private String name;
    private InputStream body;
    private String contentType = "application/octet-stream";
    private String charset = "UTF-8";
    private boolean autoClose;

    public MailAttachment() {
    }

    public MailAttachment(String file) {
        this(Files1.openInputStreamFastSafe((String)file), Files1.getFileName((String)file), true);
    }

    public MailAttachment(File file) {
        this(Files1.openInputStreamFastSafe((File)file), file.getName(), true);
    }

    public MailAttachment(byte[] body, String name) {
        this(Streams.toInputStream((byte[])body), name, true);
    }

    public MailAttachment(InputStream body, String name) {
        this(body, name, false);
    }

    public MailAttachment(InputStream body, String name, boolean autoClose) {
        this();
        Valid.notNull((Object)body, (String)"attachment body is null", (Object[])new Object[0]);
        Valid.notBlank((String)name, (String)"attachment file name is blank", (Object[])new Object[0]);
        this.body = body;
        this.name = name;
        this.autoClose = autoClose;
    }

    public MailAttachment name(String name) {
        Valid.notBlank((String)name, (String)"attachment file name is blank", (Object[])new Object[0]);
        this.name = name;
        return this;
    }

    public MailAttachment body(InputStream body) {
        Valid.notNull((Object)body, (String)"attachment body is null", (Object[])new Object[0]);
        this.body = body;
        return this;
    }

    public MailAttachment contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public MailAttachment charset(String charset) {
        this.charset = charset;
        return this;
    }

    public MimeBodyPart getMimeBodyPart() throws Exception {
        try {
            MimeBodyPart attach = new MimeBodyPart();
            attach.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(this.body, this.contentType)));
            attach.setFileName(MimeUtility.encodeText((String)this.name, (String)this.charset, null));
            MimeBodyPart mimeBodyPart = attach;
            return mimeBodyPart;
        }
        finally {
            if (this.autoClose) {
                Streams.close((AutoCloseable)this.body);
            }
        }
    }
}

