/*
 * Decompiled with CFR 0.152.
 */
package com.orion.ext.location.region.core;

import com.orion.ext.location.region.block.DataBlock;
import com.orion.ext.location.region.block.IndexBlock;
import com.orion.ext.location.region.config.DbConfig;
import com.orion.ext.location.region.core.RegionSupport;
import com.orion.lang.utils.io.Files1;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;

public class DbSearcher {
    public static final int BTREE_ALGORITHM = 1;
    public static final int BINARY_ALGORITHM = 2;
    public static final int MEMORY_ALGORITHM = 3;
    private final DbConfig dbConfig;
    private final RandomAccessFile raf;
    private long[] headerSip = null;
    private int[] headerPtr = null;
    private int headerLength;
    private long firstIndexPtr = 0L;
    private long lastIndexPtr = 0L;
    private int totalIndexBlocks = 0;
    private byte[] dbBinStr = null;

    public DbSearcher(DbConfig dbConfig, String dbFile) {
        this.dbConfig = dbConfig;
        this.raf = Files1.openRandomAccessSafe((String)dbFile, (String)"r");
    }

    public DbSearcher(DbConfig dbConfig, File dbFile) {
        this.dbConfig = dbConfig;
        this.raf = Files1.openRandomAccessSafe((File)dbFile, (String)"r");
    }

    public DbSearcher(DbConfig dbConfig, RandomAccessFile raf) {
        this.dbConfig = dbConfig;
        this.raf = raf;
    }

    public DataBlock memorySearch(long ip) throws IOException {
        int blen = IndexBlock.getIndexBlockLength();
        if (this.dbBinStr == null) {
            this.dbBinStr = new byte[(int)this.raf.length()];
            this.raf.seek(0L);
            this.raf.readFully(this.dbBinStr, 0, this.dbBinStr.length);
            this.firstIndexPtr = RegionSupport.getIntLong(this.dbBinStr, 0);
            this.lastIndexPtr = RegionSupport.getIntLong(this.dbBinStr, 4);
            this.totalIndexBlocks = (int)((this.lastIndexPtr - this.firstIndexPtr) / (long)blen) + 1;
        }
        int l = 0;
        int h = this.totalIndexBlocks;
        long dataptr = 0L;
        while (l <= h) {
            int m = l + h >> 1;
            int p = (int)(this.firstIndexPtr + (long)(m * blen));
            long sip = RegionSupport.getIntLong(this.dbBinStr, p);
            if (ip < sip) {
                h = m - 1;
                continue;
            }
            long eip = RegionSupport.getIntLong(this.dbBinStr, p + 4);
            if (ip > eip) {
                l = m + 1;
                continue;
            }
            dataptr = RegionSupport.getIntLong(this.dbBinStr, p + 8);
            break;
        }
        if (dataptr == 0L) {
            return null;
        }
        int dataLen = (int)(dataptr >> 24 & 0xFFL);
        int dataPtr = (int)(dataptr & 0xFFFFFFL);
        return new DataBlock((int)RegionSupport.getIntLong(this.dbBinStr, dataPtr), new String(this.dbBinStr, dataPtr + 4, dataLen - 4, StandardCharsets.UTF_8), dataPtr);
    }

    public DataBlock memorySearch(String ip) throws IOException {
        return this.memorySearch(RegionSupport.ip2long(ip));
    }

    public DataBlock getByIndexPtr(long ptr) throws IOException {
        this.raf.seek(ptr);
        byte[] buffer = new byte[12];
        this.raf.readFully(buffer, 0, buffer.length);
        long extra = RegionSupport.getIntLong(buffer, 8);
        int dataLen = (int)(extra >> 24 & 0xFFL);
        int dataPtr = (int)(extra & 0xFFFFFFL);
        this.raf.seek(dataPtr);
        byte[] data = new byte[dataLen];
        this.raf.readFully(data, 0, data.length);
        int cityId = (int)RegionSupport.getIntLong(data, 0);
        return new DataBlock(cityId, new String(data, 4, data.length - 4, StandardCharsets.UTF_8), dataPtr);
    }

    public DataBlock btreeSearch(long ip) throws IOException {
        if (this.headerSip == null) {
            this.raf.seek(8L);
            byte[] b = new byte[4096];
            this.raf.readFully(b, 0, b.length);
            int len = b.length >> 3;
            int idx = 0;
            this.headerSip = new long[len];
            this.headerPtr = new int[len];
            for (int i = 0; i < b.length; i += 8) {
                long startIp = RegionSupport.getIntLong(b, i);
                long dataPtr = RegionSupport.getIntLong(b, i + 4);
                if (dataPtr == 0L) break;
                this.headerSip[idx] = startIp;
                this.headerPtr[idx] = (int)dataPtr;
                ++idx;
            }
            this.headerLength = idx;
        }
        if (ip == this.headerSip[0]) {
            return this.getByIndexPtr(this.headerPtr[0]);
        }
        if (ip == this.headerSip[this.headerLength - 1]) {
            return this.getByIndexPtr(this.headerPtr[this.headerLength - 1]);
        }
        int l = 0;
        int h = this.headerLength;
        int sptr = 0;
        int eptr = 0;
        while (l <= h) {
            int m = l + h >> 1;
            if (ip == this.headerSip[m]) {
                if (m > 0) {
                    sptr = this.headerPtr[m - 1];
                    eptr = this.headerPtr[m];
                    break;
                }
                sptr = this.headerPtr[m];
                eptr = this.headerPtr[m + 1];
                break;
            }
            if (ip < this.headerSip[m]) {
                if (m == 0) {
                    sptr = this.headerPtr[m];
                    eptr = this.headerPtr[m + 1];
                    break;
                }
                if (ip > this.headerSip[m - 1]) {
                    sptr = this.headerPtr[m - 1];
                    eptr = this.headerPtr[m];
                    break;
                }
                h = m - 1;
                continue;
            }
            if (m == this.headerLength - 1) {
                sptr = this.headerPtr[m - 1];
                eptr = this.headerPtr[m];
                break;
            }
            if (ip <= this.headerSip[m + 1]) {
                sptr = this.headerPtr[m];
                eptr = this.headerPtr[m + 1];
                break;
            }
            l = m + 1;
        }
        if (sptr == 0) {
            return null;
        }
        int blockLen = eptr - sptr;
        int blen = IndexBlock.getIndexBlockLength();
        byte[] iBuffer = new byte[blockLen + blen];
        this.raf.seek(sptr);
        this.raf.readFully(iBuffer, 0, iBuffer.length);
        l = 0;
        h = blockLen / blen;
        long dataptr = 0L;
        while (l <= h) {
            int m = l + h >> 1;
            int p = m * blen;
            long sip = RegionSupport.getIntLong(iBuffer, p);
            if (ip < sip) {
                h = m - 1;
                continue;
            }
            long eip = RegionSupport.getIntLong(iBuffer, p + 4);
            if (ip > eip) {
                l = m + 1;
                continue;
            }
            dataptr = RegionSupport.getIntLong(iBuffer, p + 8);
            break;
        }
        if (dataptr == 0L) {
            return null;
        }
        int dataLen = (int)(dataptr >> 24 & 0xFFL);
        int dataPtr = (int)(dataptr & 0xFFFFFFL);
        this.raf.seek(dataPtr);
        byte[] data = new byte[dataLen];
        this.raf.readFully(data, 0, data.length);
        return new DataBlock((int)RegionSupport.getIntLong(data, 0), new String(data, 4, data.length - 4, StandardCharsets.UTF_8), dataPtr);
    }

    public DataBlock btreeSearch(String ip) throws IOException {
        return this.btreeSearch(RegionSupport.ip2long(ip));
    }

    public DataBlock binarySearch(long ip) throws IOException {
        int blen = IndexBlock.getIndexBlockLength();
        if (this.totalIndexBlocks == 0) {
            this.raf.seek(0L);
            byte[] superBytes = new byte[8];
            this.raf.readFully(superBytes, 0, superBytes.length);
            this.firstIndexPtr = RegionSupport.getIntLong(superBytes, 0);
            this.lastIndexPtr = RegionSupport.getIntLong(superBytes, 4);
            this.totalIndexBlocks = (int)((this.lastIndexPtr - this.firstIndexPtr) / (long)blen) + 1;
        }
        int l = 0;
        int h = this.totalIndexBlocks;
        byte[] buffer = new byte[blen];
        long dataptr = 0L;
        while (l <= h) {
            int m = l + h >> 1;
            this.raf.seek(this.firstIndexPtr + (long)(m * blen));
            this.raf.readFully(buffer, 0, buffer.length);
            long sip = RegionSupport.getIntLong(buffer, 0);
            if (ip < sip) {
                h = m - 1;
                continue;
            }
            long eip = RegionSupport.getIntLong(buffer, 4);
            if (ip > eip) {
                l = m + 1;
                continue;
            }
            dataptr = RegionSupport.getIntLong(buffer, 8);
            break;
        }
        if (dataptr == 0L) {
            return null;
        }
        int dataLen = (int)(dataptr >> 24 & 0xFFL);
        int dataPtr = (int)(dataptr & 0xFFFFFFL);
        this.raf.seek(dataPtr);
        byte[] data = new byte[dataLen];
        this.raf.readFully(data, 0, data.length);
        return new DataBlock((int)RegionSupport.getIntLong(data, 0), new String(data, 4, data.length - 4, StandardCharsets.UTF_8), dataPtr);
    }

    public DataBlock binarySearch(String ip) throws IOException {
        return this.binarySearch(RegionSupport.ip2long(ip));
    }

    public DbConfig getDbConfig() {
        return this.dbConfig;
    }

    public void close() throws IOException {
        this.headerSip = null;
        this.headerPtr = null;
        this.dbBinStr = null;
        this.raf.close();
    }
}

