/*
 * Decompiled with CFR 0.152.
 */
package com.orion.ext.location.region.block;

import com.orion.ext.location.region.core.RegionSupport;

public class IndexBlock {
    private static final int LENGTH = 12;
    private long startIp;
    private long endIp;
    private int dataPtr;
    private int dataLen;

    public IndexBlock(long startIp, long endIp, int dataPtr, int dataLen) {
        this.startIp = startIp;
        this.endIp = endIp;
        this.dataPtr = dataPtr;
        this.dataLen = dataLen;
    }

    public void setStartIp(long startIp) {
        this.startIp = startIp;
    }

    public void setEndIp(long endIp) {
        this.endIp = endIp;
    }

    public void setDataPtr(int dataPtr) {
        this.dataPtr = dataPtr;
    }

    public void setDataLen(int dataLen) {
        this.dataLen = dataLen;
    }

    public long getStartIp() {
        return this.startIp;
    }

    public long getEndIp() {
        return this.endIp;
    }

    public int getDataPtr() {
        return this.dataPtr;
    }

    public int getDataLen() {
        return this.dataLen;
    }

    public static int getIndexBlockLength() {
        return 12;
    }

    public byte[] getBytes() {
        byte[] b = new byte[12];
        RegionSupport.writeIntLong(b, 0, this.startIp);
        RegionSupport.writeIntLong(b, 4, this.endIp);
        long mix = (long)this.dataPtr | (long)(this.dataLen << 24) & 0xFF000000L;
        RegionSupport.writeIntLong(b, 8, mix);
        return b;
    }
}

