/*
 * Decompiled with CFR 0.152.
 */
package com.orion.ext.location.ext.core;

import com.orion.ext.location.LocationConst;
import com.orion.ext.location.Region;
import com.orion.ext.location.ext.core.IpLocation;
import com.orion.ext.location.ext.core.SeekerSupport;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.io.Files1;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class LocationSeeker {
    private static final int IP_RECORD_LENGTH = 7;
    private static final byte AREA_FOLLOWED = 1;
    private static final byte NO_AREA = 2;
    private HashMap<String, IpLocation> ipCache = new HashMap();
    private RandomAccessFile ipFile;
    private MappedByteBuffer mbb;
    private long ipBegin;
    private long ipEnd;
    private IpLocation loc = new IpLocation();
    private byte[] buf = new byte[100];
    private byte[] b4 = new byte[4];
    private byte[] b3 = new byte[3];

    public LocationSeeker(String file) {
        this(Files1.openRandomAccessSafe((String)file, (String)"r"));
    }

    public LocationSeeker(File file) {
        this(Files1.openRandomAccessSafe((File)file, (String)"r"));
    }

    public LocationSeeker(RandomAccessFile accessFile) {
        this.ipFile = accessFile;
        if (this.ipFile != null) {
            try {
                this.ipBegin = this.readLong4(0L);
                this.ipEnd = this.readLong4(4L);
                if (this.ipBegin == -1L || this.ipEnd == -1L) {
                    this.ipFile.close();
                    this.ipFile = null;
                }
            }
            catch (IOException e) {
                this.ipFile = null;
            }
        }
    }

    public List<IpEntry> getIPEntries(String s) {
        ArrayList<IpEntry> ret = new ArrayList<IpEntry>();
        try {
            if (this.mbb == null) {
                FileChannel fc = this.ipFile.getChannel();
                this.mbb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, this.ipFile.length());
                this.mbb.order(ByteOrder.LITTLE_ENDIAN);
            }
            int endOffset = (int)this.ipEnd;
            for (int offset = (int)this.ipBegin + 4; offset <= endOffset; offset += 7) {
                int temp = this.readInt3(offset);
                if (temp == -1) continue;
                IpLocation loc = this.getIpLocation(temp);
                if (!loc.country.contains(s) && !loc.area.contains(s)) continue;
                IpEntry entry = new IpEntry();
                entry.country = loc.country;
                entry.area = loc.area;
                this.readIP(offset - 4, this.b4);
                entry.beginIp = SeekerSupport.getIpStringFromBytes(this.b4);
                this.readIP(temp, this.b4);
                entry.endIp = SeekerSupport.getIpStringFromBytes(this.b4);
                ret.add(entry);
            }
        }
        catch (IOException e) {
            Exceptions.printStacks((Throwable)e);
        }
        return ret;
    }

    public List<IpEntry> getIPEntries1(String s) {
        ArrayList<IpEntry> ret = new ArrayList<IpEntry>();
        long endOffset = this.ipEnd + 4L;
        for (long offset = this.ipBegin + 4L; offset <= endOffset; offset += 7L) {
            long temp = this.readLong3(offset);
            if (temp == -1L) continue;
            IpLocation loc = this.getIpLocation(temp);
            if (loc.country.indexOf(s) == -1 && loc.area.indexOf(s) == -1) continue;
            IpEntry entry = new IpEntry();
            entry.country = loc.country;
            entry.area = loc.area;
            this.readIP(offset - 4L, this.b4);
            entry.beginIp = SeekerSupport.getIpStringFromBytes(this.b4);
            this.readIP(temp, this.b4);
            entry.endIp = SeekerSupport.getIpStringFromBytes(this.b4);
            ret.add(entry);
        }
        return ret;
    }

    public String getCountry(String ip) {
        return this.getCountry(SeekerSupport.getIpByteArrayFromString(ip));
    }

    public String getCountry(byte[] ip) {
        String ipStr = SeekerSupport.getIpStringFromBytes(ip);
        if (this.ipCache.containsKey(ipStr)) {
            return this.ipCache.get((Object)ipStr).country;
        }
        IpLocation loc = this.getIpLocation(ip);
        this.ipCache.put(ipStr, loc.copy());
        return loc.country;
    }

    public String getArea(String ip) {
        return this.getArea(SeekerSupport.getIpByteArrayFromString(ip));
    }

    public String getArea(byte[] ip) {
        String ipStr = SeekerSupport.getIpStringFromBytes(ip);
        if (this.ipCache.containsKey(ipStr)) {
            return this.ipCache.get((Object)ipStr).area;
        }
        IpLocation loc = this.getIpLocation(ip);
        this.ipCache.put(ipStr, loc.copy());
        return loc.area;
    }

    public String getAddress(String ip) {
        String address = this.getCountry(ip) + " " + this.getArea(ip);
        return address.trim();
    }

    public List<String> getAllIp() {
        ArrayList<String> list = new ArrayList<String>();
        byte[] buf = new byte[4];
        for (long i = this.ipBegin; i < this.ipEnd; i += 7L) {
            try {
                this.readIP(this.readLong3(i + 4L), buf);
                String ip = SeekerSupport.getIpStringFromBytes(buf);
                list.add(ip);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return list;
    }

    public IpLocation getIpLocation(String ip) {
        return this.getIpLocation(SeekerSupport.getIpByteArrayFromString(ip));
    }

    public IpLocation getIpLocation(byte[] ip) {
        IpLocation info = null;
        long offset = this.locateIP(ip);
        if (offset != -1L) {
            info = this.getIpLocation(offset);
        }
        if (info == null) {
            info = new IpLocation();
            info.country = LocationConst.UNKNOWN;
            info.area = LocationConst.UNKNOWN;
        }
        return info;
    }

    public Region getRegion(String ip) {
        Region info = new Region();
        if (ip == null || ip.trim().isEmpty()) {
            return info;
        }
        try {
            String country = this.getCountry(ip);
            if ("\u5c40\u57df\u7f51".equals(country)) {
                info.setCountry("\u4e2d\u56fd");
                info.setProvince("\u4e0a\u6d77\u5e02");
            } else if (country != null && !country.trim().isEmpty()) {
                country = country.trim();
                int length = country.length();
                int index = country.indexOf(30465);
                if (index > 0) {
                    info.setCountry("\u4e2d\u56fd");
                    if (index == length - 1) {
                        info.setProvince(country);
                    } else {
                        info.setProvince(country.substring(0, index + 1));
                        int cityIndex = country.indexOf(24066, index);
                        if (cityIndex > 0) {
                            info.setCity(country.substring(index + 1, Math.min(cityIndex + 1, length)));
                        }
                    }
                } else {
                    String h;
                    switch (h = country.substring(0, 2)) {
                        case "\u5185\u8499": {
                            info.setCountry("\u4e2d\u56fd");
                            info.setProvince("\u5185\u8499\u53e4\u81ea\u6cbb\u533a");
                            country = country.substring(3);
                            if (country.isEmpty() || (index = country.indexOf(24066)) <= 0) break;
                            info.setCity(country.substring(0, Math.min(index + 1, country.length())));
                            break;
                        }
                        case "\u5e7f\u897f": 
                        case "\u897f\u85cf": 
                        case "\u5b81\u590f": 
                        case "\u65b0\u7586": {
                            info.setCountry("\u4e2d\u56fd");
                            info.setProvince(h);
                            country = country.substring(2);
                            if (country.isEmpty() || (index = country.indexOf(24066)) <= 0) break;
                            info.setCity(country.substring(0, Math.min(index + 1, country.length())));
                            break;
                        }
                        case "\u4e0a\u6d77": 
                        case "\u5317\u4eac": 
                        case "\u5929\u6d25": 
                        case "\u91cd\u5e86": {
                            char ch;
                            info.setCountry("\u4e2d\u56fd");
                            info.setProvince(h + "\u5e02");
                            country = country.substring(3);
                            if (country.isEmpty()) break;
                            index = country.indexOf(21306);
                            if (index > 0 && ((ch = country.charAt(index - 1)) != '\u6821' || ch != '\u5c0f')) {
                                info.setCity(country.substring(0, Math.min(index + 1, country.length())));
                            }
                            if (!"unknown".equals(info.getCity()) || (index = country.indexOf(21439)) <= 0) break;
                            info.setCity(country.substring(0, Math.min(index + 1, country.length())));
                            break;
                        }
                        case "\u9999\u6e2f": 
                        case "\u6fb3\u95e8": {
                            info.setCountry("\u4e2d\u56fd");
                            info.setProvince(h + "\u7279\u522b\u884c\u653f\u533a");
                            break;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            Exceptions.printStacks((Throwable)e);
        }
        return info;
    }

    private int readInt3(int offset) {
        this.mbb.position(offset);
        return this.mbb.getInt() & 0xFFFFFF;
    }

    private int readInt3() {
        return this.mbb.getInt() & 0xFFFFFF;
    }

    private long readLong4(long offset) {
        long ret = 0L;
        try {
            this.ipFile.seek(offset);
            ret |= (long)(this.ipFile.readByte() & 0xFF);
            ret |= (long)(this.ipFile.readByte() << 8 & 0xFF00);
            ret |= (long)(this.ipFile.readByte() << 16 & 0xFF0000);
            return ret |= (long)(this.ipFile.readByte() << 24 & 0xFF000000);
        }
        catch (IOException e) {
            return -1L;
        }
    }

    private long readLong3(long offset) {
        long ret = 0L;
        try {
            this.ipFile.seek(offset);
            this.ipFile.readFully(this.b3);
            ret |= (long)(this.b3[0] & 0xFF);
            ret |= (long)(this.b3[1] << 8 & 0xFF00);
            return ret |= (long)(this.b3[2] << 16 & 0xFF0000);
        }
        catch (IOException e) {
            return -1L;
        }
    }

    private long readLong3() {
        long ret = 0L;
        try {
            this.ipFile.readFully(this.b3);
            ret |= (long)(this.b3[0] & 0xFF);
            ret |= (long)(this.b3[1] << 8 & 0xFF00);
            return ret |= (long)(this.b3[2] << 16 & 0xFF0000);
        }
        catch (IOException e) {
            return -1L;
        }
    }

    private void readIP(long offset, byte[] ip) {
        try {
            this.ipFile.seek(offset);
            this.ipFile.readFully(ip);
            byte temp = ip[0];
            ip[0] = ip[3];
            ip[3] = temp;
            temp = ip[1];
            ip[1] = ip[2];
            ip[2] = temp;
        }
        catch (IOException e) {
            Exceptions.printStacks((Throwable)e);
        }
    }

    private void readIP(int offset, byte[] ip) {
        this.mbb.position(offset);
        this.mbb.get(ip);
        byte temp = ip[0];
        ip[0] = ip[3];
        ip[3] = temp;
        temp = ip[1];
        ip[1] = ip[2];
        ip[2] = temp;
    }

    private int compareIP(byte[] ip, byte[] beginIp) {
        for (int i = 0; i < 4; ++i) {
            int r = this.compareByte(ip[i], beginIp[i]);
            if (r == 0) continue;
            return r;
        }
        return 0;
    }

    private int compareByte(byte b1, byte b2) {
        if ((b1 & 0xFF) > (b2 & 0xFF)) {
            return 1;
        }
        if ((b1 ^ b2) == 0) {
            return 0;
        }
        return -1;
    }

    private long locateIP(byte[] ip) {
        long m = 0L;
        this.readIP(this.ipBegin, this.b4);
        int r = this.compareIP(ip, this.b4);
        if (r == 0) {
            return this.ipBegin;
        }
        if (r < 0) {
            return -1L;
        }
        long i = this.ipBegin;
        long j = this.ipEnd;
        while (i < j) {
            m = this.getMiddleOffset(i, j);
            this.readIP(m, this.b4);
            r = this.compareIP(ip, this.b4);
            if (r > 0) {
                i = m;
                continue;
            }
            if (r < 0) {
                if (m == j) {
                    m = j -= 7L;
                    continue;
                }
                j = m;
                continue;
            }
            return this.readLong3(m + 4L);
        }
        m = this.readLong3(m + 4L);
        this.readIP(m, this.b4);
        r = this.compareIP(ip, this.b4);
        if (r <= 0) {
            return m;
        }
        return -1L;
    }

    private long getMiddleOffset(long begin, long end) {
        long records = (end - begin) / 7L;
        if ((records >>= 1) == 0L) {
            records = 1L;
        }
        return begin + records * 7L;
    }

    private IpLocation getIpLocation(long offset) {
        try {
            this.ipFile.seek(offset + 4L);
            byte b = this.ipFile.readByte();
            if (b == 1) {
                long countryOffset = this.readLong3();
                this.ipFile.seek(countryOffset);
                b = this.ipFile.readByte();
                if (b == 2) {
                    this.loc.country = this.readString(this.readLong3());
                    this.ipFile.seek(countryOffset + 4L);
                } else {
                    this.loc.country = this.readString(countryOffset);
                }
                this.loc.area = this.readArea(this.ipFile.getFilePointer());
            } else if (b == 2) {
                this.loc.country = this.readString(this.readLong3());
                this.loc.area = this.readArea(offset + 8L);
            } else {
                this.loc.country = this.readString(this.ipFile.getFilePointer() - 1L);
                this.loc.area = this.readArea(this.ipFile.getFilePointer());
            }
            return this.loc;
        }
        catch (IOException e) {
            Exceptions.printStacks((Throwable)e);
            return null;
        }
    }

    private IpLocation getIpLocation(int offset) {
        this.mbb.position(offset + 4);
        byte b = this.mbb.get();
        if (b == 1) {
            int countryOffset = this.readInt3();
            this.mbb.position(countryOffset);
            b = this.mbb.get();
            if (b == 2) {
                this.loc.country = this.readString(this.readInt3());
                this.mbb.position(countryOffset + 4);
            } else {
                this.loc.country = this.readString(countryOffset);
            }
            this.loc.area = this.readArea(this.mbb.position());
        } else if (b == 2) {
            this.loc.country = this.readString(this.readInt3());
            this.loc.area = this.readArea(offset + 8);
        } else {
            this.loc.country = this.readString(this.mbb.position() - 1);
            this.loc.area = this.readArea(this.mbb.position());
        }
        return this.loc;
    }

    private String readArea(long offset) throws IOException {
        this.ipFile.seek(offset);
        byte b = this.ipFile.readByte();
        if (b == 1 || b == 2) {
            long areaOffset = this.readLong3(offset + 1L);
            if (areaOffset == 0L) {
                return LocationConst.UNKNOWN;
            }
            return this.readString(areaOffset);
        }
        return this.readString(offset);
    }

    private String readArea(int offset) {
        this.mbb.position(offset);
        byte b = this.mbb.get();
        if (b == 1 || b == 2) {
            int areaOffset = this.readInt3();
            if (areaOffset == 0) {
                return LocationConst.UNKNOWN;
            }
            return this.readString(areaOffset);
        }
        return this.readString(offset);
    }

    private String readString(long offset) {
        try {
            this.ipFile.seek(offset);
            int i = 0;
            this.buf[i] = this.ipFile.readByte();
            while (this.buf[i] != 0) {
                this.buf[++i] = this.ipFile.readByte();
            }
            if (i != 0) {
                return SeekerSupport.getString(this.buf, 0, i, "GBK");
            }
        }
        catch (IOException e) {
            Exceptions.printStacks((Throwable)e);
        }
        return "";
    }

    private String readString(int offset) {
        try {
            this.mbb.position(offset);
            int i = 0;
            this.buf[i] = this.mbb.get();
            while (this.buf[i] != 0) {
                this.buf[++i] = this.mbb.get();
            }
            if (i != 0) {
                return SeekerSupport.getString(this.buf, 0, i, "GBK");
            }
        }
        catch (IllegalArgumentException e) {
            Exceptions.printStacks((Throwable)e);
        }
        return "";
    }

    public static class IpEntry {
        private String beginIp = "";
        private String endIp = "";
        private String country = "";
        private String area = "";

        private IpEntry() {
        }

        public String toString() {
            return this.area + " " + this.country + "IP  \u03a7:" + this.beginIp + "-" + this.endIp;
        }
    }
}

