/*
 * Decompiled with CFR 0.152.
 */
package com.orion.ext.location.ext;

import com.orion.ext.location.Region;
import com.orion.ext.location.ext.core.IpLocation;
import com.orion.ext.location.ext.core.LocationSeeker;
import com.orion.ext.location.region.LocationRegions;
import com.orion.lang.define.builder.StringJoiner;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Strings;
import com.orion.lang.utils.Systems;
import com.orion.lang.utils.io.Files1;
import com.orion.lang.utils.net.IPs;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class LocationExt {
    private static final String DAT_PATH;
    private static final LocationSeeker SEEKER;

    private LocationExt() {
    }

    public static LocationSeeker getSeeker() {
        return SEEKER;
    }

    public static String getCountry(String ip) {
        if (!IPs.isIpv4((String)ip)) {
            return null;
        }
        try {
            return SEEKER.getCountry(ip);
        }
        catch (Exception e) {
            throw Exceptions.runtime((String)Strings.format((String)"country query error ip: {}", (Object[])new Object[]{ip}), (Throwable)e);
        }
    }

    public static String getAddress(String ip) {
        if (!IPs.isIpv4((String)ip)) {
            return null;
        }
        try {
            return SEEKER.getAddress(ip);
        }
        catch (Exception e) {
            throw Exceptions.runtime((String)Strings.format((String)"address query error ip: {}", (Object[])new Object[]{ip}), (Throwable)e);
        }
    }

    public static String getArea(String ip) {
        if (!IPs.isIpv4((String)ip)) {
            return null;
        }
        try {
            return SEEKER.getArea(ip);
        }
        catch (Exception e) {
            throw Exceptions.runtime((String)Strings.format((String)"area query error ip: {}", (Object[])new Object[]{ip}), (Throwable)e);
        }
    }

    public static IpLocation getIpLocation(String ip) {
        if (!IPs.isIpv4((String)ip)) {
            return null;
        }
        try {
            return SEEKER.getIpLocation(ip);
        }
        catch (Exception e) {
            throw Exceptions.runtime((String)Strings.format((String)"location query error ip: {}", (Object[])new Object[]{ip}), (Throwable)e);
        }
    }

    public static Region getRegion(String ip) {
        if (!IPs.isIpv4((String)ip)) {
            return null;
        }
        try {
            return SEEKER.getRegion(ip);
        }
        catch (Exception e) {
            throw Exceptions.runtime((String)Strings.format((String)"region query error ip: {}", (Object[])new Object[]{ip}), (Throwable)e);
        }
    }

    static {
        boolean init;
        DAT_PATH = StringJoiner.of((String)Systems.FILE_SEPARATOR).with(Systems.HOME_DIR).with(".orion").with(".region").with(".region.dat").build();
        try {
            InputStream source = LocationRegions.class.getClassLoader().getResourceAsStream("region.dat");
            init = Files1.resourceToFile((InputStream)source, (File)new File(DAT_PATH), (String)"GBK");
            SEEKER = new LocationSeeker(DAT_PATH);
        }
        catch (IOException e) {
            throw Exceptions.init((String)"region ext init error", (Throwable)e);
        }
        if (!init) {
            throw Exceptions.init((String)"region ext init error");
        }
    }
}

