/*
 * Decompiled with CFR 0.152.
 */
package com.theokanning.openai.service.assistant_stream;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.TextNode;
import com.theokanning.openai.OpenAiError;
import com.theokanning.openai.OpenAiHttpException;
import com.theokanning.openai.assistants.StreamEvent;
import com.theokanning.openai.assistants.message.Message;
import com.theokanning.openai.assistants.message.content.Delta;
import com.theokanning.openai.assistants.message.content.DeltaContent;
import com.theokanning.openai.assistants.message.content.MessageDelta;
import com.theokanning.openai.assistants.message.content.Text;
import com.theokanning.openai.assistants.run.Run;
import com.theokanning.openai.assistants.run.ToolCall;
import com.theokanning.openai.assistants.run.ToolCallFunction;
import com.theokanning.openai.assistants.run_step.RunStep;
import com.theokanning.openai.assistants.run_step.RunStepDelta;
import com.theokanning.openai.assistants.run_step.StepDetails;
import com.theokanning.openai.service.assistant_stream.AssistantEventHandler;
import com.theokanning.openai.service.assistant_stream.AssistantSSE;
import io.reactivex.Flowable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class AssistantStreamManager {
    private static final Logger log = LoggerFactory.getLogger(AssistantStreamManager.class);
    private final AssistantEventHandler eventHandler;
    private final List<MessageDelta> msgDeltas;
    private final List<RunStepDelta> runStepDeltas;
    private final List<AssistantSSE> eventMsgsHolder;
    private final ObjectMapper mapper = new ObjectMapper();
    private Run currentRun;
    private Message currentMessage;
    private RunStep currentRunStep;
    private MessageDelta accumulatedMessageDelta;
    private RunStepDelta accumulatedRsd;
    private boolean completed = false;

    public AssistantStreamManager(Flowable<AssistantSSE> stream) {
        this(stream, new AssistantEventHandler(){}, false);
    }

    public AssistantStreamManager(Flowable<AssistantSSE> stream, boolean isAsync) {
        this(stream, new AssistantEventHandler(){}, isAsync);
    }

    public AssistantStreamManager(Flowable<AssistantSSE> stream, AssistantEventHandler eventHandler, boolean isAsync) {
        this.eventHandler = eventHandler;
        this.msgDeltas = new ArrayList<MessageDelta>();
        this.runStepDeltas = new ArrayList<RunStepDelta>();
        this.eventMsgsHolder = new ArrayList<AssistantSSE>();
        if (isAsync) {
            stream.subscribe(this::handleEvent, this::handleError);
        } else {
            stream.blockingSubscribe(this::handleEvent, this::handleError);
        }
    }

    private void handleError(Throwable throwable) {
        if (throwable instanceof OpenAiHttpException) {
            OpenAiHttpException exception = (OpenAiHttpException)throwable;
            this.eventHandler.onError(new OpenAiError(new OpenAiError.OpenAiErrorDetails(exception.getMessage(), exception.type, exception.param, exception.code)));
        } else {
            log.error("assistant stream Unknown error", throwable);
            this.eventHandler.onError(new OpenAiError(new OpenAiError.OpenAiErrorDetails(throwable.getMessage(), "unknown", "unknown", "unknown")));
        }
    }

    private void handleEvent(AssistantSSE sse) throws JsonProcessingException {
        StreamEvent eventType = sse.getEvent();
        this.eventMsgsHolder.add(0, sse);
        this.eventHandler.onEvent(sse);
        switch (eventType) {
            case THREAD_RUN_CREATED: {
                this.updateCurrentRun(sse);
                log.debug("run:{} created", (Object)this.currentRun.getId());
                this.eventHandler.onRunCreated(this.currentRun);
                break;
            }
            case THREAD_RUN_QUEUED: {
                this.updateCurrentRun(sse);
                log.debug("run:{} queued", (Object)this.currentRun.getId());
                this.eventHandler.onRunQueued(this.currentRun);
                break;
            }
            case THREAD_RUN_IN_PROGRESS: {
                this.updateCurrentRun(sse);
                log.debug("run:{} in progress", (Object)this.currentRun.getId());
                this.eventHandler.onRunInProgress(this.currentRun);
                break;
            }
            case THREAD_RUN_REQUIRES_ACTION: {
                this.updateCurrentRun(sse);
                log.debug("run:{} requires action", (Object)this.currentRun.getId());
                this.translationRunStepDelta();
                this.eventHandler.onRunRequiresAction(this.currentRun);
                break;
            }
            case THREAD_RUN_COMPLETED: {
                this.updateCurrentRun(sse);
                log.debug("run:{} completed", (Object)this.currentRun.getId());
                this.eventHandler.onRunCompleted(this.currentRun);
                break;
            }
            case THREAD_RUN_FAILED: {
                this.updateCurrentRun(sse);
                log.error("run:{} failed at:{}", (Object)this.currentRun.getId(), (Object)this.currentRun.getFailedAt());
                this.eventHandler.onRunFailed(this.currentRun);
                break;
            }
            case THREAD_RUN_CANCELLING: {
                this.updateCurrentRun(sse);
                log.debug("run:{} cancelling", (Object)this.currentRun.getId());
                this.eventHandler.onRunCancelling(this.currentRun);
                break;
            }
            case THREAD_RUN_CANCELLED: {
                this.updateCurrentRun(sse);
                log.debug("run:{} cancelled", (Object)this.currentRun.getId());
                this.eventHandler.onRunCancelled(this.currentRun);
                break;
            }
            case THREAD_RUN_EXPIRED: {
                this.updateCurrentRun(sse);
                log.warn("run:{} expired at:{}", (Object)this.currentRun.getId(), (Object)this.currentRun.getExpiresAt());
                this.eventHandler.onRunExpired(this.currentRun);
                break;
            }
            case THREAD_RUN_STEP_CREATED: {
                this.updateCurrentRunStep(sse);
                log.debug("runid:{} ,RunStepId:{} created", (Object)this.currentRun.getId(), (Object)this.currentRunStep.getId());
                this.eventHandler.onRunStepCreated(this.currentRunStep);
                break;
            }
            case THREAD_RUN_STEP_IN_PROGRESS: {
                this.updateCurrentRunStep(sse);
                log.debug("runid:{} ,RunStepId:{} in progress", (Object)this.currentRun.getId(), (Object)this.currentRunStep.getId());
                this.eventHandler.onRunStepInProgress(this.currentRunStep);
                break;
            }
            case THREAD_RUN_STEP_DELTA: {
                this.accumulateRunStepDeltaAndSave(sse);
                this.eventHandler.onRunStepDelta(this.runStepDeltas.get(0));
                break;
            }
            case THREAD_RUN_STEP_COMPLETED: {
                this.updateCurrentRunStep(sse);
                log.debug("runid:{} ,RunStepId:{} completed", (Object)this.currentRun.getId(), (Object)this.currentRunStep.getId());
                this.eventHandler.onRunStepCompleted(this.currentRunStep);
                break;
            }
            case THREAD_RUN_STEP_FAILED: {
                this.updateCurrentRunStep(sse);
                log.error("runid:{} ,RunStepId:{} failed at:{}", new Object[]{this.currentRun.getId(), this.currentRunStep.getId(), this.currentRunStep.getFailedAt()});
                this.eventHandler.onRunStepFailed(this.currentRunStep);
                break;
            }
            case THREAD_RUN_STEP_CANCELLED: {
                this.updateCurrentRunStep(sse);
                log.debug("runid:{} ,RunStepId:{} cancelled at:{}", new Object[]{this.currentRun.getId(), this.currentRunStep.getId(), this.currentRunStep.getCancelledAt()});
                this.eventHandler.onRunStepCancelled(this.currentRunStep);
                break;
            }
            case THREAD_RUN_STEP_EXPIRED: {
                this.updateCurrentRunStep(sse);
                log.warn("runid:{} ,RunStepId:{} expired at: {}", new Object[]{this.currentRun.getId(), this.currentRunStep.getId(), this.currentRunStep.getExpiredAt()});
                this.eventHandler.onRunStepExpired(this.currentRunStep);
                break;
            }
            case THREAD_MESSAGE_CREATED: {
                this.updateCurrentMessage(sse);
                log.debug("Message:{} created", (Object)this.currentMessage.getId());
                this.eventHandler.onMessageCreated(this.currentMessage);
                break;
            }
            case THREAD_MESSAGE_IN_PROGRESS: {
                this.updateCurrentMessage(sse);
                log.debug("Message:{} in progress", (Object)this.currentMessage.getId());
                this.eventHandler.onMessageInProgress(this.currentMessage);
                break;
            }
            case THREAD_MESSAGE_DELTA: {
                this.accumulateMessageDeltaAndSave(sse);
                this.eventHandler.onMessageDelta(this.msgDeltas.get(0));
                break;
            }
            case THREAD_MESSAGE_COMPLETED: {
                this.updateCurrentMessage(sse);
                log.debug("Message:{} completed", (Object)this.currentMessage.getId());
                this.eventHandler.onMessageCompleted(this.currentMessage);
                break;
            }
            case THREAD_MESSAGE_INCOMPLETE: {
                this.updateCurrentMessage(sse);
                log.warn("Message:{} incomplete", (Object)this.currentMessage.getId());
                this.eventHandler.onMessageInComplete(this.currentMessage);
                break;
            }
            case DONE: {
                log.debug("Stream done,the final message is:{},Run is {} ", (Object)this.currentMessage, (Object)this.currentRun);
                this.eventHandler.onEnd();
                this.completed = true;
                break;
            }
            case ERROR: {
                log.error("Stream error,the final message is:{},Run is {} ", (Object)this.currentMessage, (Object)this.currentRun);
                this.eventHandler.onError((OpenAiError)this.mapper.readValue(sse.getData(), OpenAiError.class));
            }
        }
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public Message getCurrentMessage() {
        return this.currentMessage;
    }

    public Run getCurrentRun() {
        return this.currentRun;
    }

    public RunStep getCurrentRunStep() {
        return this.currentRunStep;
    }

    public StreamEvent getCurrentEvent() {
        return this.eventMsgsHolder.get(0).getEvent();
    }

    public List<AssistantSSE> getEventMsgsHolder() {
        return this.eventMsgsHolder;
    }

    private void translationRunStepDelta() throws JsonProcessingException {
        for (ToolCall toolCall : this.accumulatedRsd.getDelta().getStepDetails().getToolCalls()) {
            ToolCallFunction function = toolCall.getFunction();
            function.setArguments(this.mapper.readTree(function.getArguments().asText()));
        }
    }

    private void accumulateRunStepDeltaAndSave(AssistantSSE sse) throws JsonProcessingException {
        if (!sse.getEvent().dataClass.equals(RunStepDelta.class)) {
            throw new IllegalArgumentException("Event data is not a RunStepDelta");
        }
        RunStepDelta currentRenStepDelta = (RunStepDelta)this.mapper.readValue(sse.getData(), RunStepDelta.class);
        this.runStepDeltas.add(0, currentRenStepDelta);
        this.accumulatedRunStepDelta(currentRenStepDelta);
    }

    private void updateCurrentRunStep(AssistantSSE sse) throws JsonProcessingException {
        if (!sse.getEvent().dataClass.equals(RunStep.class)) {
            throw new IllegalArgumentException("Event data is not a RunStep");
        }
        this.currentRunStep = (RunStep)this.mapper.readValue(sse.getData(), RunStep.class);
    }

    private void updateCurrentRun(AssistantSSE sse) throws JsonProcessingException {
        if (!sse.getEvent().dataClass.equals(Run.class)) {
            throw new IllegalArgumentException("Event data is not a Run");
        }
        this.currentRun = (Run)this.mapper.readValue(sse.getData(), Run.class);
    }

    private void updateCurrentMessage(AssistantSSE sse) throws JsonProcessingException {
        if (!sse.getEvent().dataClass.equals(Message.class)) {
            throw new IllegalArgumentException("Event data is not a Message");
        }
        this.currentMessage = (Message)this.mapper.readValue(sse.getData(), Message.class);
    }

    private void accumulateMessageDeltaAndSave(AssistantSSE sse) throws JsonProcessingException {
        if (!sse.getEvent().dataClass.equals(MessageDelta.class)) {
            throw new IllegalArgumentException("Event data is not a MessageDelta");
        }
        MessageDelta msgDelta = (MessageDelta)this.mapper.readValue(sse.getData(), MessageDelta.class);
        this.msgDeltas.add(0, msgDelta);
        this.accumulatedMessageDelta(msgDelta);
    }

    private void accumulatedRunStepDelta(RunStepDelta currentRenStepDelta) {
        if (this.accumulatedRsd == null) {
            this.accumulatedRsd = currentRenStepDelta;
        } else {
            StepDetails currentDetails = currentRenStepDelta.getDelta().getStepDetails();
            ToolCall currentToolCallPart = (ToolCall)currentDetails.getToolCalls().get(0);
            StepDetails preDetails = this.accumulatedRsd.getDelta().getStepDetails();
            Optional<ToolCall> existsToolCallOptional = preDetails.getToolCalls().stream().filter(t -> t.getIndex().equals(currentToolCallPart.getIndex())).findFirst();
            if (!existsToolCallOptional.isPresent()) {
                preDetails.setToolCalls(currentDetails.getToolCalls());
                return;
            }
            ToolCall existsToolCallPart = existsToolCallOptional.get();
            if (existsToolCallPart.getType().equals("function")) {
                ToolCallFunction currentFunPart = currentToolCallPart.getFunction();
                ToolCallFunction existsFunPart = existsToolCallPart.getFunction();
                if (currentFunPart.getName() != null && !currentFunPart.getName().isEmpty()) {
                    existsFunPart.setName(Optional.ofNullable(existsFunPart.getName()).orElse("") + currentFunPart.getName());
                }
                if (currentFunPart.getArguments() != null) {
                    existsFunPart.setArguments((JsonNode)new TextNode(Optional.ofNullable(existsFunPart.getArguments()).orElse((JsonNode)new TextNode("")).asText() + currentFunPart.getArguments().asText()));
                }
            } else if (existsToolCallPart.getType().equals("file_search") || existsToolCallPart.getType().equals("code_interpreter")) {
                // empty if block
            }
        }
    }

    private void accumulatedMessageDelta(MessageDelta messageDelta) {
        if (this.accumulatedMessageDelta == null) {
            this.accumulatedMessageDelta = messageDelta;
        } else {
            DeltaContent currentDeltaContent = (DeltaContent)messageDelta.getDelta().getContent().get(0);
            Delta preDelta = this.accumulatedMessageDelta.getDelta();
            List preContent = preDelta.getContent();
            Optional<DeltaContent> existsCurrent = preContent.stream().filter(c -> c.getIndex().equals(currentDeltaContent.getIndex())).findFirst();
            if (existsCurrent.isPresent()) {
                DeltaContent existsContent = existsCurrent.get();
                if (!currentDeltaContent.getType().equals(existsContent.getType())) {
                    throw new IllegalStateException("DeltaContent type is not same");
                }
                if (currentDeltaContent.getType().equals("text")) {
                    Text text = existsContent.getText();
                    text.setValue(text.getValue() + currentDeltaContent.getText().getValue());
                    text.setAnnotations(currentDeltaContent.getText().getAnnotations());
                }
                if (currentDeltaContent.getType().equals("image_file") && currentDeltaContent.getImageFile() != null) {
                    existsContent.setImageFile(currentDeltaContent.getImageFile());
                }
            } else {
                preContent.add(currentDeltaContent);
            }
        }
    }
}

