/*
 * Decompiled with CFR 0.152.
 */
package com.theokanning.openai.service;

import com.theokanning.openai.completion.chat.AssistantMessage;
import com.theokanning.openai.completion.chat.ChatFunctionCall;
import com.theokanning.openai.completion.chat.ChatToolCall;

public class ChatMessageAccumulator {
    private final AssistantMessage messageChunk;
    private final AssistantMessage accumulatedMessage;

    public ChatMessageAccumulator(AssistantMessage messageChunk, AssistantMessage accumulatedMessage) {
        this.messageChunk = messageChunk;
        this.accumulatedMessage = accumulatedMessage;
    }

    public boolean isFunctionCall() {
        AssistantMessage asstMsg = this.getAccumulatedMessage();
        return asstMsg.getFunctionCall() != null && asstMsg.getFunctionCall().getName() != null || asstMsg.getToolCalls() != null && !asstMsg.getToolCalls().isEmpty();
    }

    public boolean isChatMessage() {
        return !this.isFunctionCall();
    }

    public AssistantMessage getMessageChunk() {
        return this.messageChunk;
    }

    public AssistantMessage getAccumulatedMessage() {
        return this.accumulatedMessage;
    }

    public ChatFunctionCall getChatFunctionCallChunk() {
        AssistantMessage msC = this.getMessageChunk();
        ChatFunctionCall functionCall = msC.getFunctionCall();
        if (functionCall == null) {
            functionCall = ((ChatToolCall)msC.getToolCalls().get(0)).getFunction();
        }
        return functionCall;
    }

    public ChatFunctionCall getAccumulatedChatFunctionCall() {
        return this.getAccumulatedMessage().getFunctionCall();
    }
}

