/*
 * Decompiled with CFR 0.152.
 */
package com.syusuke.commonadapter.recyclerview;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.RecyclerView;
import com.syusuke.commonadapter.recyclerview.base.ItemViewDelegate;
import com.syusuke.commonadapter.recyclerview.base.ItemViewDelegateManager;
import com.syusuke.commonadapter.recyclerview.base.ViewHolder;
import java.util.List;

public class MultiItemTypeAdapter<T>
extends RecyclerView.Adapter<ViewHolder> {
    protected Context mContext;
    protected List<T> mDatas;
    protected ItemViewDelegateManager mItemViewDelegateManager;
    protected OnItemClickListener mOnItemClickListener;

    public MultiItemTypeAdapter(Context context, List<T> datas) {
        this.mContext = context;
        this.mDatas = datas;
        this.mItemViewDelegateManager = new ItemViewDelegateManager();
    }

    public int getItemViewType(int position) {
        if (!this.useItemViewDelegateManager()) {
            return super.getItemViewType(position);
        }
        return this.mItemViewDelegateManager.getItemViewType(this.mDatas.get(position), position);
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        ItemViewDelegate itemViewDelegate = this.mItemViewDelegateManager.getItemViewDelegate(viewType);
        int layoutId = itemViewDelegate.getItemViewLayoutId();
        ViewHolder holder = ViewHolder.createViewHolder(this.mContext, parent, layoutId);
        this.onViewHolderCreated(holder, holder.getConvertView());
        this.setListener(parent, holder, viewType);
        return holder;
    }

    public void onViewHolderCreated(ViewHolder holder, View itemView) {
    }

    public void convert(ViewHolder holder, T t) {
        this.mItemViewDelegateManager.convert(holder, t, holder.getAdapterPosition());
    }

    protected boolean isEnabled(int viewType) {
        return true;
    }

    protected void setListener(ViewGroup parent, final ViewHolder viewHolder, int viewType) {
        if (!this.isEnabled(viewType)) {
            return;
        }
        viewHolder.getConvertView().setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MultiItemTypeAdapter.this.mOnItemClickListener != null) {
                    int position = viewHolder.getAdapterPosition();
                    MultiItemTypeAdapter.this.mOnItemClickListener.onItemClick(v, viewHolder, position);
                }
            }
        });
        viewHolder.getConvertView().setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (MultiItemTypeAdapter.this.mOnItemClickListener != null) {
                    int position = viewHolder.getAdapterPosition();
                    return MultiItemTypeAdapter.this.mOnItemClickListener.onItemLongClick(v, viewHolder, position);
                }
                return false;
            }
        });
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        this.convert(holder, this.mDatas.get(position));
    }

    public int getItemCount() {
        int itemCount = this.mDatas.size();
        return itemCount;
    }

    public List<T> getDatas() {
        return this.mDatas;
    }

    public MultiItemTypeAdapter addItemViewDelegate(ItemViewDelegate<T> itemViewDelegate) {
        this.mItemViewDelegateManager.addDelegate(itemViewDelegate);
        return this;
    }

    public MultiItemTypeAdapter addItemViewDelegate(int viewType, ItemViewDelegate<T> itemViewDelegate) {
        this.mItemViewDelegateManager.addDelegate(viewType, itemViewDelegate);
        return this;
    }

    protected boolean useItemViewDelegateManager() {
        return this.mItemViewDelegateManager.getItemViewDelegateCount() > 0;
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
    }

    public static interface OnItemClickListener {
        public void onItemClick(View var1, RecyclerView.ViewHolder var2, int var3);

        public boolean onItemLongClick(View var1, RecyclerView.ViewHolder var2, int var3);
    }
}

