/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.generators.impl;

import com.kobylynskyi.graphql.codegen.generators.FilesGenerator;
import com.kobylynskyi.graphql.codegen.generators.FreeMarkerTemplateFilesCreator;
import com.kobylynskyi.graphql.codegen.generators.FreeMarkerTemplateType;
import com.kobylynskyi.graphql.codegen.mapper.DataModelMapperFactory;
import com.kobylynskyi.graphql.codegen.mapper.RequestResponseDefinitionToDataModelMapper;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedFieldDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedObjectTypeDefinition;
import graphql.language.FieldDefinition;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RequestResponseGenerator
implements FilesGenerator {
    private final MappingContext mappingContext;
    private final RequestResponseDefinitionToDataModelMapper requestResponseDefinitionMapper;

    public RequestResponseGenerator(MappingContext mappingContext, DataModelMapperFactory dataModelMapperFactory) {
        this.mappingContext = mappingContext;
        this.requestResponseDefinitionMapper = dataModelMapperFactory.getRequestResponseDefinitionMapper();
    }

    @Override
    public List<File> generate() {
        if (!Boolean.TRUE.equals(this.mappingContext.getGenerateClient())) {
            return Collections.emptyList();
        }
        ArrayList<File> generatedFiles = new ArrayList<File>();
        for (ExtendedObjectTypeDefinition definition : this.mappingContext.getDocument().getOperationDefinitions()) {
            generatedFiles.addAll(this.generate(definition));
        }
        return generatedFiles;
    }

    private List<File> generate(ExtendedObjectTypeDefinition definition) {
        ArrayList<File> generatedFiles = new ArrayList<File>();
        List<String> fieldNames = definition.getFieldDefinitions().stream().map(FieldDefinition::getName).collect(Collectors.toList());
        for (ExtendedFieldDefinition operationDef : definition.getFieldDefinitions()) {
            Map<String, Object> requestDataModel = this.requestResponseDefinitionMapper.mapRequest(this.mappingContext, operationDef, definition.getName(), fieldNames);
            generatedFiles.add(FreeMarkerTemplateFilesCreator.create(this.mappingContext, FreeMarkerTemplateType.REQUEST, requestDataModel));
            Map<String, Object> responseDataModel = this.requestResponseDefinitionMapper.mapResponse(this.mappingContext, operationDef, definition.getName(), fieldNames);
            generatedFiles.add(FreeMarkerTemplateFilesCreator.create(this.mappingContext, FreeMarkerTemplateType.RESPONSE, responseDataModel));
        }
        return generatedFiles;
    }
}

