/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.mapper;

import com.kobylynskyi.graphql.codegen.mapper.AnnotationsMapper;
import com.kobylynskyi.graphql.codegen.mapper.DataModelMapper;
import com.kobylynskyi.graphql.codegen.mapper.GraphQLTypeMapper;
import com.kobylynskyi.graphql.codegen.mapper.InputValueDefinitionToParameterMapper;
import com.kobylynskyi.graphql.codegen.mapper.MapperFactory;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import com.kobylynskyi.graphql.codegen.model.NamedDefinition;
import com.kobylynskyi.graphql.codegen.model.OperationDefinition;
import com.kobylynskyi.graphql.codegen.model.ParameterDefinition;
import com.kobylynskyi.graphql.codegen.model.RelayConfig;
import com.kobylynskyi.graphql.codegen.model.builders.DeprecatedDefinitionBuilder;
import com.kobylynskyi.graphql.codegen.model.builders.JavaDocBuilder;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedFieldDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedObjectTypeDefinition;
import com.kobylynskyi.graphql.codegen.model.graphql.GraphQLOperation;
import com.kobylynskyi.graphql.codegen.utils.Utils;
import graphql.language.Argument;
import graphql.language.Directive;
import graphql.language.NamedNode;
import graphql.language.StringValue;
import graphql.language.Type;
import graphql.language.TypeName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class FieldDefinitionsToResolverDataModelMapper {
    private final GraphQLTypeMapper graphQLTypeMapper;
    private final AnnotationsMapper annotationsMapper;
    private final DataModelMapper dataModelMapper;
    private final InputValueDefinitionToParameterMapper inputValueDefinitionToParameterMapper;

    public FieldDefinitionsToResolverDataModelMapper(MapperFactory mapperFactory, InputValueDefinitionToParameterMapper inputValueDefToParamMapper) {
        this.graphQLTypeMapper = mapperFactory.getGraphQLTypeMapper();
        this.annotationsMapper = mapperFactory.getAnnotationsMapper();
        this.dataModelMapper = mapperFactory.getDataModelMapper();
        this.inputValueDefinitionToParameterMapper = inputValueDefToParamMapper;
    }

    public static String getParentInterface(MappingContext mappingContext, String typeName) {
        try {
            switch (GraphQLOperation.valueOf(typeName.toUpperCase())) {
                case QUERY: {
                    return mappingContext.getQueryResolverParentInterface();
                }
                case MUTATION: {
                    return mappingContext.getMutationResolverParentInterface();
                }
                case SUBSCRIPTION: {
                    return mappingContext.getSubscriptionResolverParentInterface();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (mappingContext.getResolverParentInterface() == null) {
            return null;
        }
        return mappingContext.getResolverParentInterface().replace("{{TYPE}}", DataModelMapper.getModelClassNameWithPrefixAndSuffix(mappingContext, typeName));
    }

    public Map<String, Object> mapToTypeResolver(MappingContext mappingContext, List<ExtendedFieldDefinition> fieldDefs, String parentTypeName) {
        String className = DataModelMapper.getTypeResolverClassNameWithPrefixAndSuffix(mappingContext, parentTypeName);
        return this.mapToResolverModel(mappingContext, parentTypeName, className, fieldDefs, Collections.singletonList("Resolver for " + parentTypeName), FieldDefinitionsToResolverDataModelMapper.getParentInterface(mappingContext, parentTypeName));
    }

    public Map<String, Object> mapRootTypeField(MappingContext mappingContext, ExtendedFieldDefinition fieldDefinition, String rootTypeName, List<String> fieldNames) {
        String className = DataModelMapper.getApiClassNameWithPrefixAndSuffix(mappingContext, fieldDefinition, rootTypeName, fieldNames);
        List<ExtendedFieldDefinition> fieldDefs = Collections.singletonList(fieldDefinition);
        return this.mapToResolverModel(mappingContext, rootTypeName, className, fieldDefs, fieldDefinition.getJavaDoc(), FieldDefinitionsToResolverDataModelMapper.getParentInterface(mappingContext, rootTypeName));
    }

    public Map<String, Object> mapRootTypeFields(MappingContext mappingContext, ExtendedObjectTypeDefinition definition) {
        String className = DataModelMapper.getApiClassNameWithPrefixAndSuffix(mappingContext, definition);
        return this.mapToResolverModel(mappingContext, definition.getName(), className, definition.getFieldDefinitions(), JavaDocBuilder.build(definition), FieldDefinitionsToResolverDataModelMapper.getParentInterface(mappingContext, definition.getName()));
    }

    private Map<String, Object> mapToResolverModel(MappingContext mappingContext, String parentTypeName, String className, List<ExtendedFieldDefinition> fieldDefinitions, List<String> javaDoc, String parentInterface) {
        String packageName = DataModelMapper.getApiPackageName(mappingContext);
        Set<String> imports = DataModelMapper.getImports(mappingContext, packageName);
        List<OperationDefinition> operations = this.mapToOperations(mappingContext, fieldDefinitions, parentTypeName);
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("package", packageName);
        dataModel.put("imports", imports);
        dataModel.put("className", className);
        dataModel.put("operations", operations);
        dataModel.put("javaDoc", javaDoc);
        dataModel.put("implements", parentInterface != null ? Collections.singletonList(parentInterface) : null);
        dataModel.put("generatedAnnotation", mappingContext.getAddGeneratedAnnotation());
        dataModel.put("generatedInfo", mappingContext.getGeneratedInformation());
        dataModel.put("enumImportItSelfInScala", mappingContext.getEnumImportItSelfInScala());
        dataModel.put("generateModelOpenClasses", mappingContext.isGenerateModelOpenClasses());
        dataModel.put("initializeNullableTypes", mappingContext.isInitializeNullableTypes());
        return dataModel;
    }

    private List<OperationDefinition> mapToOperations(MappingContext mappingContext, List<ExtendedFieldDefinition> fieldDefinitions, String parentTypeName) {
        return fieldDefinitions.stream().map(fieldDef -> this.map(mappingContext, (ExtendedFieldDefinition)((Object)fieldDef), parentTypeName)).collect(Collectors.toList());
    }

    private OperationDefinition map(MappingContext mappingContext, ExtendedFieldDefinition fieldDef, String parentTypeName) {
        String name = this.dataModelMapper.capitalizeIfRestricted(mappingContext, fieldDef.getName());
        NamedDefinition javaType = this.graphQLTypeMapper.getLanguageType(mappingContext, fieldDef.getType(), fieldDef.getName(), parentTypeName);
        String returnType = this.getReturnType(mappingContext, fieldDef, javaType, parentTypeName);
        List<String> annotations = this.annotationsMapper.getAnnotations(mappingContext, (Type<?>)fieldDef.getType(), (NamedNode<?>)fieldDef, parentTypeName, false);
        List<ParameterDefinition> parameters = this.getOperationParameters(mappingContext, fieldDef, parentTypeName);
        OperationDefinition operation = new OperationDefinition();
        operation.setName(name);
        operation.setOriginalName(fieldDef.getName());
        operation.setType(returnType);
        operation.setAnnotations(annotations);
        operation.setParameters(parameters);
        operation.setJavaDoc(fieldDef.getJavaDoc());
        operation.setDeprecated(DeprecatedDefinitionBuilder.build(mappingContext, fieldDef));
        operation.setThrowsException(mappingContext.getGenerateApisWithThrowsException());
        return operation;
    }

    private List<ParameterDefinition> getOperationParameters(MappingContext mappingContext, ExtendedFieldDefinition resolvedField, String parentTypeName) {
        ArrayList<ParameterDefinition> parameters = new ArrayList<ParameterDefinition>();
        if (!Utils.isGraphqlOperation(parentTypeName)) {
            String parentObjectParamType = this.graphQLTypeMapper.getLanguageType(mappingContext, (Type<?>)new TypeName(parentTypeName));
            String parentObjectParamName = this.dataModelMapper.capitalizeIfRestricted(mappingContext, Utils.unCapitalize(parentTypeName));
            ParameterDefinition parameterDefinition = new ParameterDefinition();
            parameterDefinition.setType(parentObjectParamType);
            parameterDefinition.setName(parentObjectParamName);
            parameterDefinition.setOriginalName(parentObjectParamName);
            parameterDefinition.setDeprecated(DeprecatedDefinitionBuilder.build(mappingContext, resolvedField));
            parameterDefinition.setGetterMethodName(this.dataModelMapper.capitalizeMethodNameIfRestricted(mappingContext, "get" + Utils.capitalize(parentObjectParamName)));
            parameters.add(parameterDefinition);
        }
        parameters.addAll(this.inputValueDefinitionToParameterMapper.map(mappingContext, resolvedField.getInputValueDefinitions(), resolvedField.getName()));
        if (Boolean.TRUE.equals(mappingContext.getGenerateDataFetchingEnvironmentArgumentInApis())) {
            parameters.add(ParameterDefinition.DATA_FETCHING_ENVIRONMENT);
        }
        return parameters;
    }

    private String getReturnType(MappingContext mappingContext, ExtendedFieldDefinition fieldDef, NamedDefinition namedDefinition, String parentTypeName) {
        Argument argument;
        List connectionDirective;
        RelayConfig relayConfig = mappingContext.getRelayConfig();
        if (relayConfig != null && relayConfig.getDirectiveName() != null && !(connectionDirective = fieldDef.getDirectives(relayConfig.getDirectiveName())).isEmpty() && (argument = ((Directive)connectionDirective.get(0)).getArgument(relayConfig.getDirectiveArgumentName())) != null && argument.getValue() instanceof StringValue) {
            String graphqlTypeName = ((StringValue)argument.getValue()).getValue();
            String javaTypeName = this.graphQLTypeMapper.getLanguageType(mappingContext, (Type<?>)new TypeName(graphqlTypeName), graphqlTypeName, parentTypeName, false, false).getJavaName();
            return this.graphQLTypeMapper.getGenericsString(mappingContext, relayConfig.getConnectionType(), javaTypeName);
        }
        return this.graphQLTypeMapper.wrapApiReturnTypeIfRequired(mappingContext, namedDefinition, parentTypeName);
    }
}

