/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock;

import io.github.classgraph.MethodInfo;
import io.github.classgraph.ScanResult;
import io.github.kbuntrock.configuration.ApiConfiguration;
import io.github.kbuntrock.configuration.CommonApiConfiguration;
import io.github.kbuntrock.configuration.library.reader.AstractLibraryReader;
import io.github.kbuntrock.model.Tag;
import io.github.kbuntrock.utils.Logger;
import io.github.kbuntrock.utils.OpenApiTypeResolver;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;

public class JavaClassAnalyser {
    private final Log logger = Logger.INSTANCE.getLogger();
    private final List<Pair<Pattern, Pattern>> whiteListPatterns = new ArrayList<Pair<Pattern, Pattern>>();
    private final List<Pair<Pattern, Pattern>> blackListPatterns = new ArrayList<Pair<Pattern, Pattern>>();
    private final AstractLibraryReader libraryReader;
    private final ScanResult classScanResult;

    public JavaClassAnalyser(ApiConfiguration apiConfiguration, ScanResult classScanResult, OpenApiTypeResolver openApiTypeResolver) {
        String[] regexArray;
        this.libraryReader = apiConfiguration.getLibrary().createReader(apiConfiguration, openApiTypeResolver);
        this.classScanResult = classScanResult;
        if (apiConfiguration.getWhiteList() != null) {
            for (String whiteEntry : apiConfiguration.getWhiteList()) {
                regexArray = whiteEntry.split(CommonApiConfiguration.SEPARATOR_CLASS_METHOD);
                if (regexArray.length != 2) continue;
                if (StringUtils.isEmpty((CharSequence)regexArray[0])) {
                    this.whiteListPatterns.add((Pair<Pattern, Pattern>)Pair.of(null, (Object)Pattern.compile(regexArray[1])));
                    continue;
                }
                this.whiteListPatterns.add((Pair<Pattern, Pattern>)Pair.of((Object)Pattern.compile(regexArray[0]), (Object)Pattern.compile(regexArray[1])));
            }
        }
        if (apiConfiguration.getBlackList() != null) {
            for (String blackEntry : apiConfiguration.getBlackList()) {
                regexArray = blackEntry.split(CommonApiConfiguration.SEPARATOR_CLASS_METHOD);
                if (regexArray.length != 2) continue;
                if (StringUtils.isEmpty((CharSequence)regexArray[0])) {
                    this.blackListPatterns.add((Pair<Pattern, Pattern>)Pair.of(null, (Object)Pattern.compile(regexArray[1])));
                    continue;
                }
                this.blackListPatterns.add((Pair<Pattern, Pattern>)Pair.of((Object)Pattern.compile(regexArray[0]), (Object)Pattern.compile(regexArray[1])));
            }
        }
    }

    private static String createTypeIdentifier(String typeName) {
        String returnTypeName = typeName;
        String[] toReplace = typeName.split("[<>,]");
        ArrayList<Pair> replacementList = new ArrayList<Pair>();
        for (String s : toReplace) {
            String[] replacementArray = s.split("\\.");
            replacementList.add(Pair.of((Object)s, (Object)replacementArray[replacementArray.length - 1]));
        }
        for (Pair pair : replacementList) {
            returnTypeName = returnTypeName.replace((CharSequence)pair.getLeft(), (CharSequence)pair.getRight());
        }
        return returnTypeName;
    }

    public static String createMethodIdentifier(Method method) {
        return Arrays.stream(method.getParameters()).map(p -> StringUtils.defaultString((String)p.getType().getSimpleName())).collect(Collectors.joining(", ", method.getName() + "(", ")"));
    }

    public Optional<Tag> getTagFromClass(Class<?> clazz) throws MojoFailureException {
        Tag tag = new Tag(clazz);
        this.logger.debug((CharSequence)("Parsing tag : " + tag.getName()));
        MergedAnnotations mergedAnnotations = MergedAnnotations.from(clazz, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY);
        MergedAnnotation swaggerTag = mergedAnnotations.get("io.swagger.v3.oas.annotations.tags.Tag");
        if (swaggerTag.isPresent()) {
            String description;
            String tagName = swaggerTag.getString("name");
            if (!StringUtils.isEmpty((CharSequence)tagName)) {
                tag.setComputedName(tagName);
            }
            if (!StringUtils.isEmpty((CharSequence)(description = swaggerTag.getString("description")))) {
                tag.setDescription(description);
            }
        }
        List<String> basePaths = this.libraryReader.readBasePaths(clazz, mergedAnnotations);
        for (String basePath : basePaths) {
            this.parseEndpoints(tag, basePath, clazz);
        }
        if (tag.getEndpoints().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(tag);
    }

    private void parseEndpoints(Tag tag, String basePath, Class<?> clazz) throws MojoFailureException {
        this.logger.debug((CharSequence)("Parsing endpoint " + clazz.getSimpleName()));
        Set methods = this.classScanResult.getClassInfo(clazz.getCanonicalName()).getMethodInfo().filter(methodInfo -> !methodInfo.isPrivate()).stream().map(MethodInfo::loadClassAndGetMethod).collect(Collectors.toSet());
        for (Method method : methods) {
            if (!this.validateWhiteList(clazz, method) || !this.validateBlackList(clazz, method)) continue;
            MergedAnnotations mergedAnnotations = MergedAnnotations.from((AnnotatedElement)method, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY);
            this.libraryReader.computeAnnotations(clazz, basePath, method, mergedAnnotations, tag);
        }
    }

    private boolean validateWhiteList(Class<?> clazz, Method method) {
        if (!this.whiteListPatterns.isEmpty()) {
            for (Pair<Pattern, Pattern> pair : this.whiteListPatterns) {
                boolean validateLeft = true;
                if (pair.getLeft() != null) {
                    validateLeft = ((Pattern)pair.getLeft()).matcher(clazz.getCanonicalName()).matches();
                }
                if (!validateLeft || !((Pattern)pair.getRight()).matcher(method.getName()).matches()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean validateBlackList(Class<?> clazz, Method method) {
        if (!this.blackListPatterns.isEmpty()) {
            for (Pair<Pattern, Pattern> pair : this.blackListPatterns) {
                boolean validateLeft = true;
                if (pair.getLeft() != null) {
                    validateLeft = ((Pattern)pair.getLeft()).matcher(clazz.getCanonicalName()).matches();
                }
                if (!validateLeft || !((Pattern)pair.getRight()).matcher(method.getName()).matches()) continue;
                return false;
            }
        }
        return true;
    }
}

