/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.model;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import org.springframework.web.bind.annotation.RequestMethod;

public enum OperationType {
    GET(RequestMethod.GET, GET.class, "jakarta.ws.rs.GET"),
    POST(RequestMethod.POST, POST.class, "jakarta.ws.rs.POST"),
    PUT(RequestMethod.PUT, PUT.class, "jakarta.ws.rs.PUT"),
    PATCH(RequestMethod.PATCH, PATCH.class, "jakarta.ws.rs.PATCH"),
    DELETE(RequestMethod.DELETE, DELETE.class, "jakarta.ws.rs.DELETE"),
    HEAD(RequestMethod.HEAD, HEAD.class, "jakarta.ws.rs.HEAD"),
    OPTIONS(RequestMethod.OPTIONS, OPTIONS.class, "jakarta.ws.rs.OPTIONS"),
    TRACE(RequestMethod.TRACE, null, null);

    private static final Map<RequestMethod, OperationType> mapBySpringMvcRequestMethod;
    private static final Map<Class, OperationType> mapByJavaxRsAnnotationClass;
    private static final Map<String, OperationType> mapByJakartaRsAnnotationClass;
    private final RequestMethod springMvcRequestMethod;
    private final Class javaxRsVerbAnnotation;
    private final String jakartaRsVerbAnnotation;

    private OperationType(RequestMethod springMvcRequestMethod, Class javaxRsVerbAnnotation, String jakartaRsVerbAnnotation) {
        this.springMvcRequestMethod = springMvcRequestMethod;
        this.javaxRsVerbAnnotation = javaxRsVerbAnnotation;
        this.jakartaRsVerbAnnotation = jakartaRsVerbAnnotation;
    }

    public static OperationType fromJavax(RequestMethod springMvcRequestMethod) {
        return mapBySpringMvcRequestMethod.get(springMvcRequestMethod);
    }

    public static OperationType fromJavax(Class javaxRsVerbAnnotation) {
        return mapByJavaxRsAnnotationClass.get(javaxRsVerbAnnotation);
    }

    public static OperationType fromJakarta(String jakartaRsVerbAnnotation) {
        return mapByJakartaRsAnnotationClass.get(jakartaRsVerbAnnotation);
    }

    static {
        mapBySpringMvcRequestMethod = new HashMap<RequestMethod, OperationType>();
        mapByJavaxRsAnnotationClass = new HashMap<Class, OperationType>();
        mapByJakartaRsAnnotationClass = new HashMap<String, OperationType>();
        for (OperationType type : OperationType.values()) {
            mapBySpringMvcRequestMethod.put(type.springMvcRequestMethod, type);
            mapByJavaxRsAnnotationClass.put(type.javaxRsVerbAnnotation, type);
            mapByJakartaRsAnnotationClass.put(type.jakartaRsVerbAnnotation, type);
        }
    }
}

