/*
 * Decompiled with CFR 0.152.
 */
package io.github.jxnflzc.log;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class Logger {
    private String name;
    private String consoleTemplate;
    private String fileTemplate;
    private String consoleTimeTemplate;
    private String fileTimeTemplate;
    private LogLevel minConsoleLogLevel;
    private LogLevel minFileLogLevel;
    private String logPath;
    private String logFile;
    private static final String DEFAULT_LOG_PATH = "log";
    private static final String DEFAULT_LOG_NAME = "log.log";
    private static final String DEFAULT_NAME = "LOGGER";
    private static final String DEFAULT_TIME_FORMAT = "yyyy/MM/dd HH:mm:ss.SSS";
    private static final String DEFAULT_TEMPLATE = "%d [%t] %C.%M [%l] - %m";

    protected Logger(Class<?> clazz) {
        this.name = null != clazz ? clazz.getName() : DEFAULT_NAME;
        this.readProperties();
    }

    protected Logger(String name) {
        this.name = null != name ? name : DEFAULT_NAME;
        this.readProperties();
    }

    private String getNowDateTime(String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(new Date());
    }

    public void readProperties() {
        Properties properties = new Properties();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream resourceAsStream = classLoader.getResourceAsStream("log.properties");
        if (resourceAsStream != null) {
            try {
                properties.load(resourceAsStream);
                resourceAsStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.generateLogLocal(properties);
        this.generatePattern(properties);
        this.generateLogLevel(properties);
        this.generateTimeTemplate();
    }

    private void generateLogLocal(Properties properties) {
        String logPath = properties.getProperty("jtools.log.file.path");
        String logFile = properties.getProperty("jtools.log.file.name");
        if (StringUtils.isBlank((CharSequence)logPath) && StringUtils.isBlank((CharSequence)logFile)) {
            return;
        }
        while (logPath.contains("{") && logPath.contains("}")) {
            String logPathTimeTemplate = this.getTimeTemplateFromResource(0, logPath);
            if (!StringUtils.isNotBlank((CharSequence)logPathTimeTemplate)) continue;
            logPath = logPath.replace("{" + logPathTimeTemplate + "}", this.getNowDateTime(logPathTimeTemplate));
        }
        String string = this.logPath = StringUtils.isNotBlank((CharSequence)logPath) ? logPath : DEFAULT_LOG_PATH;
        while (logFile.contains("{") && logFile.contains("}")) {
            String logNameTimeTemplate = this.getTimeTemplateFromResource(0, logFile);
            if (!StringUtils.isNotBlank((CharSequence)logNameTimeTemplate)) continue;
            logFile = logFile.replace("{" + logNameTimeTemplate + "}", this.getNowDateTime(logNameTimeTemplate));
        }
        this.logFile = StringUtils.isNotBlank((CharSequence)logFile) ? logFile : DEFAULT_LOG_NAME;
    }

    private void generatePattern(Properties properties) {
        String consolePattern = properties.getProperty("jtools.log.console.pattern");
        this.consoleTemplate = consolePattern == null ? DEFAULT_TEMPLATE : consolePattern;
        String filePattern = properties.getProperty("jtools.log.file.pattern");
        this.fileTemplate = filePattern == null ? DEFAULT_TEMPLATE : filePattern;
    }

    private void generateLogLevel(Properties properties) {
        String consoleLevel = properties.getProperty("jtools.log.console.level");
        try {
            this.minConsoleLogLevel = this.generateLogLevel(consoleLevel);
        }
        catch (IllegalAccessException ex) {
            this.minConsoleLogLevel = LogLevel.DEBUG;
        }
        String fileLevel = properties.getProperty("jtools.log.file.level");
        try {
            this.minFileLogLevel = this.generateLogLevel(fileLevel);
        }
        catch (IllegalAccessException ex) {
            this.minFileLogLevel = LogLevel.DEBUG;
        }
    }

    private void generateTimeTemplate() {
        int timeIndex = this.consoleTemplate.indexOf("%d");
        String consoleTimeTemplate = this.getTimeTemplateFromResource(timeIndex, this.consoleTemplate);
        this.consoleTimeTemplate = consoleTimeTemplate == null ? DEFAULT_TIME_FORMAT : consoleTimeTemplate;
        this.consoleTemplate = this.consoleTemplate.replace("{" + this.consoleTimeTemplate + "}", "");
        timeIndex = this.fileTemplate.indexOf("%d");
        String fileTimeTemplate = this.getTimeTemplateFromResource(timeIndex, this.fileTemplate);
        this.fileTimeTemplate = fileTimeTemplate == null ? DEFAULT_TIME_FORMAT : fileTimeTemplate;
        this.fileTemplate = this.fileTemplate.replace("{" + this.fileTimeTemplate + "}", "");
        this.consoleTimeTemplate = this.consoleTimeTemplate.trim();
        this.fileTimeTemplate = this.fileTimeTemplate.trim();
    }

    private LogLevel generateLogLevel(String level) throws IllegalAccessException {
        for (LogLevel logLevel : LogLevel.values()) {
            if (!logLevel.toString().equals(level)) continue;
            return logLevel;
        }
        throw new IllegalAccessException();
    }

    private String getTimeTemplateFromResource(int timeIndex, String pattern) {
        int from = -1;
        int to = -1;
        while (timeIndex < pattern.length()) {
            if (pattern.charAt(timeIndex) == '{') {
                from = timeIndex + 1;
            }
            if (pattern.charAt(timeIndex) == '}') {
                to = timeIndex;
            }
            ++timeIndex;
        }
        if (from != -1 && to != -1 && to > from) {
            return pattern.substring(from, to);
        }
        return null;
    }

    private void printLog(String content, LogLevel logLevel, Object ... args) {
        if (this.minConsoleLogLevel.compareTo(logLevel) > 0) {
            return;
        }
        for (Object arg : args) {
            content = content.replaceFirst("\\{}", arg.toString());
        }
        String output = this.generateOutput(this.consoleTemplate, content, logLevel, this.consoleTimeTemplate);
        System.out.println(output);
    }

    private void writeLog(String content, LogLevel logLevel, Object ... args) {
        if (this.minFileLogLevel.compareTo(logLevel) > 0) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.logPath) || StringUtils.isBlank((CharSequence)this.logFile)) {
            return;
        }
        for (Object arg : args) {
            content = content.replaceFirst("\\{}", arg.toString());
        }
        String output = this.generateOutput(this.fileTemplate, content, logLevel, this.fileTimeTemplate);
        try {
            File tempFile = new File(this.logPath);
            if (!tempFile.exists()) {
                tempFile.mkdirs();
            }
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.logPath + File.separator + this.logFile, true));
            bw.write(output);
            bw.newLine();
            bw.close();
        }
        catch (IOException exception) {
            System.out.println(exception);
        }
    }

    private String generateOutput(String template, String content, LogLevel logLevel, String timeTemplate) {
        String output = template;
        output = output.replace("%d", this.getNowDateTime(timeTemplate));
        output = output.replace("%l", String.format("%5s", new Object[]{logLevel}));
        output = output.replace("%t", Thread.currentThread().getName());
        output = output.replace("%C", this.name);
        output = output.replace("%M", Thread.currentThread().getStackTrace()[4].getMethodName());
        output = output.replace("%F", Thread.currentThread().getStackTrace()[4].getFileName());
        output = output.replace("%L", String.valueOf(Thread.currentThread().getStackTrace()[4].getLineNumber()));
        output = output.replace("%m", content);
        return output;
    }

    public void debug(String content, Object ... args) {
        this.printLog(content, LogLevel.DEBUG, args);
        this.writeLog(content, LogLevel.DEBUG, args);
    }

    public void info(String content, Object ... args) {
        this.printLog(content, LogLevel.INFO, args);
        this.writeLog(content, LogLevel.INFO, args);
    }

    public void warn(String content, Object ... args) {
        this.printLog(content, LogLevel.WARN, args);
        this.writeLog(content, LogLevel.WARN, args);
    }

    public void error(String content, Object ... args) {
        this.printLog(content, LogLevel.ERROR, args);
        this.writeLog(content, LogLevel.ERROR, args);
    }

    public void fatal(String content, Object ... args) {
        this.printLog(content, LogLevel.FATAL, args);
        this.writeLog(content, LogLevel.FATAL, args);
    }

    public String getName() {
        return this.name;
    }

    static enum LogLevel {
        DEBUG,
        INFO,
        WARN,
        ERROR,
        FATAL;

    }
}

