/*
 * Decompiled with CFR 0.152.
 */
package com.just.agentweb;

import android.app.Activity;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.webkit.WebView;
import android.widget.FrameLayout;
import com.just.agentweb.AbsAgentWebUIController;
import com.just.agentweb.LogUtils;
import com.just.agentweb.Provider;
import com.just.agentweb.R;

public class WebParentLayout
extends FrameLayout
implements Provider<AbsAgentWebUIController> {
    private static final String TAG = "WebParentLayout";
    private AbsAgentWebUIController mAgentWebUIController = null;
    private int mErrorLayoutRes;
    private int mClickId = -1;
    private View mErrorView;
    private WebView mWebView;
    private FrameLayout mErrorLayout = null;

    WebParentLayout(Context context) {
        this(context, null);
        LogUtils.i(TAG, TAG);
    }

    WebParentLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, -1);
    }

    WebParentLayout(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        if (context instanceof Activity) {
            this.mErrorLayoutRes = R.layout.agentweb_error_page;
            return;
        }
        throw new IllegalArgumentException("WebParentLayout context must be activity or activity sub class .");
    }

    private void createErrorLayout() {
        View.OnClickListener onClickListener;
        FrameLayout frameLayout;
        Object object = frameLayout;
        new FrameLayout(this.getContext()).setBackgroundColor(-1);
        object.setId(R.id.mainframe_error_container_id);
        View view = this.mErrorView;
        if (view == null) {
            LayoutInflater layoutInflater = LayoutInflater.from((Context)this.getContext());
            LogUtils.i(TAG, "mErrorLayoutRes:" + this.mErrorLayoutRes);
            layoutInflater.inflate(this.mErrorLayoutRes, (ViewGroup)object, true);
        } else {
            object.addView(view);
        }
        WebParentLayout webParentLayout = this;
        view = (ViewStub)webParentLayout.findViewById(R.id.mainframe_error_viewsub_id);
        int n = webParentLayout.indexOfChild(view);
        webParentLayout.removeViewInLayout(view);
        view = webParentLayout.getLayoutParams();
        if (view != null) {
            this.mErrorLayout = object;
            this.addView((View)object, n, (ViewGroup.LayoutParams)view);
        } else {
            this.mErrorLayout = object;
            this.addView((View)object, n);
        }
        object.setVisibility(0);
        int n2 = this.mClickId;
        if (n2 != -1) {
            final View view2 = object.findViewById(n2);
            if (view2 != null) {
                View.OnClickListener onClickListener2;
                object = onClickListener2;
                onClickListener2 = new View.OnClickListener(){

                    public void onClick(View view) {
                        if (WebParentLayout.this.getWebView() != null) {
                            1 v0 = this;
                            v0.view2.setClickable(false);
                            v0.WebParentLayout.this.getWebView().reload();
                        }
                    }
                };
                view2.setOnClickListener((View.OnClickListener)object);
                return;
            }
            if (LogUtils.isDebug()) {
                LogUtils.e(TAG, "ClickView is null , cannot bind accurate view to refresh or reload .");
            }
        }
        View.OnClickListener onClickListener3 = onClickListener;
        onClickListener = new View.OnClickListener(){
            final /* synthetic */ FrameLayout val$mFrameLayout;
            {
                this.val$mFrameLayout = frameLayout;
            }

            public void onClick(View view) {
                if (WebParentLayout.this.getWebView() != null) {
                    2 v0 = this;
                    v0.val$mFrameLayout.setClickable(false);
                    v0.WebParentLayout.this.getWebView().reload();
                }
            }
        };
        object.setOnClickListener(onClickListener3);
    }

    void bindController(AbsAgentWebUIController absAgentWebUIController) {
        WebParentLayout webParentLayout = this;
        webParentLayout.mAgentWebUIController = absAgentWebUIController;
        absAgentWebUIController.bindWebParent(webParentLayout, (Activity)webParentLayout.getContext());
    }

    void showPageMainFrameError() {
        View view;
        FrameLayout frameLayout = this.mErrorLayout;
        if (frameLayout != null) {
            frameLayout.setVisibility(0);
        } else {
            WebParentLayout webParentLayout = this;
            webParentLayout.createErrorLayout();
            frameLayout = webParentLayout.mErrorLayout;
        }
        int n = this.mClickId;
        if (n != -1 && (view = frameLayout.findViewById(n)) != null) {
            view.setClickable(true);
        } else {
            frameLayout.setClickable(true);
        }
    }

    void hideErrorLayout() {
        if ((this = this.findViewById(R.id.mainframe_error_container_id)) != null) {
            this.setVisibility(8);
        }
    }

    void setErrorView(View view) {
        this.mErrorView = view;
    }

    void setErrorLayoutRes(int n, int n2) {
        this.mClickId = n2;
        if (n2 <= 0) {
            this.mClickId = -1;
        }
        this.mErrorLayoutRes = n;
        if (n <= 0) {
            this.mErrorLayoutRes = R.layout.agentweb_error_page;
        }
    }

    @Override
    public AbsAgentWebUIController provide() {
        return this.mAgentWebUIController;
    }

    void bindWebView(WebView webView) {
        if (this.mWebView == null) {
            this.mWebView = webView;
        }
    }

    WebView getWebView() {
        return this.mWebView;
    }
}

