/*
 * Decompiled with CFR 0.152.
 */
package com.just.agentweb;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import com.just.agentweb.AgentWebUtils;
import com.just.agentweb.BaseIndicatorView;
import com.just.agentweb.LogUtils;

public class WebIndicator
extends BaseIndicatorView {
    public static final int MAX_UNIFORM_SPEED_DURATION = 8000;
    public static final int MAX_DECELERATE_SPEED_DURATION = 450;
    public static final int DO_END_ANIMATION_DURATION = 600;
    public static final int UN_START = 0;
    public static final int STARTED = 1;
    public static final int FINISH = 2;
    private int mColor;
    private Paint mPaint;
    private Animator mAnimator;
    private int mTargetWidth;
    private int mCurrentMaxUniformSpeedDuration;
    private int mCurrentMaxDecelerateSpeedDuration;
    private int mCurrentDoEndAnimationDuration;
    private int indicatorStatus;
    private float mCurrentProgress;
    public int mWebIndicatorDefaultHeight;
    private ValueAnimator.AnimatorUpdateListener mAnimatorUpdateListener;
    private AnimatorListenerAdapter mAnimatorListenerAdapter;

    public WebIndicator(Context context) {
        this(context, null);
    }

    public WebIndicator(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public WebIndicator(Context context, AttributeSet attributeSet, int n) {
        AnimatorListenerAdapter animatorListenerAdapter;
        ValueAnimator.AnimatorUpdateListener animatorUpdateListener;
        WebIndicator webIndicator = this;
        super(context, attributeSet, n);
        webIndicator.mTargetWidth = 0;
        webIndicator.mCurrentMaxUniformSpeedDuration = 8000;
        webIndicator.mCurrentMaxDecelerateSpeedDuration = 450;
        webIndicator.mCurrentDoEndAnimationDuration = 600;
        webIndicator.indicatorStatus = 0;
        webIndicator.mCurrentProgress = 0.0f;
        webIndicator.mWebIndicatorDefaultHeight = 3;
        Object object = animatorUpdateListener;
        animatorUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                1 v0 = this;
                float f = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                WebIndicator.access$002(v0.WebIndicator.this, f);
                v0.WebIndicator.this.invalidate();
            }
        };
        webIndicator.mAnimatorUpdateListener = object;
        object = animatorListenerAdapter;
        animatorListenerAdapter = new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                WebIndicator.this.doEnd();
            }
        };
        webIndicator.mAnimatorListenerAdapter = object;
        webIndicator.init(context, attributeSet, n);
    }

    private void init(Context context, AttributeSet attributeSet, int n) {
        WebIndicator webIndicator = this;
        webIndicator.mPaint = new Paint();
        webIndicator.mColor = Color.parseColor((String)"#1aad19");
        webIndicator.mPaint.setAntiAlias(true);
        webIndicator.mPaint.setColor(this.mColor);
        webIndicator.mPaint.setDither(true);
        webIndicator.mPaint.setStrokeCap(Paint.Cap.SQUARE);
        this.mTargetWidth = context.getResources().getDisplayMetrics().widthPixels;
        this.mWebIndicatorDefaultHeight = AgentWebUtils.dp2px(context, 3.0f);
    }

    private void startAnim(boolean bl) {
        float f;
        float f2 = bl ? 100.0f : 95.0f;
        Animator animator = this.mAnimator;
        if (animator != null && animator.isStarted()) {
            this.mAnimator.cancel();
        }
        if ((f = this.mCurrentProgress) == 0.0f) {
            f = 1.0E-8f;
        }
        this.mCurrentProgress = f;
        if (!bl) {
            AnimatorSet animatorSet = new AnimatorSet();
            float f3 = f2 * 0.6f;
            ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{this.mCurrentProgress, f3});
            ValueAnimator valueAnimator2 = ValueAnimator.ofFloat((float[])new float[]{f3, f2});
            ValueAnimator valueAnimator3 = valueAnimator;
            float f4 = (long)((1.0f - this.mCurrentProgress / 100.0f - 0.05f) * (float)this.mCurrentMaxUniformSpeedDuration);
            long l = (long)(f4 * 0.6f);
            long l2 = (long)(f4 * 0.4f);
            valueAnimator3.setInterpolator((TimeInterpolator)new LinearInterpolator());
            valueAnimator3.setDuration(l2);
            valueAnimator.addUpdateListener(this.mAnimatorUpdateListener);
            valueAnimator2.setInterpolator((TimeInterpolator)new LinearInterpolator());
            valueAnimator2.setDuration(l);
            valueAnimator2.addUpdateListener(this.mAnimatorUpdateListener);
            animatorSet.play((Animator)valueAnimator2).after((Animator)valueAnimator);
            animatorSet.start();
            this.mAnimator = animatorSet;
        } else {
            AnimatorSet animatorSet;
            ValueAnimator valueAnimator = null;
            if (f < 95.0f) {
                ValueAnimator valueAnimator4 = valueAnimator = ValueAnimator.ofFloat((float[])new float[]{f, 95.0f});
                valueAnimator4.setDuration((long)((1.0f - this.mCurrentProgress / 100.0f - 0.05f) * (float)this.mCurrentMaxDecelerateSpeedDuration));
                valueAnimator4.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
                valueAnimator.addUpdateListener(this.mAnimatorUpdateListener);
            }
            float[] fArray = new float[2];
            Object object = fArray;
            fArray[0] = 1.0f;
            fArray[1] = 0.0f;
            ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this, (String)"alpha", (float[])object);
            object = objectAnimator;
            objectAnimator.setDuration((long)this.mCurrentDoEndAnimationDuration);
            ValueAnimator valueAnimator5 = ValueAnimator.ofFloat((float[])new float[]{95.0f, 100.0f});
            valueAnimator5.setDuration((long)this.mCurrentDoEndAnimationDuration);
            valueAnimator5.addUpdateListener(this.mAnimatorUpdateListener);
            Object object2 = animatorSet;
            new AnimatorSet().playTogether(new Animator[]{(Animator)object, valueAnimator5});
            if (valueAnimator != null) {
                AnimatorSet animatorSet2;
                object = animatorSet2;
                object();
                animatorSet2.play((Animator)object2).after((Animator)valueAnimator);
                object2 = object;
            }
            AnimatorSet animatorSet3 = object2;
            animatorSet3.addListener((Animator.AnimatorListener)this.mAnimatorListenerAdapter);
            animatorSet3.start();
            this.mAnimator = animatorSet3;
        }
        this.indicatorStatus = 1;
    }

    private void doEnd() {
        if (this.indicatorStatus == 2 && this.mCurrentProgress == 100.0f) {
            WebIndicator webIndicator = this;
            webIndicator.setVisibility(8);
            webIndicator.mCurrentProgress = 0.0f;
            webIndicator.setAlpha(1.0f);
        }
        this.indicatorStatus = 0;
    }

    static /* synthetic */ float access$002(WebIndicator webIndicator, float f) {
        webIndicator.mCurrentProgress = f;
        return f;
    }

    public void setColor(int n) {
        this.mColor = n;
        this.mPaint.setColor(n);
    }

    public void setColor(String string2) {
        this.setColor(Color.parseColor((String)string2));
    }

    protected void onMeasure(int n, int n2) {
        int n3 = View.MeasureSpec.getMode((int)n);
        int n4 = n2;
        n = View.MeasureSpec.getSize((int)n);
        n2 = View.MeasureSpec.getMode((int)n4);
        int n5 = View.MeasureSpec.getSize((int)n4);
        if (n3 == Integer.MIN_VALUE && n > this.getContext().getResources().getDisplayMetrics().widthPixels) {
            n = this.getContext().getResources().getDisplayMetrics().widthPixels;
        }
        if (n2 == Integer.MIN_VALUE) {
            n5 = this.mWebIndicatorDefaultHeight;
        }
        this.setMeasuredDimension(n, n5);
    }

    protected void onDraw(Canvas canvas) {
    }

    protected void dispatchDraw(Canvas canvas) {
        WebIndicator webIndicator = this;
        float f = webIndicator.mCurrentProgress / 100.0f * Float.valueOf(this.getWidth()).floatValue();
        float f2 = webIndicator.getHeight();
        Paint paint = webIndicator.mPaint;
        canvas.drawRect(0.0f, 0.0f, f, f2, paint);
    }

    @Override
    public void show() {
        if (this.getVisibility() == 8) {
            WebIndicator webIndicator = this;
            webIndicator.setVisibility(0);
            webIndicator.mCurrentProgress = 0.0f;
            webIndicator.startAnim(false);
        }
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        WebIndicator webIndicator = this;
        super.onSizeChanged(n, n2, n3, n4);
        webIndicator.mTargetWidth = webIndicator.getMeasuredWidth();
        n = webIndicator.getContext().getResources().getDisplayMetrics().widthPixels;
        n2 = webIndicator.mTargetWidth;
        if (n2 >= n) {
            WebIndicator webIndicator2 = this;
            webIndicator2.mCurrentMaxDecelerateSpeedDuration = 450;
            webIndicator2.mCurrentMaxUniformSpeedDuration = 8000;
            webIndicator2.mCurrentDoEndAnimationDuration = 450;
        } else {
            float f = (float)n2 / Float.valueOf(n).floatValue();
            this.mCurrentMaxUniformSpeedDuration = (int)(f * 8000.0f);
            this.mCurrentMaxDecelerateSpeedDuration = (int)(f * 450.0f);
            this.mCurrentDoEndAnimationDuration = (int)(f * 600.0f);
        }
        LogUtils.i("WebProgress", "CURRENT_MAX_UNIFORM_SPEED_DURATION" + this.mCurrentMaxUniformSpeedDuration);
    }

    public void setProgress(float f) {
        if (this.getVisibility() == 8) {
            this.setVisibility(0);
        }
        if (f < 95.0f) {
            return;
        }
        if (this.indicatorStatus != 2) {
            this.startAnim(true);
        }
    }

    @Override
    public void hide() {
        this.indicatorStatus = 2;
    }

    protected void onDetachedFromWindow() {
        WebIndicator webIndicator = this;
        super.onDetachedFromWindow();
        Animator animator = webIndicator.mAnimator;
        if (animator != null && animator.isStarted()) {
            this.mAnimator.cancel();
            this.mAnimator = null;
        }
    }

    @Override
    public void reset() {
        this.mCurrentProgress = 0.0f;
        Animator animator = this.mAnimator;
        if (animator != null && animator.isStarted()) {
            this.mAnimator.cancel();
        }
    }

    @Override
    public void setProgress(int n) {
        this.setProgress(Float.valueOf(n).floatValue());
    }

    public FrameLayout.LayoutParams offerLayoutParams() {
        return new FrameLayout.LayoutParams(-1, this.mWebIndicatorDefaultHeight);
    }
}

