/*
 * Decompiled with CFR 0.152.
 */
package com.just.agentweb;

import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.Properties;

public final class RomUtils {
    private static final String[] ROM_HUAWEI = new String[]{"huawei"};
    private static final String VERSION_PROPERTY_HUAWEI = "ro.build.version.emui";
    private static final String UNKNOWN = "unknown";
    private static RomInfo bean;

    private RomUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean isHuawei() {
        return ROM_HUAWEI[0].equals(RomUtils.getRomInfo().name);
    }

    public static RomInfo getRomInfo() {
        Object object = bean;
        if (object != null) {
            return object;
        }
        bean = new RomInfo();
        object = RomUtils.getManufacturer();
        String[] stringArray = ROM_HUAWEI;
        if (RomUtils.isRightRom(RomUtils.getBrand(), (String)object, ROM_HUAWEI)) {
            RomInfo.access$002(bean, stringArray[0]);
            object = RomUtils.getRomVersion(VERSION_PROPERTY_HUAWEI);
            stringArray = ((String)object).split("_");
            if (stringArray.length > 1) {
                RomInfo.access$102(bean, stringArray[1]);
            } else {
                RomInfo.access$102(bean, (String)object);
            }
            return bean;
        }
        RomInfo.access$002(bean, (String)object);
        RomInfo.access$102(bean, RomUtils.getRomVersion(""));
        return bean;
    }

    private static boolean isRightRom(String string2, String string3, String ... stringArray) {
        for (String string4 : stringArray) {
            if (!string2.contains(string4) && !string3.contains(string4)) {
                continue;
            }
            return true;
        }
        return false;
    }

    private static String getManufacturer() {
        block4: {
            String string2;
            try {
                string2 = Build.MANUFACTURER;
            }
            catch (Throwable throwable) {}
            if (TextUtils.isEmpty((CharSequence)string2)) break block4;
            return string2.toLowerCase();
        }
        return UNKNOWN;
    }

    private static String getBrand() {
        block4: {
            String string2;
            try {
                string2 = Build.BRAND;
            }
            catch (Throwable throwable) {}
            if (TextUtils.isEmpty((CharSequence)string2)) break block4;
            return string2.toLowerCase();
        }
        return UNKNOWN;
    }

    private static String getRomVersion(String string2) {
        String string3;
        block7: {
            string3 = "";
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                string3 = RomUtils.getSystemProperty(string2);
            }
            if (TextUtils.isEmpty((CharSequence)string3) || string3.equals(UNKNOWN)) {
                try {
                    string2 = Build.DISPLAY;
                }
                catch (Throwable throwable) {}
                if (TextUtils.isEmpty((CharSequence)string2)) break block7;
                string3 = string2 = string2.toLowerCase();
            }
        }
        if (TextUtils.isEmpty((CharSequence)string3)) {
            return UNKNOWN;
        }
        return string3;
    }

    private static String getSystemProperty(String string2) {
        String string3 = RomUtils.getSystemPropertyByShell(string2);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            return string3;
        }
        string3 = RomUtils.getSystemPropertyByStream(string2);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            return string3;
        }
        if (Build.VERSION.SDK_INT < 28) {
            return RomUtils.getSystemPropertyByReflect(string2);
        }
        return string3;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getSystemPropertyByShell(String object) {
        BufferedReader bufferedReader;
        block16: {
            void var0_3;
            block15: {
                BufferedReader bufferedReader2;
                block17: {
                    block14: {
                        BufferedReader bufferedReader3;
                        bufferedReader = null;
                        object = Runtime.getRuntime().exec("getprop " + (String)object);
                        bufferedReader2 = bufferedReader3;
                        bufferedReader3 = new BufferedReader(new InputStreamReader(((Process)object).getInputStream()), 1024);
                        object = bufferedReader3.readLine();
                        if (object == null) break block14;
                        try {
                            bufferedReader2.close();
                            return object;
                        }
                        catch (IOException iOException) {}
                        return object;
                    }
                    try {}
                    catch (IOException iOException) {
                        return "";
                    }
                    break block17;
                    catch (Throwable throwable) {
                        bufferedReader = bufferedReader2;
                        break block15;
                    }
                    catch (IOException iOException) {
                        bufferedReader = bufferedReader2;
                        break block16;
                    }
                }
                bufferedReader2.close();
                return "";
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (bufferedReader == null) throw var0_3;
            try {
                bufferedReader.close();
                throw var0_3;
            }
            catch (IOException iOException) {}
            throw var0_3;
            catch (IOException iOException) {}
        }
        if (bufferedReader == null) return "";
        {
            bufferedReader.close();
        }
        return "";
    }

    private static String getSystemPropertyByStream(String string2) {
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(new File(Environment.getRootDirectory(), "build.prop")));
            return properties.getProperty(string2, "");
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static String getSystemPropertyByReflect(String string2) {
        Class<?> clazz;
        try {
            clazz = Class.forName("android.os.SystemProperties");
        }
        catch (Exception exception) {
            return "";
        }
        String string3 = "get";
        Class[] classArray = new Class[2];
        classArray[0] = String.class;
        classArray[1] = String.class;
        Method method = clazz.getMethod(string3, classArray);
        Class<?> clazz2 = clazz;
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = objectArray;
        objectArray[0] = string2;
        objectArray3[1] = "";
        return (String)method.invoke(clazz2, objectArray2);
    }

    public static class RomInfo {
        private String name;
        private String version;

        static /* synthetic */ String access$002(RomInfo romInfo, String string2) {
            romInfo.name = string2;
            return string2;
        }

        static /* synthetic */ String access$102(RomInfo romInfo, String string2) {
            romInfo.version = string2;
            return string2;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String toString() {
            return "RomInfo{name=" + this.name + ", version=" + this.version + "}";
        }
    }
}

