/*
 * Decompiled with CFR 0.152.
 */
package com.just.agentweb;

import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.os.Process;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Iterator;

class ProcessUtils {
    ProcessUtils() {
    }

    static String getCurrentProcessName(Context context) {
        String string2 = ProcessUtils.getCurrentProcessNameByFile();
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            return string2;
        }
        string2 = ProcessUtils.getCurrentProcessNameByAms(context);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            return string2;
        }
        return ProcessUtils.getCurrentProcessNameByReflect(context);
    }

    private static String getCurrentProcessNameByFile() {
        BufferedReader bufferedReader;
        File file;
        File file2 = file;
        try {
            file = new File("/proc/" + Process.myPid() + "/cmdline");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
        BufferedReader bufferedReader2 = bufferedReader;
        String string2 = new BufferedReader(new FileReader(file2)).readLine().trim();
        bufferedReader2.close();
        return string2;
    }

    private static String getCurrentProcessNameByAms(Context object) {
        if ((object = (ActivityManager)object.getSystemService("activity")) == null) {
            return "";
        }
        if ((object = object.getRunningAppProcesses()) != null && object.size() != 0) {
            int n = Process.myPid();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object object2 = (ActivityManager.RunningAppProcessInfo)iterator.next();
                if (object2.pid != n || (object2 = object2.processName) == null) continue;
                return object2;
            }
            return "";
        }
        return "";
    }

    private static String getCurrentProcessNameByReflect(Context object) {
        Context context = object;
        object = "";
        Object object2 = (Application)context.getApplicationContext();
        Field field = object2.getClass().getField("mLoadedApk");
        ((AccessibleObject)field).setAccessible(true);
        object2 = field.get(object2);
        Field field2 = object2.getClass().getDeclaredField("mActivityThread");
        ((AccessibleObject)field2).setAccessible(true);
        object2 = field2.get(object2);
        try {
            object = (String)object2.getClass().getDeclaredMethod("getProcessName", new Class[0]).invoke(object2, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return object;
    }
}

