/*
 * Decompiled with CFR 0.152.
 */
package com.just.agentweb;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.core.view.MotionEventCompat;
import androidx.core.view.NestedScrollingChild;
import androidx.core.view.NestedScrollingChildHelper;
import com.just.agentweb.AgentWebView;

public class NestedScrollAgentWebView
extends AgentWebView
implements NestedScrollingChild {
    private int mLastMotionY;
    private final int[] mScrollOffset;
    private final int[] mScrollConsumed;
    private int mNestedYOffset;
    private NestedScrollingChildHelper mChildHelper;

    public NestedScrollAgentWebView(Context context) {
        NestedScrollAgentWebView nestedScrollAgentWebView = this;
        super(context);
        nestedScrollAgentWebView.mScrollOffset = new int[2];
        nestedScrollAgentWebView.mScrollConsumed = new int[2];
        nestedScrollAgentWebView.init();
    }

    public NestedScrollAgentWebView(Context context, AttributeSet attributeSet) {
        NestedScrollAgentWebView nestedScrollAgentWebView = this;
        super(context, attributeSet);
        nestedScrollAgentWebView.mScrollOffset = new int[2];
        nestedScrollAgentWebView.mScrollConsumed = new int[2];
        nestedScrollAgentWebView.init();
    }

    private void init() {
        NestedScrollingChildHelper nestedScrollingChildHelper;
        NestedScrollingChildHelper nestedScrollingChildHelper2 = nestedScrollingChildHelper;
        nestedScrollingChildHelper = new NestedScrollingChildHelper((View)this);
        this.mChildHelper = nestedScrollingChildHelper2;
        this.setNestedScrollingEnabled(true);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        MotionEvent motionEvent2 = motionEvent;
        int n = 0;
        MotionEvent motionEvent3 = MotionEvent.obtain((MotionEvent)motionEvent2);
        int n2 = MotionEventCompat.getActionMasked((MotionEvent)motionEvent2);
        if (n2 == 0) {
            this.mNestedYOffset = 0;
        }
        int n3 = n2;
        MotionEvent motionEvent4 = motionEvent;
        n2 = (int)motionEvent4.getY();
        motionEvent4.offsetLocation(0.0f, (float)this.mNestedYOffset);
        switch (n3) {
            default: {
                break;
            }
            case 2: {
                int[] nArray;
                int n4 = this.mLastMotionY - n2;
                int[] nArray2 = this.mScrollConsumed;
                int[] nArray3 = this.mScrollOffset;
                if (this.dispatchNestedPreScroll(0, n4, nArray2, nArray3)) {
                    n4 -= this.mScrollConsumed[1];
                    motionEvent3.offsetLocation(0.0f, (float)this.mScrollOffset[1]);
                    this.mNestedYOffset += this.mScrollOffset[1];
                }
                this.mLastMotionY = n2 - this.mScrollOffset[1];
                n = this.getScrollY();
                if (this.dispatchNestedScroll(0, n4 = Math.max(0, n + n4) - n, 0, n = n4 - n4, nArray = this.mScrollOffset)) {
                    n4 = this.mLastMotionY;
                    int n5 = this.mScrollOffset[1];
                    this.mLastMotionY = n4 - n5;
                    motionEvent3.offsetLocation(0.0f, (float)n5);
                    this.mNestedYOffset += this.mScrollOffset[1];
                }
                n = super.onTouchEvent(motionEvent3) ? 1 : 0;
                motionEvent3.recycle();
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                this.stopNestedScroll();
                n = super.onTouchEvent(motionEvent);
                break;
            }
            case 0: {
                this.mLastMotionY = n2;
                this.startNestedScroll(2);
                n = super.onTouchEvent(motionEvent);
            }
        }
        return n != 0;
    }

    public void setNestedScrollingEnabled(boolean bl) {
        this.mChildHelper.setNestedScrollingEnabled(bl);
    }

    public boolean isNestedScrollingEnabled() {
        return this.mChildHelper.isNestedScrollingEnabled();
    }

    public boolean startNestedScroll(int n) {
        return this.mChildHelper.startNestedScroll(n);
    }

    public void stopNestedScroll() {
        this.mChildHelper.stopNestedScroll();
    }

    public boolean hasNestedScrollingParent() {
        return this.mChildHelper.hasNestedScrollingParent();
    }

    public boolean dispatchNestedScroll(int n, int n2, int n3, int n4, int[] nArray) {
        return this.mChildHelper.dispatchNestedScroll(n, n2, n3, n4, nArray);
    }

    public boolean dispatchNestedPreScroll(int n, int n2, int[] nArray, int[] nArray2) {
        return this.mChildHelper.dispatchNestedPreScroll(n, n2, nArray, nArray2);
    }

    public boolean dispatchNestedFling(float f, float f2, boolean bl) {
        return this.mChildHelper.dispatchNestedFling(f, f2, bl);
    }

    public boolean dispatchNestedPreFling(float f, float f2) {
        return this.mChildHelper.dispatchNestedPreFling(f, f2);
    }
}

