/*
 * Decompiled with CFR 0.152.
 */
package com.just.agentweb;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.webkit.WebView;
import android.widget.FrameLayout;
import com.just.agentweb.AgentWebConfig;
import com.just.agentweb.AgentWebUtils;
import com.just.agentweb.AgentWebView;
import com.just.agentweb.BaseIndicatorSpec;
import com.just.agentweb.BaseIndicatorView;
import com.just.agentweb.IWebLayout;
import com.just.agentweb.LogUtils;
import com.just.agentweb.LollipopFixedWebView;
import com.just.agentweb.R;
import com.just.agentweb.WebCreator;
import com.just.agentweb.WebIndicator;
import com.just.agentweb.WebParentLayout;

public class DefaultWebCreator
implements WebCreator {
    private static final String TAG = "DefaultWebCreator";
    private Activity mActivity;
    private ViewGroup mViewGroup;
    private boolean mIsNeedDefaultProgress;
    private int mIndex;
    private BaseIndicatorView mProgressView;
    private ViewGroup.LayoutParams mLayoutParams;
    private int mColor;
    private int mHeight;
    private boolean mIsCreated;
    private IWebLayout mIWebLayout;
    private BaseIndicatorSpec mBaseIndicatorSpec;
    private WebView mWebView;
    private FrameLayout mFrameLayout;
    private View mTargetProgress;
    private int mWebViewType;

    protected DefaultWebCreator(Activity activity, ViewGroup viewGroup, ViewGroup.LayoutParams layoutParams, int n, int n2, int n3, WebView webView, IWebLayout iWebLayout) {
        this.mIsCreated = false;
        this.mFrameLayout = null;
        this.mWebViewType = 1;
        this.mActivity = activity;
        this.mViewGroup = viewGroup;
        this.mIsNeedDefaultProgress = true;
        this.mIndex = n;
        this.mColor = n2;
        this.mLayoutParams = layoutParams;
        this.mHeight = n3;
        this.mWebView = webView;
        this.mIWebLayout = iWebLayout;
    }

    protected DefaultWebCreator(Activity activity, ViewGroup viewGroup, ViewGroup.LayoutParams layoutParams, int n, WebView webView, IWebLayout iWebLayout) {
        this.mColor = -1;
        this.mIsCreated = false;
        this.mFrameLayout = null;
        this.mWebViewType = 1;
        this.mActivity = activity;
        this.mViewGroup = viewGroup;
        this.mIsNeedDefaultProgress = false;
        this.mIndex = n;
        this.mLayoutParams = layoutParams;
        this.mWebView = webView;
        this.mIWebLayout = iWebLayout;
    }

    protected DefaultWebCreator(Activity activity, ViewGroup viewGroup, ViewGroup.LayoutParams layoutParams, int n, BaseIndicatorView baseIndicatorView, WebView webView, IWebLayout iWebLayout) {
        this.mColor = -1;
        this.mIsCreated = false;
        this.mFrameLayout = null;
        this.mWebViewType = 1;
        this.mActivity = activity;
        this.mViewGroup = viewGroup;
        this.mIsNeedDefaultProgress = false;
        this.mIndex = n;
        this.mLayoutParams = layoutParams;
        this.mProgressView = baseIndicatorView;
        this.mWebView = webView;
        this.mIWebLayout = iWebLayout;
    }

    private ViewGroup createLayout() {
        FrameLayout.LayoutParams layoutParams;
        FrameLayout.LayoutParams layoutParams2;
        View view;
        WebParentLayout webParentLayout;
        DefaultWebCreator defaultWebCreator = this;
        BaseIndicatorSpec baseIndicatorSpec = defaultWebCreator.mActivity;
        WebParentLayout webParentLayout2 = webParentLayout;
        new WebParentLayout((Context)baseIndicatorSpec).setId(R.id.web_parent_layout_id);
        webParentLayout2.setBackgroundColor(-1);
        if (defaultWebCreator.mIWebLayout == null) {
            view = this.createWebView();
            this.mWebView = view;
        } else {
            view = this.webLayout();
        }
        View view2 = view;
        view = layoutParams2;
        layoutParams2 = new FrameLayout.LayoutParams(-1, -1);
        webParentLayout2.addView(view2, (ViewGroup.LayoutParams)view);
        webParentLayout2.bindWebView(this.mWebView);
        LogUtils.i(TAG, "  instanceof  AgentWebView:" + (this.mWebView instanceof AgentWebView));
        if (this.mWebView instanceof AgentWebView) {
            this.mWebViewType = 2;
        }
        ViewStub viewStub = new ViewStub((Context)baseIndicatorSpec);
        viewStub.setId(R.id.mainframe_error_viewsub_id);
        view = layoutParams;
        layoutParams = new FrameLayout.LayoutParams(-1, -1);
        webParentLayout2.addView((View)viewStub, (ViewGroup.LayoutParams)view);
        boolean bl = this.mIsNeedDefaultProgress;
        if (bl) {
            FrameLayout.LayoutParams layoutParams3;
            WebIndicator webIndicator;
            WebIndicator webIndicator2 = webIndicator;
            webIndicator = new WebIndicator((Context)baseIndicatorSpec);
            if (this.mHeight > 0) {
                FrameLayout.LayoutParams layoutParams4;
                layoutParams3 = layoutParams4;
                layoutParams4 = new FrameLayout.LayoutParams(-2, AgentWebUtils.dp2px((Context)baseIndicatorSpec, this.mHeight));
            } else {
                layoutParams3 = webIndicator2.offerLayoutParams();
            }
            int n = this.mColor;
            if (n != -1) {
                webIndicator2.setColor(n);
            }
            layoutParams3.gravity = 48;
            this.mBaseIndicatorSpec = webIndicator2;
            webParentLayout2.addView((View)webIndicator2, (ViewGroup.LayoutParams)layoutParams3);
            webIndicator2.setVisibility(8);
        } else if (!bl && (baseIndicatorSpec = this.mProgressView) != null) {
            this.mBaseIndicatorSpec = baseIndicatorSpec;
            BaseIndicatorSpec baseIndicatorSpec2 = this.mBaseIndicatorSpec;
            webParentLayout2.addView((View)baseIndicatorSpec2, (ViewGroup.LayoutParams)baseIndicatorSpec2.offerLayoutParams());
            this.mProgressView.setVisibility(8);
        }
        return webParentLayout2;
    }

    private View webLayout() {
        Object object = this.mIWebLayout.getWebView();
        if (object == null) {
            DefaultWebCreator defaultWebCreator = this;
            object = defaultWebCreator.createWebView();
            defaultWebCreator.mIWebLayout.getLayout().addView(object, -1, -1);
            LogUtils.i(TAG, "add webview");
        } else {
            this.mWebViewType = 3;
        }
        this.mWebView = object;
        return this.mIWebLayout.getLayout();
    }

    private WebView createWebView() {
        WebView webView = this.mWebView;
        if (webView != null) {
            this.mWebViewType = 3;
        } else if (AgentWebConfig.IS_KITKAT_OR_BELOW_KITKAT) {
            AgentWebView agentWebView;
            webView = agentWebView;
            agentWebView = new AgentWebView((Context)this.mActivity);
            this.mWebViewType = 2;
        } else {
            LollipopFixedWebView lollipopFixedWebView;
            webView = lollipopFixedWebView;
            lollipopFixedWebView = new LollipopFixedWebView((Context)this.mActivity);
            this.mWebViewType = 1;
        }
        return webView;
    }

    public void setWebView(WebView webView) {
        this.mWebView = webView;
    }

    public FrameLayout getFrameLayout() {
        return this.mFrameLayout;
    }

    public View getTargetProgress() {
        return this.mTargetProgress;
    }

    public void setTargetProgress(View view) {
        this.mTargetProgress = view;
    }

    @Override
    public DefaultWebCreator create() {
        if (this.mIsCreated) {
            return this;
        }
        this.mIsCreated = true;
        ViewGroup viewGroup = this.mViewGroup;
        if (viewGroup == null) {
            DefaultWebCreator defaultWebCreator = this;
            viewGroup = (FrameLayout)defaultWebCreator.createLayout();
            defaultWebCreator.mFrameLayout = viewGroup;
            defaultWebCreator.mActivity.setContentView((View)viewGroup);
        } else if (this.mIndex == -1) {
            ViewGroup viewGroup2 = viewGroup;
            DefaultWebCreator defaultWebCreator = this;
            viewGroup = (FrameLayout)defaultWebCreator.createLayout();
            defaultWebCreator.mFrameLayout = viewGroup;
            viewGroup2.addView((View)viewGroup, defaultWebCreator.mLayoutParams);
        } else {
            ViewGroup viewGroup3 = viewGroup;
            DefaultWebCreator defaultWebCreator = this;
            viewGroup = (FrameLayout)defaultWebCreator.createLayout();
            defaultWebCreator.mFrameLayout = viewGroup;
            int n = defaultWebCreator.mIndex;
            ViewGroup.LayoutParams layoutParams = defaultWebCreator.mLayoutParams;
            viewGroup3.addView((View)viewGroup, n, layoutParams);
        }
        return this;
    }

    @Override
    public WebView getWebView() {
        return this.mWebView;
    }

    @Override
    public FrameLayout getWebParentLayout() {
        return this.mFrameLayout;
    }

    @Override
    public int getWebViewType() {
        return this.mWebViewType;
    }

    public BaseIndicatorSpec offer() {
        return this.mBaseIndicatorSpec;
    }
}

