/*
 * Decompiled with CFR 0.152.
 */
package com.just.agentweb;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Handler;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.webkit.HttpAuthHandler;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.alipay.sdk.app.H5PayCallback;
import com.alipay.sdk.app.PayTask;
import com.alipay.sdk.util.H5PayResultModel;
import com.just.agentweb.AbsAgentWebUIController;
import com.just.agentweb.AgentWebConfig;
import com.just.agentweb.AgentWebUtils;
import com.just.agentweb.LogUtils;
import com.just.agentweb.MiddlewareWebClientBase;
import com.just.agentweb.PermissionInterceptor;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;

public class DefaultWebClient
extends MiddlewareWebClientBase {
    private static final int CONSTANTS_ABNORMAL_BIG = 7;
    public static final String INTENT_SCHEME = "intent://";
    public static final String WEBCHAT_PAY_SCHEME = "weixin://wap/pay?";
    public static final String ALIPAYS_SCHEME = "alipays://";
    public static final String HTTP_SCHEME = "http://";
    public static final String HTTPS_SCHEME = "https://";
    private static final boolean HAS_ALIPAY_LIB;
    private static final String TAG = "DefaultWebClient";
    public static final int DERECT_OPEN_OTHER_PAGE = 1001;
    public static final int ASK_USER_OPEN_OTHER_PAGE = 250;
    public static final int DISALLOW_OPEN_OTHER_APP = 62;
    public static final String SCHEME_SMS = "sms:";
    private WeakReference<Activity> mWeakReference;
    private WebViewClient mWebViewClient;
    private boolean webClientHelper;
    private int mUrlHandleWays;
    private boolean mIsInterceptUnkownUrl;
    private WeakReference<AbsAgentWebUIController> mAgentWebUIController;
    private WebView mWebView;
    private Handler.Callback mCallback;
    private Method onMainFrameErrorMethod;
    private Object mPayTask;
    private Set<String> mErrorUrlsSet;
    private Set<String> mWaittingFinishSet;

    DefaultWebClient(Builder builder) {
        DefaultWebClient defaultWebClient = this;
        DefaultWebClient defaultWebClient2 = this;
        super(builder.mClient);
        this.mWeakReference = null;
        this.webClientHelper = true;
        this.mUrlHandleWays = 250;
        this.mIsInterceptUnkownUrl = true;
        this.mAgentWebUIController = null;
        this.mCallback = null;
        this.onMainFrameErrorMethod = null;
        this.mErrorUrlsSet = new HashSet<String>();
        this.mWaittingFinishSet = new HashSet<String>();
        this.mWebView = builder.mWebView;
        defaultWebClient2.mWebViewClient = builder.mClient;
        defaultWebClient2.mWeakReference = new WeakReference<Activity>(builder.mActivity);
        defaultWebClient.webClientHelper = builder.mWebClientHelper;
        defaultWebClient.mAgentWebUIController = new WeakReference<AbsAgentWebUIController>(AgentWebUtils.getAgentWebUIControllerByWebView(builder.mWebView));
        this.mIsInterceptUnkownUrl = builder.mIsInterceptUnkownScheme;
        this.mUrlHandleWays = builder.mUrlHandleWays <= 0 ? 250 : builder.mUrlHandleWays;
    }

    private boolean deepLink(String string2) {
        int n = defaultWebClient2.mUrlHandleWays;
        if (n != 250) {
            if (n != 1001) {
                return false;
            }
            defaultWebClient2.lookup(string2);
            return true;
        }
        Activity activity = (Activity)defaultWebClient2.mWeakReference.get();
        if (activity == null) {
            return false;
        }
        ResolveInfo resolveInfo = defaultWebClient2.lookupResolveInfo(string2);
        if (resolveInfo == null) {
            return false;
        }
        ActivityInfo activityInfo = resolveInfo.activityInfo;
        LogUtils.e(TAG, "resolve package:" + resolveInfo.activityInfo.packageName + " app package:" + activity.getPackageName());
        if (activityInfo != null && !TextUtils.isEmpty((CharSequence)activityInfo.packageName) && activityInfo.packageName.equals(activity.getPackageName())) {
            return defaultWebClient2.lookup(string2);
        }
        if (defaultWebClient2.mAgentWebUIController.get() != null) {
            DefaultWebClient defaultWebClient = defaultWebClient2;
            String string3 = string2;
            DefaultWebClient defaultWebClient2 = defaultWebClient2.mWebView;
            string2 = defaultWebClient2.getUrl();
            activity = defaultWebClient.getCallback(string3);
            ((AbsAgentWebUIController)defaultWebClient2.mAgentWebUIController.get()).onOpenPagePrompt((WebView)defaultWebClient2, string2, (Handler.Callback)activity);
        }
        return true;
    }

    private int queryActiviesNumber(String string2) {
        int n;
        block8: {
            block7: {
                block6: {
                    try {
                        if (((DefaultWebClient)((Object)object)).mWeakReference.get() != null) break block6;
                        return 0;
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        if (LogUtils.isDebug()) {
                            uRISyntaxException.printStackTrace();
                        }
                        return 0;
                    }
                }
                DefaultWebClient defaultWebClient = object;
                Object object = Intent.parseUri((String)string2, (int)1);
                object = ((Activity)defaultWebClient.mWeakReference.get()).getPackageManager().queryIntentActivities((Intent)object, 65536);
                if (object != null) break block7;
                n = 0;
                break block8;
            }
            n = object.size();
        }
        return n;
    }

    private void handleIntentUrl(String string2) {
        block5: {
            try {
                if (TextUtils.isEmpty((CharSequence)string2)) break block5;
            }
            catch (Throwable throwable) {
                if (LogUtils.isDebug()) {
                    throwable.printStackTrace();
                }
                return;
            }
            if (!string2.startsWith(INTENT_SCHEME)) break block5;
            this.lookup(string2);
            return;
        }
    }

    private ResolveInfo lookupResolveInfo(String string2) {
        block4: {
            try {
                DefaultWebClient defaultWebClient = (Activity)defaultWebClient.mWeakReference.get();
                if (defaultWebClient != null) break block4;
                return null;
            }
            catch (Throwable throwable) {
                if (LogUtils.isDebug()) {
                    throwable.printStackTrace();
                }
                return null;
            }
        }
        return defaultWebClient.getPackageManager().resolveActivity(Intent.parseUri((String)string2, (int)1), 65536);
    }

    private boolean lookup(String string2) {
        block6: {
            block5: {
                DefaultWebClient defaultWebClient = (Activity)defaultWebClient.mWeakReference.get();
                if (defaultWebClient != null) break block5;
                return true;
            }
            PackageManager packageManager = defaultWebClient.getPackageManager();
            string2 = Intent.parseUri((String)string2, (int)1);
            if (packageManager.resolveActivity((Intent)string2, 65536) == null) break block6;
            try {
                defaultWebClient.startActivity((Intent)string2);
                return true;
            }
            catch (Throwable throwable) {
                if (!LogUtils.isDebug()) break block6;
                throwable.printStackTrace();
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isAlipay(final WebView webView, String string2) {
        boolean bl;
        block8: {
            H5PayCallback h5PayCallback;
            boolean bl2;
            String string3;
            PayTask payTask;
            try {
                Activity activity = (Activity)this.mWeakReference.get();
                if (activity == null) {
                    return false;
                }
                if (this.mPayTask == null) {
                    this.mPayTask = Class.forName("com.alipay.sdk.app.PayTask").getConstructor(Activity.class).newInstance(activity);
                }
                payTask = (PayTask)this.mPayTask;
                string3 = string2;
                bl2 = true;
            }
            catch (Throwable throwable) {
                return false;
            }
            H5PayCallback h5PayCallback2 = h5PayCallback;
            h5PayCallback = new H5PayCallback(){

                public void onPayResult(H5PayResultModel object) {
                    if (!TextUtils.isEmpty((CharSequence)(object = object.getReturnUrl()))) {
                        AgentWebUtils.runInUiThread(new Runnable(){
                            final /* synthetic */ String val$url;
                            {
                                this.val$url = string2;
                            }

                            @Override
                            public void run() {
                                webView.loadUrl(this.val$url);
                            }
                        });
                    }
                }
            };
            bl = payTask.payInterceptorWithUrl(string3, bl2, h5PayCallback2);
            if (!bl) break block8;
            LogUtils.i(TAG, "alipay-isIntercepted:" + bl + "  url:" + string2);
        }
        return bl;
    }

    private boolean handleCommonLink(String string2) {
        block7: {
            block6: {
                if (!(string2.startsWith("tel:") || string2.startsWith(SCHEME_SMS) || string2.startsWith("mailto:") || string2.startsWith("geo:0,0?q="))) {
                    return false;
                }
                DefaultWebClient defaultWebClient = (Activity)defaultWebClient.mWeakReference.get();
                if (defaultWebClient != null) break block6;
                return false;
            }
            DefaultWebClient defaultWebClient = defaultWebClient;
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)string2));
            try {
                defaultWebClient.startActivity(intent);
            }
            catch (ActivityNotFoundException activityNotFoundException) {
                if (!AgentWebConfig.DEBUG) break block7;
                activityNotFoundException.printStackTrace();
            }
        }
        return true;
    }

    private void onMainFrameError(WebView webView, int n, String string2, String string3) {
        block6: {
            block5: {
                Method method;
                block7: {
                    DefaultWebClient defaultWebClient = this;
                    defaultWebClient.mErrorUrlsSet.add(string3);
                    Class[] classArray = defaultWebClient.mWebViewClient;
                    if (defaultWebClient.mWebViewClient == null || !this.webClientHelper) break block6;
                    method = this.onMainFrameErrorMethod;
                    if (method != null) break block7;
                    Class[] classArray2 = classArray;
                    Class[] classArray3 = new Class[5];
                    classArray = classArray3;
                    classArray3[0] = AbsAgentWebUIController.class;
                    classArray3[1] = WebView.class;
                    classArray3[2] = Integer.TYPE;
                    classArray3[3] = String.class;
                    classArray3[4] = String.class;
                    this.onMainFrameErrorMethod = method = AgentWebUtils.isExistMethod(classArray2, "onMainFrameError", classArray);
                    if (method == null) break block6;
                }
                Method method2 = method;
                WebViewClient webViewClient = this.mWebViewClient;
                Object[] objectArray = new Object[5];
                objectArray[0] = this.mAgentWebUIController.get();
                objectArray[1] = webView;
                int n2 = 2;
                try {
                    objectArray[n2] = n;
                    objectArray[3] = string2;
                    objectArray[4] = string3;
                    method2.invoke((Object)webViewClient, objectArray);
                }
                catch (Throwable throwable) {
                    if (!LogUtils.isDebug()) break block5;
                    throwable.printStackTrace();
                }
            }
            return;
        }
        if (this.mAgentWebUIController.get() != null) {
            ((AbsAgentWebUIController)this.mAgentWebUIController.get()).onMainFrameError(webView, n, string2, string3);
        }
    }

    private void startActivity(String string2) {
        block7: {
            Intent intent;
            block6: {
                if (defaultWebClient2.mWeakReference.get() != null) break block6;
                return;
            }
            DefaultWebClient defaultWebClient = defaultWebClient2;
            DefaultWebClient defaultWebClient2 = intent;
            String string3 = string2;
            DefaultWebClient defaultWebClient3 = defaultWebClient2;
            defaultWebClient3();
            defaultWebClient3.setAction("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)string3));
            try {
                ((Activity)defaultWebClient.mWeakReference.get()).startActivity((Intent)defaultWebClient2);
            }
            catch (Exception exception) {
                if (!LogUtils.isDebug()) break block7;
                exception.printStackTrace();
            }
        }
    }

    private Handler.Callback getCallback(String string2) {
        2 v0;
        Handler.Callback callback = this.mCallback;
        if (callback != null) {
            return callback;
        }
        callback = v0;
        callback();
        this.mCallback = callback;
        return v0;
    }

    public static Builder createBuilder() {
        return new Builder();
    }

    static {
        boolean bl = true;
        try {
            Class.forName("com.alipay.sdk.app.PayTask");
        }
        catch (Throwable throwable) {
            bl = false;
        }
        HAS_ALIPAY_LIB = bl;
        LogUtils.i(TAG, "HAS_ALIPAY_LIB:" + bl);
    }

    @Override
    public boolean shouldOverrideUrlLoading(WebView webView, WebResourceRequest webResourceRequest) {
        String string2 = webResourceRequest.getUrl().toString();
        if (!string2.startsWith(HTTP_SCHEME) && !string2.startsWith(HTTPS_SCHEME)) {
            if (!this.webClientHelper) {
                return super.shouldOverrideUrlLoading(webView, webResourceRequest);
            }
            if (this.handleCommonLink(string2)) {
                return true;
            }
            if (string2.startsWith(INTENT_SCHEME)) {
                this.handleIntentUrl(string2);
                LogUtils.i(TAG, "intent url ");
                return true;
            }
            if (string2.startsWith(WEBCHAT_PAY_SCHEME)) {
                LogUtils.i(TAG, "lookup wechat to pay ~~");
                this.startActivity(string2);
                return true;
            }
            if (string2.startsWith(ALIPAYS_SCHEME) && this.lookup(string2)) {
                LogUtils.i(TAG, "alipays url lookup alipay ~~ ");
                return true;
            }
            if (this.queryActiviesNumber(string2) > 0 && this.deepLink(string2)) {
                LogUtils.i(TAG, "intercept url:" + string2);
                return true;
            }
            if (this.mIsInterceptUnkownUrl) {
                LogUtils.i(TAG, "intercept UnkownUrl :" + webResourceRequest.getUrl());
                return true;
            }
            return super.shouldOverrideUrlLoading(webView, webResourceRequest);
        }
        return this.webClientHelper && HAS_ALIPAY_LIB && this.isAlipay(webView, string2);
    }

    @Override
    public WebResourceResponse shouldInterceptRequest(WebView webView, String string2) {
        return super.shouldInterceptRequest(webView, string2);
    }

    @Override
    public void onReceivedHttpAuthRequest(WebView webView, HttpAuthHandler httpAuthHandler, String string2, String string3) {
        super.onReceivedHttpAuthRequest(webView, httpAuthHandler, string2, string3);
    }

    @Override
    public WebResourceResponse shouldInterceptRequest(WebView webView, WebResourceRequest webResourceRequest) {
        return super.shouldInterceptRequest(webView, webResourceRequest);
    }

    @Override
    public boolean shouldOverrideUrlLoading(WebView webView, String string2) {
        if (!string2.startsWith(HTTP_SCHEME) && !string2.startsWith(HTTPS_SCHEME)) {
            if (!this.webClientHelper) {
                return false;
            }
            if (this.handleCommonLink(string2)) {
                return true;
            }
            if (string2.startsWith(INTENT_SCHEME)) {
                this.handleIntentUrl(string2);
                return true;
            }
            if (string2.startsWith(WEBCHAT_PAY_SCHEME)) {
                this.startActivity(string2);
                return true;
            }
            if (string2.startsWith(ALIPAYS_SCHEME) && this.lookup(string2)) {
                return true;
            }
            if (this.queryActiviesNumber(string2) > 0 && this.deepLink(string2)) {
                LogUtils.i(TAG, "intercept OtherAppScheme");
                return true;
            }
            if (this.mIsInterceptUnkownUrl) {
                LogUtils.i(TAG, "intercept InterceptUnkownScheme : " + string2);
                return true;
            }
            return super.shouldOverrideUrlLoading(webView, string2);
        }
        return this.webClientHelper && HAS_ALIPAY_LIB && this.isAlipay(webView, string2);
    }

    @Override
    public void onPageStarted(WebView webView, String string2, Bitmap bitmap) {
        if (!this.mWaittingFinishSet.contains(string2)) {
            this.mWaittingFinishSet.add(string2);
        }
        super.onPageStarted(webView, string2, bitmap);
    }

    @Override
    public void onReceivedSslError(WebView webView, SslErrorHandler sslErrorHandler, SslError sslError) {
        if (this.mAgentWebUIController.get() != null) {
            ((AbsAgentWebUIController)this.mAgentWebUIController.get()).onShowSslCertificateErrorDialog(webView, sslErrorHandler, sslError);
        }
    }

    @Override
    public void onReceivedError(WebView webView, int n, String string2, String string3) {
        LogUtils.i(TAG, "onReceivedError\uff1a" + string2 + "  CODE:" + n);
        if (string3 == null && n != -12) {
            return;
        }
        if (n == -1) {
            return;
        }
        if (n != -2 && string3 != null && !string3.equals(webView.getUrl()) && !string3.equals(webView.getOriginalUrl())) {
            return;
        }
        this.onMainFrameError(webView, n, string2, string3);
    }

    @Override
    public void doUpdateVisitedHistory(WebView webView, String string2, boolean bl) {
        if (!this.mWaittingFinishSet.contains(string2)) {
            this.mWaittingFinishSet.add(string2);
        }
        super.doUpdateVisitedHistory(webView, string2, bl);
    }

    @Override
    public void onReceivedError(WebView object, WebResourceRequest object2, WebResourceError webResourceError) {
        String string2 = object2.getUrl().toString();
        int n = webResourceError.getErrorCode();
        if (!object2.isForMainFrame()) {
            return;
        }
        if (string2 == null && n != -12) {
            return;
        }
        if (n == -1) {
            return;
        }
        LogUtils.i(TAG, "onReceivedError:" + webResourceError.getDescription() + " code:" + webResourceError.getErrorCode() + " failingUrl:" + string2 + " getUrl:" + object.getUrl() + " getOriginalUrl:" + object.getOriginalUrl());
        if (n != -2 && string2 != null && !string2.equals(object.getUrl()) && !string2.equals(object.getOriginalUrl())) {
            return;
        }
        WebView webView = object;
        WebResourceError webResourceError2 = webResourceError;
        int n2 = webResourceError2.getErrorCode();
        object = webResourceError2.getDescription().toString();
        object2 = object2.getUrl().toString();
        this.onMainFrameError(webView, n2, (String)object, (String)object2);
    }

    @Override
    public void onPageFinished(WebView webView, String string2) {
        if (!this.mErrorUrlsSet.contains(string2) && this.mWaittingFinishSet.contains(string2)) {
            if (this.mAgentWebUIController.get() != null) {
                ((AbsAgentWebUIController)this.mAgentWebUIController.get()).onShowMainFrame();
            }
        } else {
            webView.setVisibility(0);
        }
        if (this.mWaittingFinishSet.contains(string2)) {
            this.mWaittingFinishSet.remove(string2);
        }
        if (!this.mErrorUrlsSet.isEmpty()) {
            this.mErrorUrlsSet.clear();
        }
        super.onPageFinished(webView, string2);
    }

    @Override
    public boolean shouldOverrideKeyEvent(WebView webView, KeyEvent keyEvent) {
        return super.shouldOverrideKeyEvent(webView, keyEvent);
    }

    @Override
    public void onReceivedHttpError(WebView webView, WebResourceRequest webResourceRequest, WebResourceResponse webResourceResponse) {
        super.onReceivedHttpError(webView, webResourceRequest, webResourceResponse);
    }

    @Override
    public void onScaleChanged(WebView webView, float f, float f2) {
        LogUtils.i(TAG, "onScaleChanged:" + f + "   n:" + f2);
        if (f2 - f > 7.0f) {
            webView.setInitialScale((int)(f / f2 * 100.0f));
        }
    }

    public static class Builder {
        private Activity mActivity;
        private WebViewClient mClient;
        private boolean mWebClientHelper;
        private PermissionInterceptor mPermissionInterceptor;
        private WebView mWebView;
        private boolean mIsInterceptUnkownScheme = true;
        private int mUrlHandleWays;

        public Builder setActivity(Activity activity) {
            this.mActivity = activity;
            return this;
        }

        public Builder setClient(WebViewClient webViewClient) {
            this.mClient = webViewClient;
            return this;
        }

        public Builder setWebClientHelper(boolean bl) {
            this.mWebClientHelper = bl;
            return this;
        }

        public Builder setPermissionInterceptor(PermissionInterceptor permissionInterceptor) {
            this.mPermissionInterceptor = permissionInterceptor;
            return this;
        }

        public Builder setWebView(WebView webView) {
            this.mWebView = webView;
            return this;
        }

        public Builder setInterceptUnkownUrl(boolean bl) {
            this.mIsInterceptUnkownScheme = bl;
            return this;
        }

        public Builder setUrlHandleWays(int n) {
            this.mUrlHandleWays = n;
            return this;
        }

        public DefaultWebClient build() {
            return new DefaultWebClient(this);
        }
    }

    public static enum OpenOtherPageWays {
        DERECT(1001),
        ASK(250),
        DISALLOW(62);

        int code;

        private OpenOtherPageWays(int n2) {
            this.code = n2;
        }
    }
}

