/*
 * Decompiled with CFR 0.152.
 */
package com.just.agentweb;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.webkit.DownloadListener;
import android.webkit.WebView;
import com.download.library.DownloadImpl;
import com.download.library.DownloadListenerAdapter;
import com.download.library.Extra;
import com.download.library.ResourceRequest;
import com.just.agentweb.AbsAgentWebUIController;
import com.just.agentweb.AgentWebConfig;
import com.just.agentweb.AgentWebUtils;
import com.just.agentweb.LogUtils;
import com.just.agentweb.PermissionInterceptor;
import com.just.agentweb.R;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultDownloadImpl
implements DownloadListener {
    private static final String TAG = "DefaultDownloadImpl";
    private static Handler mHandler = new Handler(Looper.getMainLooper());
    protected Context mContext;
    protected ConcurrentHashMap<String, ResourceRequest> mDownloadTasks;
    protected WeakReference<Activity> mActivityWeakReference;
    protected PermissionInterceptor mPermissionListener;
    protected WeakReference<AbsAgentWebUIController> mAgentWebUIController;
    private boolean isInstallDownloader;

    protected DefaultDownloadImpl(Activity activity, WebView webView, PermissionInterceptor permissionInterceptor) {
        DefaultDownloadImpl defaultDownloadImpl = this;
        this.mDownloadTasks = new ConcurrentHashMap();
        this.mActivityWeakReference = null;
        this.mPermissionListener = null;
        defaultDownloadImpl.mContext = activity.getApplicationContext();
        defaultDownloadImpl.mActivityWeakReference = new WeakReference<Activity>(activity);
        this.mPermissionListener = permissionInterceptor;
        this.mAgentWebUIController = new WeakReference<AbsAgentWebUIController>(AgentWebUtils.getAgentWebUIControllerByWebView(webView));
        DownloadImpl.getInstance((Context)this.mContext);
        try {
            this.isInstallDownloader = true;
        }
        catch (Throwable throwable) {
            LogUtils.e(TAG, "implementation 'com.download.library:Downloader:x.x.x'");
            if (LogUtils.isDebug()) {
                throwable.printStackTrace();
            }
            this.isInstallDownloader = false;
        }
    }

    public static DefaultDownloadImpl create(Activity activity, WebView webView, PermissionInterceptor permissionInterceptor) {
        return new DefaultDownloadImpl(activity, webView, permissionInterceptor);
    }

    public void onDownloadStart(final String string2, final String string3, final String string4, final String string5, final long l) {
        if (!this.isInstallDownloader) {
            LogUtils.e(TAG, "unable start download " + string2 + "; implementation 'com.download.library:Downloader:x.x.x'");
            return;
        }
        mHandler.post(new Runnable(){

            @Override
            public void run() {
                1 v0 = string22;
                String string22 = v0.string2;
                String string32 = v0.string3;
                String string42 = v0.string4;
                String string52 = v0.string5;
                long l2 = v0.l;
                string22.DefaultDownloadImpl.this.onDownloadStartInternal(string22, string32, string42, string52, l2);
            }
        });
    }

    protected void onDownloadStartInternal(String string2, String object, String string3, String string4, long l) {
        if (defaultDownloadImpl3.mActivityWeakReference.get() != null && !((Activity)defaultDownloadImpl3.mActivityWeakReference.get()).isFinishing()) {
            object = defaultDownloadImpl3.mPermissionListener;
            if (object != null && object.intercept(string2, new String[0], "download")) {
                return;
            }
            DefaultDownloadImpl defaultDownloadImpl = defaultDownloadImpl3;
            DefaultDownloadImpl defaultDownloadImpl2 = defaultDownloadImpl3;
            DefaultDownloadImpl defaultDownloadImpl3 = defaultDownloadImpl2.createResourceRequest(string2);
            defaultDownloadImpl2.mDownloadTasks.put(string2, (ResourceRequest)defaultDownloadImpl3);
            defaultDownloadImpl.preDownload(string2);
            return;
        }
    }

    protected ResourceRequest createResourceRequest(String string2) {
        return DownloadImpl.getInstance((Context)this.mContext).with(string2).setEnableIndicator(true).autoOpenIgnoreMD5();
    }

    protected void preDownload(String string2) {
        if (!this.isForceRequest(string2) && AgentWebUtils.checkNetworkType(this.mContext) > 1) {
            this.showDialog(string2);
            return;
        }
        this.performDownload(string2);
    }

    protected boolean isForceRequest(String string2) {
        DefaultDownloadImpl defaultDownloadImpl = defaultDownloadImpl.mDownloadTasks.get(string2);
        if (defaultDownloadImpl != null) {
            return defaultDownloadImpl.getDownloadTask().isForceDownload();
        }
        return false;
    }

    protected void forceDownload(String string2) {
        this.mDownloadTasks.get(string2).setForceDownload(true);
        this.performDownload(string2);
    }

    protected void showDialog(String string2) {
        Object object = (Activity)this.mActivityWeakReference.get();
        if (object != null && !object.isFinishing()) {
            object = (AbsAgentWebUIController)this.mAgentWebUIController.get();
            if (object != null) {
                ((AbsAgentWebUIController)object).onForceDownloadAlert(string2, this.createCallback(string2));
            }
            return;
        }
    }

    protected Handler.Callback createCallback(final String string2) {
        return new Handler.Callback(){

            public boolean handleMessage(Message message) {
                DefaultDownloadImpl.this.forceDownload(string2);
                return true;
            }
        };
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void performDownload(String string2) {
        ResourceRequest resourceRequest;
        DefaultDownloadImpl defaultDownloadImpl;
        try {
            LogUtils.e(TAG, "performDownload:" + string2 + " exist:" + DownloadImpl.getInstance((Context)((DefaultDownloadImpl)((Object)string3)).mContext).exist(string2));
            if (DownloadImpl.getInstance((Context)((DefaultDownloadImpl)((Object)string3)).mContext).exist(string2)) {
                if (((DefaultDownloadImpl)((Object)string3)).mAgentWebUIController.get() == null) return;
                ((AbsAgentWebUIController)((DefaultDownloadImpl)((Object)string3)).mAgentWebUIController.get()).onShowMessage(((Activity)((DefaultDownloadImpl)((Object)string3)).mActivityWeakReference.get()).getString(R.string.agentweb_download_task_has_been_exist), "preDownload");
                return;
            }
            DefaultDownloadImpl defaultDownloadImpl2 = string3;
            defaultDownloadImpl = defaultDownloadImpl2;
            ResourceRequest resourceRequest2 = defaultDownloadImpl2.mDownloadTasks.get(string2);
            resourceRequest = resourceRequest2;
            String string3 = "Cookie";
            resourceRequest2.addHeader(string3, AgentWebConfig.getCookiesByUrl(string2));
        }
        catch (Throwable throwable) {
            if (!LogUtils.isDebug()) return;
            throwable.printStackTrace();
            return;
        }
        {
            defaultDownloadImpl.taskEnqueue(resourceRequest);
            return;
        }
    }

    protected void taskEnqueue(ResourceRequest object) {
        DownloadListenerAdapter downloadListenerAdapter;
        ResourceRequest resourceRequest = object;
        object = downloadListenerAdapter;
        downloadListenerAdapter = new DownloadListenerAdapter(){

            public boolean onResult(Throwable throwable, Uri uri, String string2, Extra extra) {
                DefaultDownloadImpl.this.mDownloadTasks.remove(string2);
                return super.onResult(throwable, uri, string2, extra);
            }
        };
        resourceRequest.enqueue((DownloadListenerAdapter)object);
    }
}

