/*
 * Decompiled with CFR 0.152.
 */
package com.just.agentweb;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Pair;
import android.view.ActionMode;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityManager;
import android.webkit.JsPromptResult;
import android.webkit.WebBackForwardList;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Toast;
import com.just.agentweb.JsCallJava;
import com.just.agentweb.LogUtils;
import com.just.agentweb.LollipopFixedWebView;
import com.just.agentweb.MiddlewareWebChromeBase;
import com.just.agentweb.MiddlewareWebClientBase;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONObject;

public class AgentWebView
extends LollipopFixedWebView {
    private static final String TAG = "AgentWebView";
    private Map<String, JsCallJava> mJsCallJavas;
    private Map<String, String> mInjectJavaScripts;
    private FixedOnReceivedTitle mFixedOnReceivedTitle;
    private boolean mIsInited;
    private Boolean mIsAccessibilityEnabledOriginal;

    public AgentWebView(Context context) {
        this(context, null);
    }

    public AgentWebView(Context context, AttributeSet attributeSet) {
        FixedOnReceivedTitle fixedOnReceivedTitle;
        AgentWebView agentWebView = object;
        super(context, attributeSet);
        agentWebView.removeSearchBoxJavaBridge();
        agentWebView.mIsInited = true;
        Object object = fixedOnReceivedTitle;
        fixedOnReceivedTitle = new FixedOnReceivedTitle();
        agentWebView.mFixedOnReceivedTitle = object;
    }

    public static Pair<Boolean, String> isWebViewPackageException(Throwable throwable) {
        String string2 = throwable.getCause() == null ? throwable.toString() : throwable.getCause().toString();
        String string3 = Log.getStackTraceString((Throwable)throwable);
        if (!(string3.contains("android.content.pm.PackageManager$NameNotFoundException") || string3.contains("java.lang.RuntimeException: Cannot load WebView") || string3.contains("android.webkit.WebViewFactory$MissingWebViewPackageException: Failed to load WebView provider: No WebView installed"))) {
            return new Pair((Object)Boolean.FALSE, (Object)string2);
        }
        LogUtils.safeCheckCrash(TAG, "isWebViewPackageException", throwable);
        return new Pair((Object)Boolean.TRUE, (Object)("WebView load failed, " + string2));
    }

    private void injectJavaScript() {
        Iterator<Map.Entry<String, JsCallJava>> iterator = this.mJsCallJavas.entrySet().iterator();
        while (iterator.hasNext()) {
            AgentWebView agentWebView = this;
            Map.Entry<String, JsCallJava> entry = iterator.next();
            agentWebView.loadUrl(agentWebView.buildNotRepeatInjectJS(entry.getKey(), entry.getValue().getPreloadInterfaceJs()));
        }
    }

    private void injectExtraJavaScript() {
        Iterator<Map.Entry<String, String>> iterator = this.mInjectJavaScripts.entrySet().iterator();
        while (iterator.hasNext()) {
            AgentWebView agentWebView = this;
            Map.Entry<String, String> entry = iterator.next();
            agentWebView.loadUrl(agentWebView.buildNotRepeatInjectJS(entry.getKey(), entry.getValue()));
        }
    }

    private void fixedStillAttached() {
        if (this.getParent() instanceof ViewGroup) {
            ((ViewGroup)this.getParent()).removeAllViewsInLayout();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void releaseConfigCallback() {
        void var0_6;
        int n = Build.VERSION.SDK_INT;
        if (n < 16) {
            try {
                Field field = WebView.class.getDeclaredField("mWebViewCore").getType().getDeclaredField("mBrowserFrame").getType().getDeclaredField("sConfigCallback");
                ((AccessibleObject)field).setAccessible(true);
                field.set(null, null);
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                if (!LogUtils.isDebug()) return;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if (!LogUtils.isDebug()) return;
            }
        } else {
            if (n >= 19) return;
            try {
                Field field = Class.forName("android.webkit.BrowserFrame").getDeclaredField("sConfigCallback");
                if (field == null) return;
                Field field2 = field;
                ((AccessibleObject)field2).setAccessible(true);
                field2.set(null, null);
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                if (!LogUtils.isDebug()) return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!LogUtils.isDebug()) return;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if (!LogUtils.isDebug()) return;
            }
        }
        var0_6.printStackTrace();
    }

    private boolean isAccessibilityEnabled() {
        return ((AccessibilityManager)this.getContext().getSystemService("accessibility")).isEnabled();
    }

    private void setAccessibilityEnabled(boolean bl) {
        block6: {
            AgentWebView agentWebView = (AccessibilityManager)agentWebView.getContext().getSystemService("accessibility");
            Class<?> clazz = ((Object)((Object)agentWebView)).getClass();
            String string2 = "setAccessibilityState";
            Class[] classArray = new Class[1];
            classArray[0] = Boolean.TYPE;
            Method method = clazz.getDeclaredMethod(string2, classArray);
            AgentWebView agentWebView2 = agentWebView;
            ((AccessibleObject)method).setAccessible(true);
            Object[] objectArray = new Object[1];
            int n = 0;
            objectArray[n] = bl;
            method.invoke((Object)agentWebView2, objectArray);
            try {
                ((AccessibleObject)method).setAccessible(false);
            }
            catch (Throwable throwable) {
                if (!LogUtils.isDebug()) break block6;
                LogUtils.e(TAG, "setAccessibilityEnabled", throwable);
            }
        }
    }

    private void resetAccessibilityEnabled() {
        Boolean bl = this.mIsAccessibilityEnabledOriginal;
        if (bl != null) {
            this.setAccessibilityEnabled(bl);
        }
    }

    @Deprecated
    public final void addJavascriptInterface(Object object, String string2) {
        JsCallJava jsCallJava;
        Object object2;
        if (Build.VERSION.SDK_INT >= 17) {
            super.addJavascriptInterface(object, string2);
            Log.i((String)TAG, (String)"\u6ce8\u5165");
            return;
        }
        String string3 = TAG;
        Log.i((String)string3, (String)("use mJsCallJavas:" + string2));
        LogUtils.i(string3, "addJavascriptInterface:" + object + "   interfaceName:" + string2);
        if (this.mJsCallJavas == null) {
            HashMap<String, JsCallJava> hashMap;
            object2 = hashMap;
            hashMap = new HashMap<String, JsCallJava>();
            this.mJsCallJavas = object2;
        }
        AgentWebView agentWebView = this;
        object2 = jsCallJava;
        jsCallJava = new JsCallJava(object, string2);
        agentWebView.mJsCallJavas.put(string2, (JsCallJava)object2);
        agentWebView.injectJavaScript();
        if (LogUtils.isDebug()) {
            Log.d((String)string3, (String)("injectJavaScript, addJavascriptInterface.interfaceObj = " + object + ", interfaceName = " + string2));
        }
        this.addJavascriptInterfaceSupport(object, string2);
    }

    protected void addJavascriptInterfaceSupport(Object object, String string2) {
    }

    public final void setWebChromeClient(WebChromeClient webChromeClient) {
        AgentWebChrome agentWebChrome;
        AgentWebView agentWebView = this;
        AgentWebChrome agentWebChrome2 = agentWebChrome;
        agentWebChrome2(this);
        agentWebChrome2.setDelegate(webChromeClient);
        this.mFixedOnReceivedTitle.setWebChromeClient(webChromeClient);
        super.setWebChromeClient((WebChromeClient)agentWebChrome);
        agentWebView.setWebChromeClientSupport(agentWebChrome2);
    }

    protected final void setWebChromeClientSupport(WebChromeClient webChromeClient) {
    }

    public final void setWebViewClient(WebViewClient webViewClient) {
        AgentWebClient agentWebClient;
        AgentWebView agentWebView = this;
        AgentWebClient agentWebClient2 = agentWebClient;
        new AgentWebClient(this).setDelegate(webViewClient);
        super.setWebViewClient((WebViewClient)agentWebClient2);
        agentWebView.setWebViewClientSupport(agentWebClient2);
    }

    public final void setWebViewClientSupport(WebViewClient webViewClient) {
    }

    public ActionMode startActionMode(ActionMode.Callback callback) {
        return super.startActionMode(callback);
    }

    public void destroy() {
        AgentWebView agentWebView = this;
        agentWebView.setVisibility(8);
        Map<String, Object> map = agentWebView.mJsCallJavas;
        if (map != null) {
            map.clear();
        }
        if ((map = this.mInjectJavaScripts) != null) {
            map.clear();
        }
        AgentWebView agentWebView2 = this;
        agentWebView2.removeAllViewsInLayout();
        agentWebView2.fixedStillAttached();
        agentWebView2.releaseConfigCallback();
        if (agentWebView2.mIsInited) {
            AgentWebView agentWebView3 = this;
            agentWebView3.resetAccessibilityEnabled();
            LogUtils.i(TAG, "destroy web");
            super.destroy();
        }
    }

    public void clearHistory() {
        if (this.mIsInited) {
            super.clearHistory();
        }
    }

    public void setOverScrollMode(int n) {
        Throwable throwable;
        block2: {
            try {
                super.setOverScrollMode(n);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                Pair<Boolean, String> pair = AgentWebView.isWebViewPackageException(throwable2);
                if (!((Boolean)pair.first).booleanValue()) break block2;
                AgentWebView agentWebView = this;
                Toast.makeText((Context)agentWebView.getContext(), (CharSequence)((CharSequence)pair.second), (int)0).show();
                agentWebView.destroy();
            }
            return;
        }
        throw throwable;
    }

    public boolean isPrivateBrowsingEnabled() {
        if (Build.VERSION.SDK_INT == 15 && this.getSettings() == null) {
            return false;
        }
        return super.isPrivateBrowsingEnabled();
    }

    public void addInjectJavaScript(String string2) {
        if (this.mInjectJavaScripts == null) {
            HashMap<String, String> hashMap;
            HashMap<String, String> hashMap2 = hashMap;
            hashMap = new HashMap<String, String>();
            this.mInjectJavaScripts = hashMap2;
        }
        AgentWebView agentWebView = this;
        agentWebView.mInjectJavaScripts.put(String.valueOf(string2.hashCode()), string2);
        agentWebView.injectExtraJavaScript();
    }

    public String buildNotRepeatInjectJS(String charSequence, String string2) {
        StringBuilder stringBuilder;
        Object[] objectArray = new Object[1];
        Object object = objectArray;
        objectArray[0] = charSequence;
        object = String.format("__injectFlag_%1$s__", object);
        CharSequence charSequence2 = charSequence = stringBuilder;
        CharSequence charSequence3 = charSequence;
        CharSequence charSequence4 = charSequence;
        CharSequence charSequence5 = charSequence;
        ((StringBuilder)charSequence5)();
        ((StringBuilder)charSequence5).append("javascript:try{(function(){if(window.");
        ((StringBuilder)charSequence4).append((String)object);
        ((StringBuilder)charSequence4).append("){console.log('");
        ((StringBuilder)charSequence3).append((String)object);
        ((StringBuilder)charSequence3).append(" has been injected');return;}window.");
        ((StringBuilder)charSequence2).append((String)object);
        ((StringBuilder)charSequence2).append("=true;");
        stringBuilder.append(string2);
        stringBuilder.append("}())}catch(e){console.warn(e)}");
        return stringBuilder.toString();
    }

    public String buildTryCatchInjectJS(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("javascript:try{");
        stringBuilder.append(string2);
        stringBuilder.append("}catch(e){console.warn(e)}");
        return stringBuilder.toString();
    }

    protected void trySetWebDebuggEnabled() {
        block6: {
            if (LogUtils.isDebug() && Build.VERSION.SDK_INT >= 19) {
                Class<WebView> clazz = WebView.class;
                String string2 = "setWebContentsDebuggingEnabled";
                Class[] classArray = new Class[1];
                classArray[0] = Boolean.TYPE;
                Method method = clazz.getMethod(string2, classArray);
                Object[] objectArray = new Object[1];
                try {
                    objectArray[0] = Boolean.TRUE;
                    method.invoke(null, objectArray);
                }
                catch (Throwable throwable) {
                    if (!LogUtils.isDebug()) break block6;
                    throwable.printStackTrace();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean removeSearchBoxJavaBridge() {
        block5: {
            int n = Build.VERSION.SDK_INT;
            if (n < 11 || n >= 17) break block5;
            Method method = ((Object)((Object)this)).getClass().getMethod("removeJavascriptInterface", String.class);
            AgentWebView agentWebView = this;
            Object[] objectArray = new Object[1];
            try {
                objectArray[0] = "searchBoxJavaBridge_";
                method.invoke((Object)agentWebView, objectArray);
            }
            catch (Exception exception) {
                if (!LogUtils.isDebug()) break block5;
                exception.printStackTrace();
            }
            return true;
        }
        return false;
    }

    protected void fixedAccessibilityInjectorException() {
        if (Build.VERSION.SDK_INT == 17 && this.mIsAccessibilityEnabledOriginal == null && this.isAccessibilityEnabled()) {
            this.mIsAccessibilityEnabledOriginal = Boolean.TRUE;
            this.setAccessibilityEnabled(false);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void fixedAccessibilityInjectorExceptionForOnPageFinished(String string2) {
        Throwable throwable2222222;
        if (Build.VERSION.SDK_INT != 16) return;
        if (!this.getSettings().getJavaScriptEnabled()) return;
        if (this.mIsAccessibilityEnabledOriginal != null) return;
        if (!this.isAccessibilityEnabled()) return;
        URLEncoder.encode(String.valueOf(new URI(string2)), "utf-8");
        return;
        {
            catch (Throwable throwable2222222) {
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            {
                if (!"bad parameter".equals(illegalArgumentException.getMessage())) return;
                this.mIsAccessibilityEnabledOriginal = Boolean.TRUE;
                this.setAccessibilityEnabled(false);
                LogUtils.safeCheckCrash(TAG, "fixedAccessibilityInjectorExceptionForOnPageFinished.url = " + string2, illegalArgumentException);
                return;
            }
        }
        if (!LogUtils.isDebug()) return;
        LogUtils.e(TAG, "fixedAccessibilityInjectorExceptionForOnPageFinished", throwable2222222);
    }

    private static class FixedOnReceivedTitle {
        private WebChromeClient mWebChromeClient;
        private boolean mIsOnReceivedTitle;

        private FixedOnReceivedTitle() {
        }

        public void setWebChromeClient(WebChromeClient webChromeClient) {
            this.mWebChromeClient = webChromeClient;
        }

        public void onPageStarted() {
            this.mIsOnReceivedTitle = false;
        }

        public void onPageFinished(WebView webView) {
            if (!((FixedOnReceivedTitle)((Object)string2)).mIsOnReceivedTitle && ((FixedOnReceivedTitle)((Object)string2)).mWebChromeClient != null) {
                WebBackForwardList webBackForwardList;
                block5: {
                    webBackForwardList = null;
                    try {
                        webBackForwardList = webView.copyBackForwardList();
                    }
                    catch (NullPointerException nullPointerException) {
                        if (!LogUtils.isDebug()) break block5;
                        nullPointerException.printStackTrace();
                    }
                }
                if (webBackForwardList != null && webBackForwardList.getSize() > 0 && webBackForwardList.getCurrentIndex() >= 0) {
                    WebBackForwardList webBackForwardList2 = webBackForwardList;
                    if (webBackForwardList2.getItemAtIndex(webBackForwardList2.getCurrentIndex()) != null) {
                        FixedOnReceivedTitle fixedOnReceivedTitle = string2;
                        WebBackForwardList webBackForwardList3 = webBackForwardList;
                        String string2 = webBackForwardList3.getItemAtIndex(webBackForwardList3.getCurrentIndex()).getTitle();
                        fixedOnReceivedTitle.mWebChromeClient.onReceivedTitle(webView, string2);
                    }
                }
            }
        }

        public void onReceivedTitle() {
            this.mIsOnReceivedTitle = true;
        }
    }

    public static class AgentWebChrome
    extends MiddlewareWebChromeBase {
        private AgentWebView mAgentWebView;

        private AgentWebChrome(AgentWebView agentWebView) {
            this.mAgentWebView = agentWebView;
        }

        @Override
        public void onReceivedTitle(WebView webView, String string2) {
            this.mAgentWebView.mFixedOnReceivedTitle.onReceivedTitle();
            super.onReceivedTitle(webView, string2);
        }

        @Override
        public void onProgressChanged(WebView webView, int n) {
            if (this.mAgentWebView.mJsCallJavas != null) {
                this.mAgentWebView.injectJavaScript();
                if (LogUtils.isDebug()) {
                    Log.d((String)TAG, (String)("injectJavaScript, onProgressChanged.newProgress = " + n + ", url = " + webView.getUrl()));
                }
            }
            if (this.mAgentWebView.mInjectJavaScripts != null) {
                this.mAgentWebView.injectExtraJavaScript();
            }
            super.onProgressChanged(webView, n);
        }

        @Override
        public boolean onJsPrompt(WebView webView, String string2, String string3, String string4, JsPromptResult jsPromptResult) {
            Log.i((String)TAG, (String)("onJsPrompt:" + string2 + "  message:" + string3 + "  d:" + string4 + "  "));
            if (((AgentWebChrome)((Object)this)).mAgentWebView.mJsCallJavas != null && JsCallJava.isSafeWebViewCallMsg(string3)) {
                string2 = JsCallJava.getMsgJSONObject(string3);
                if ((string3 = JsCallJava.getInterfacedName((JSONObject)string2)) != null && (this = (JsCallJava)((AgentWebChrome)((Object)this)).mAgentWebView.mJsCallJavas.get(string3)) != null) {
                    jsPromptResult.confirm(((JsCallJava)this).call(webView, (JSONObject)string2));
                }
                return true;
            }
            return super.onJsPrompt(webView, string2, string3, string4, jsPromptResult);
        }
    }

    public static class AgentWebClient
    extends MiddlewareWebClientBase {
        private AgentWebView mAgentWebView;

        private AgentWebClient(AgentWebView agentWebView) {
            this.mAgentWebView = agentWebView;
        }

        @Override
        public void onPageStarted(WebView webView, String string2, Bitmap bitmap) {
            AgentWebClient agentWebClient = this;
            super.onPageStarted(webView, string2, bitmap);
            if (agentWebClient.mAgentWebView.mJsCallJavas != null) {
                this.mAgentWebView.injectJavaScript();
                if (LogUtils.isDebug()) {
                    Log.d((String)TAG, (String)("injectJavaScript, onPageStarted.url = " + webView.getUrl()));
                }
            }
            if (this.mAgentWebView.mInjectJavaScripts != null) {
                this.mAgentWebView.injectExtraJavaScript();
            }
            AgentWebClient agentWebClient2 = this;
            agentWebClient2.mAgentWebView.mFixedOnReceivedTitle.onPageStarted();
            agentWebClient2.mAgentWebView.fixedAccessibilityInjectorExceptionForOnPageFinished(string2);
        }

        @Override
        public void onPageFinished(WebView webView, String string2) {
            AgentWebClient agentWebClient = this;
            super.onPageFinished(webView, string2);
            agentWebClient.mAgentWebView.mFixedOnReceivedTitle.onPageFinished(webView);
            if (LogUtils.isDebug()) {
                Log.d((String)TAG, (String)("onPageFinished.url = " + webView.getUrl()));
            }
        }
    }
}

