/*
 * Decompiled with CFR 0.152.
 */
package com.just.agentweb;

import android.app.Activity;
import android.content.ContentUris;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.os.StatFs;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.widget.Toast;
import androidx.core.app.AppOpsManagerCompat;
import androidx.core.content.ContextCompat;
import androidx.core.content.FileProvider;
import androidx.core.os.EnvironmentCompat;
import androidx.loader.content.CursorLoader;
import com.google.android.material.snackbar.Snackbar;
import com.just.agentweb.AbsAgentWebUIController;
import com.just.agentweb.AgentWebConfig;
import com.just.agentweb.LogUtils;
import com.just.agentweb.LollipopFixedWebView;
import com.just.agentweb.PermissionInterceptor;
import com.just.agentweb.R;
import com.just.agentweb.WebParentLayout;
import java.io.Closeable;
import java.io.File;
import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AgentWebUtils {
    private static final String TAG = "AgentWebUtils";
    private static Handler mHandler;
    private static WeakReference<Snackbar> snackbarWeakReference;
    private static Toast mToast;

    private AgentWebUtils() {
        throw new UnsupportedOperationException("u can't init me");
    }

    public static int dp2px(Context context, float f) {
        return (int)(f * context.getResources().getDisplayMetrics().density + 0.5f);
    }

    static final void clearWebView(WebView webView) {
        if (webView == null) {
            return;
        }
        if (Looper.myLooper() != Looper.getMainLooper()) {
            return;
        }
        WebView webView2 = webView;
        webView2.loadUrl("about:blank");
        webView2.stopLoading();
        if (webView2.getHandler() != null) {
            webView.getHandler().removeCallbacksAndMessages(null);
        }
        WebView webView3 = webView;
        webView3.removeAllViews();
        ViewGroup viewGroup = (ViewGroup)webView3.getParent();
        if (viewGroup != null) {
            viewGroup.removeView((View)webView);
        }
        WebView webView4 = webView;
        webView4.setWebChromeClient(null);
        webView4.setWebViewClient(null);
        webView4.setTag(null);
        webView4.clearHistory();
        webView4.destroy();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getAgentWebFilePath(Context object) {
        File file;
        block3: {
            File file2;
            if (!TextUtils.isEmpty((CharSequence)AgentWebConfig.AGENTWEB_FILE_PATH)) {
                return AgentWebConfig.AGENTWEB_FILE_PATH;
            }
            String string2 = AgentWebUtils.getDiskExternalCacheDir(object);
            file = file2;
            try {
                if (new File(string2, "agentweb-cache").exists()) break block3;
                file.mkdirs();
            }
            catch (Throwable throwable) {
                LogUtils.i(TAG, "create dir exception");
            }
        }
        LogUtils.i(TAG, "path:" + file.getAbsolutePath() + "  path:" + file.getPath());
        AgentWebConfig.AGENTWEB_FILE_PATH = file.getAbsolutePath();
        return AgentWebConfig.AGENTWEB_FILE_PATH;
    }

    public static File createFileByName(Context object, String string2, boolean bl) {
        File file;
        if (TextUtils.isEmpty((CharSequence)(object = AgentWebUtils.getAgentWebFilePath(object)))) {
            return null;
        }
        File file2 = file;
        if (new File((String)object, string2).exists()) {
            if (bl) {
                File file3 = file2;
                file3.delete();
                file3.createNewFile();
            }
        } else {
            file2.createNewFile();
        }
        return file2;
    }

    public static int checkNetworkType(Context context) {
        int n = 0;
        NetworkInfo networkInfo = ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo();
        if (networkInfo == null) {
            return n;
        }
        int n2 = networkInfo.getType();
        if (n2 != 0) {
            if (n2 != 1 && n2 != 6 && n2 != 9) {
                return n;
            }
            return 1;
        }
        int n3 = networkInfo.getSubtype();
        switch (n3) {
            default: {
                switch (n3) {
                    default: {
                        return n;
                    }
                    case 13: 
                    case 14: 
                    case 15: {
                        return 2;
                    }
                    case 12: 
                }
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return 3;
            }
            case 1: 
            case 2: 
        }
        return 4;
    }

    public static long getAvailableStorage() {
        StatFs statFs;
        block6: {
            StatFs statFs2;
            statFs = statFs2;
            try {
                statFs2 = new StatFs(Environment.getExternalStorageDirectory().toString());
                if (Build.VERSION.SDK_INT < 18) break block6;
            }
            catch (RuntimeException runtimeException) {
                return 0L;
            }
            return statFs.getAvailableBlocksLong() * statFs.getBlockSizeLong();
        }
        long l = statFs.getAvailableBlocks();
        return l * (long)statFs.getBlockSize();
    }

    public static Uri getUriFromFile(Context context, File file) {
        return Build.VERSION.SDK_INT >= 24 ? AgentWebUtils.getUriFromFileForN(context, file) : Uri.fromFile((File)file);
    }

    static Uri getUriFromFileForN(Context context, File file) {
        return FileProvider.getUriForFile((Context)context, (String)(context.getPackageName() + ".AgentWebFileProvider"), (File)file);
    }

    static void setIntentDataAndType(Context context, Intent intent, String string2, File file, boolean bl) {
        if (Build.VERSION.SDK_INT >= 24) {
            Intent intent2 = intent;
            intent2.setDataAndType(AgentWebUtils.getUriFromFile(context, file), string2);
            intent2.addFlags(1);
            if (bl) {
                intent.addFlags(2);
            }
        } else {
            intent.setDataAndType(Uri.fromFile((File)file), string2);
        }
    }

    static void setIntentData(Context context, Intent intent, File file, boolean bl) {
        if (Build.VERSION.SDK_INT >= 24) {
            Intent intent2 = intent;
            intent2.setData(AgentWebUtils.getUriFromFile(context, file));
            intent2.addFlags(1);
            if (bl) {
                intent.addFlags(2);
            }
        } else {
            intent.setData(Uri.fromFile((File)file));
        }
    }

    static String getDiskExternalCacheDir(Context object) {
        if ("mounted".equals(EnvironmentCompat.getStorageState((File)(object = object.getExternalCacheDir())))) {
            return ((File)object).getAbsolutePath();
        }
        return null;
    }

    static void grantPermissions(Context context, Intent object, Uri uri, boolean bl) {
        int n;
        boolean bl2 = true;
        if (bl) {
            n = 3;
        }
        object.addFlags(n);
        object = context.getPackageManager().queryIntentActivities((Intent)object, 65536).iterator();
        while (object.hasNext()) {
            context.grantUriPermission(((ResolveInfo)object.next()).activityInfo.packageName, uri, n);
        }
    }

    private static String getMIMEType(File file) {
        String string2 = file.getName();
        int n = string2.lastIndexOf(".") + 1;
        String string3 = string2.substring(n, string2.length()).toLowerCase();
        return string3.equals("pdf") ? "application/pdf" : (!(string3.equals("m4a") || string3.equals("mp3") || string3.equals("mid") || string3.equals("xmf") || string3.equals("ogg") || string3.equals("wav")) ? (!string3.equals("3gp") && !string3.equals("mp4") ? (!(string3.equals("jpg") || string3.equals("gif") || string3.equals("png") || string3.equals("jpeg") || string3.equals("bmp")) ? (string3.equals("apk") ? "application/vnd.android.package-archive" : (!string3.equals("pptx") && !string3.equals("ppt") ? (!string3.equals("docx") && !string3.equals("doc") ? (!string3.equals("xlsx") && !string3.equals("xls") ? "*/*" : "application/vnd.ms-excel") : "application/vnd.ms-word") : "application/vnd.ms-powerpoint")) : "image/*") : "video/*") : "audio/*");
    }

    static void show(View view, CharSequence charSequence, int n, int n2, int n3, CharSequence charSequence2, int n4, View.OnClickListener onClickListener) {
        ForegroundColorSpan foregroundColorSpan;
        SpannableString spannableString;
        SpannableString spannableString2 = spannableString;
        spannableString = new SpannableString(charSequence);
        charSequence = foregroundColorSpan;
        foregroundColorSpan = new ForegroundColorSpan(n2);
        n2 = spannableString.length();
        spannableString.setSpan((Object)charSequence, 0, n2, 33);
        snackbarWeakReference = new WeakReference<Snackbar>(Snackbar.make((View)view, (CharSequence)spannableString2, (int)n));
        view = (Snackbar)snackbarWeakReference.get();
        view.getView().setBackgroundColor(n3);
        if (charSequence2 != null && charSequence2.length() > 0 && onClickListener != null) {
            View view2 = view;
            view2.setActionTextColor(n4);
            view2.setAction(charSequence2, onClickListener);
        }
        view.show();
    }

    static void dismiss() {
        WeakReference<Snackbar> weakReference = snackbarWeakReference;
        if (weakReference != null && weakReference.get() != null) {
            ((Snackbar)snackbarWeakReference.get()).dismiss();
            snackbarWeakReference = null;
        }
    }

    public static boolean checkWifi(Context context) {
        if ((context = (ConnectivityManager)context.getSystemService("connectivity")) == null) {
            return false;
        }
        return (context = context.getActiveNetworkInfo()) != null && context.isConnected() && context.getType() == 1;
    }

    public static boolean checkNetwork(Context context) {
        if ((context = (ConnectivityManager)context.getSystemService("connectivity")) == null) {
            return false;
        }
        return (context = context.getActiveNetworkInfo()) != null && context.isConnected();
    }

    static boolean isOverriedMethod(Object object, String string2, String string3, Class ... classArray) {
        boolean bl;
        block3: {
            LogUtils.i(TAG, "  methodName:" + string2 + "   method:" + string3);
            bl = false;
            if (object == null) {
                return bl;
            }
            try {
                bl = object.getClass().getMethod(string2, classArray).toGenericString().contains(string3) ^ true;
            }
            catch (Exception exception) {
                if (!LogUtils.isDebug()) break block3;
                exception.printStackTrace();
            }
        }
        LogUtils.i(TAG, "isOverriedMethod:" + bl);
        return bl;
    }

    static Method isExistMethod(Object object, String string2, Class ... classArray) {
        if (object == null) {
            return null;
        }
        try {
            Method method = object.getClass().getDeclaredMethod(string2, classArray);
            ((AccessibleObject)method).setAccessible(true);
            return method;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    static void clearAgentWebCache(Context context) {
        block2: {
            try {
                AgentWebUtils.clearCacheFolder(new File(AgentWebUtils.getAgentWebFilePath(context)), 0);
            }
            catch (Throwable throwable) {
                if (!LogUtils.isDebug()) break block2;
                throwable.printStackTrace();
            }
        }
    }

    static void clearWebViewAllCache(Context context, WebView webView) {
        block4: {
            WebView webView2 = webView;
            WebView webView3 = webView2;
            WebView webView4 = webView2;
            WebView webView5 = webView2;
            Context context2 = context;
            Context context3 = context2;
            AgentWebConfig.removeAllCookies(null);
            webView.getSettings().setCacheMode(2);
            context2.deleteDatabase("webviewCache.db");
            context3.deleteDatabase("webview.db");
            try {
                webView4.clearCache(true);
                webView5.clearHistory();
                webView3.clearFormData();
                AgentWebUtils.clearCacheFolder(new File(AgentWebConfig.getCachePath(context)), 0);
            }
            catch (Exception exception) {
                if (!AgentWebConfig.DEBUG) break block4;
                exception.printStackTrace();
            }
        }
    }

    static void clearWebViewAllCache(Context context) {
        try {
            AgentWebUtils.clearWebViewAllCache(context, new LollipopFixedWebView(context.getApplicationContext()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static int clearCacheFolder(File fileArray, int n) {
        int n2 = 0;
        if (fileArray != null) {
            Log.i((String)"Info", (String)("dir:" + fileArray.getAbsolutePath()));
        }
        if (fileArray != null && fileArray.isDirectory()) {
            fileArray = fileArray.listFiles();
            int n3 = fileArray.length;
            for (int i = 0; i < n3; ++i) {
                File file;
                block12: {
                    file = fileArray[i];
                    if (!file.isDirectory()) break block12;
                    n2 += AgentWebUtils.clearCacheFolder(file, n);
                }
                if (file.lastModified() >= new Date().getTime() - (long)n * 86400000L) continue;
                File file2 = file;
                Log.i((String)TAG, (String)("file name:" + file.getName()));
                try {
                    if (!file2.delete()) continue;
                    ++n2;
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[1];
                    Object[] objectArray2 = objectArray;
                    objectArray[0] = exception.getMessage();
                    Log.e((String)"Info", (String)String.format("Failed to clean the cache, result %s", objectArray2));
                    break;
                }
                continue;
            }
        }
        return n2;
    }

    static void clearCache(Context objectArray, int n) {
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = new Object[1];
        objectArray = objectArray3;
        objectArray3[0] = n;
        Log.i((String)"Info", (String)String.format("Starting cache prune, deleting files older than %d days", objectArray));
        int n2 = AgentWebUtils.clearCacheFolder(objectArray2.getCacheDir(), n);
        Object[] objectArray4 = new Object[1];
        Object[] objectArray5 = objectArray4;
        objectArray4[0] = n2;
        Log.i((String)"Info", (String)String.format("Cache pruning completed, %d files deleted", objectArray5));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] uriToPath(Activity activity, Uri[] uriArray) {
        if (activity == null) return null;
        if (uriArray == null) return null;
        if (uriArray.length == 0) {
            return null;
        }
        try {
            String[] stringArray = new String[uriArray.length];
            int n = 0;
            int n2 = uriArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Uri uri = uriArray[n3];
                int n4 = n + 1;
                String string2 = Build.VERSION.SDK_INT > 18 ? AgentWebUtils.getFileAbsolutePath(activity, uri) : AgentWebUtils.getRealPathBelowVersion((Context)activity, uri);
                stringArray[n] = string2;
                ++n3;
                n = n4;
            }
            return stringArray;
        }
        catch (Throwable throwable) {
            if (!LogUtils.isDebug()) return null;
            throwable.printStackTrace();
            return null;
        }
    }

    private static String getRealPathBelowVersion(Context context, Uri uri) {
        String string2 = null;
        LogUtils.i(TAG, "method -> getRealPathBelowVersion " + uri + "   path:" + uri.getPath() + "    getAuthority:" + uri.getAuthority());
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "_data";
        context = new CursorLoader(context, uri, stringArray2, null, null, null).loadInBackground();
        if (context != null) {
            Context context2 = context;
            context.moveToFirst();
            string2 = context2.getString(context2.getColumnIndex(stringArray2[0]));
            context2.close();
        }
        if (string2 == null) {
            string2 = uri.getPath();
        }
        return string2;
    }

    public static File createImageFile(Context object) {
        Context context = object;
        object = null;
        String string2 = new SimpleDateFormat("yyyyMMddHHmmss", Locale.getDefault()).format(new Date());
        try {
            object = AgentWebUtils.createFileByName(context, String.format("aw_%s.jpg", string2), true);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return object;
    }

    static File createVideoFile(Context object) {
        Context context = object;
        object = null;
        String string2 = new SimpleDateFormat("yyyyMMddHHmmss", Locale.getDefault()).format(new Date());
        try {
            object = AgentWebUtils.createFileByName(context, String.format("aw_%s.mp4", string2), true);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return object;
    }

    public static void closeIO(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    static String getFileAbsolutePath(Activity stringArray, Uri stringArray2) {
        if (stringArray != null && stringArray2 != null) {
            if (Build.VERSION.SDK_INT >= 19 && DocumentsContract.isDocumentUri((Context)stringArray, (Uri)stringArray2)) {
                if (AgentWebUtils.isExternalStorageDocument((Uri)stringArray2)) {
                    stringArray = DocumentsContract.getDocumentId((Uri)stringArray2).split(":");
                    if ("primary".equalsIgnoreCase(stringArray[0])) {
                        return Environment.getExternalStorageDirectory() + "/" + stringArray[1];
                    }
                } else {
                    if (AgentWebUtils.isDownloadsDocument((Uri)stringArray2)) {
                        return AgentWebUtils.getDataColumn((Context)stringArray, ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(DocumentsContract.getDocumentId((Uri)stringArray2))), null, null);
                    }
                    if (AgentWebUtils.isMediaDocument((Uri)stringArray2)) {
                        stringArray2 = DocumentsContract.getDocumentId((Uri)stringArray2).split(":");
                        String string2 = stringArray2[0];
                        Uri uri = null;
                        if ("image".equals(string2)) {
                            uri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                        } else if ("video".equals(string2)) {
                            uri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                        } else if ("audio".equals(string2)) {
                            uri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                        }
                        String[] stringArray3 = stringArray;
                        String[] stringArray4 = new String[1];
                        stringArray = stringArray4;
                        stringArray4[0] = stringArray2[1];
                        return AgentWebUtils.getDataColumn((Context)stringArray3, uri, "_id=?", stringArray);
                    }
                }
            } else {
                if (stringArray2.getAuthority().equalsIgnoreCase(stringArray.getPackageName() + ".AgentWebFileProvider")) {
                    stringArray2 = stringArray2.getPath();
                    int n = stringArray2.lastIndexOf("/");
                    int n2 = n + 1;
                    return AgentWebUtils.getAgentWebFilePath((Context)stringArray) + File.separator + stringArray2.substring(n2, stringArray2.length());
                }
                if ("content".equalsIgnoreCase(stringArray2.getScheme())) {
                    if (AgentWebUtils.isGooglePhotosUri((Uri)stringArray2)) {
                        return stringArray2.getLastPathSegment();
                    }
                    return AgentWebUtils.getDataColumn((Context)stringArray, (Uri)stringArray2, null, null);
                }
                if ("file".equalsIgnoreCase(stringArray2.getScheme())) {
                    return stringArray2.getPath();
                }
            }
            return null;
        }
        return null;
    }

    static String getDataColumn(Context context, Uri uri, String string2, String[] stringArray) {
        block6: {
            Context context2 = context;
            context = null;
            String[] stringArray2 = new String[1];
            String[] stringArray3 = stringArray2;
            stringArray2[0] = "_data";
            try {
                context = context2.getContentResolver().query(uri, stringArray3, string2, stringArray, null);
                if (context == null) break block6;
            }
            catch (Throwable throwable) {
                if (context != null) {
                    context.close();
                }
                throw throwable;
            }
            if (!context.moveToFirst()) break block6;
            Context context3 = context;
            String string3 = context3.getString(context3.getColumnIndexOrThrow("_data"));
            context.close();
            return string3;
        }
        if (context != null) {
            context.close();
        }
        return null;
    }

    static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    static boolean isGooglePhotosUri(Uri uri) {
        return "com.google.android.apps.photos.content".equals(uri.getAuthority());
    }

    static Intent getInstallApkIntentCompat(Context context, File file) {
        Intent intent = new Intent().setAction("android.intent.action.VIEW");
        AgentWebUtils.setIntentDataAndType(context, intent, "application/vnd.android.package-archive", file, false);
        return intent;
    }

    public static Intent getCommonFileIntentCompat(Context context, File file) {
        Intent intent = new Intent().setAction("android.intent.action.VIEW");
        AgentWebUtils.setIntentDataAndType(context, intent, AgentWebUtils.getMIMEType(file), file, false);
        return intent;
    }

    static Intent getIntentCaptureCompat(Context context, File file) {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        context = AgentWebUtils.getUriFromFile(context, file);
        intent.addCategory("android.intent.category.DEFAULT");
        intent.putExtra("output", (Parcelable)context);
        return intent;
    }

    static Intent getIntentVideoCompat(Context context, File file) {
        Intent intent = new Intent("android.media.action.VIDEO_CAPTURE");
        context = AgentWebUtils.getUriFromFile(context, file);
        intent.addCategory("android.intent.category.DEFAULT");
        intent.putExtra("output", (Parcelable)context);
        return intent;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean isJson(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        try {
            if (string2.startsWith("[")) {
                new JSONArray(string2);
                return true;
            } else {
                new JSONObject(string2);
            }
            return true;
        }
        catch (JSONException jSONException) {
            return false;
        }
    }

    public static boolean isUIThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    static boolean isEmptyCollection(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    static boolean isEmptyMap(Map map) {
        return map == null || map.isEmpty();
    }

    static void toastShowShort(Context context, String string2) {
        Toast toast = mToast;
        if (toast == null) {
            mToast = Toast.makeText((Context)context.getApplicationContext(), (CharSequence)string2, (int)0);
        } else {
            toast.setText((CharSequence)string2);
        }
        mToast.show();
    }

    @Deprecated
    static void getUIControllerAndShowMessage(Activity object, String string2, String string3) {
        if (object != null && !object.isFinishing()) {
            if ((object = ((WebParentLayout)object.findViewById(R.id.web_parent_layout_id)).provide()) != null) {
                ((AbsAgentWebUIController)object).onShowMessage(string2, string3);
            }
            return;
        }
    }

    public static boolean hasPermission(Context context, String ... stringArray) {
        return AgentWebUtils.hasPermission(context, Arrays.asList(stringArray));
    }

    public static boolean hasPermission(Context context, List<String> object) {
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        }
        object = object.iterator();
        while (object.hasNext()) {
            String string2 = (String)object.next();
            if (ContextCompat.checkSelfPermission((Context)context, (String)string2) == -1) {
                return false;
            }
            if (TextUtils.isEmpty((CharSequence)(string2 = AppOpsManagerCompat.permissionToOp((String)string2))) || AppOpsManagerCompat.noteProxyOp((Context)context, (String)string2, (String)context.getPackageName()) == 0) continue;
            return false;
        }
        return true;
    }

    public static List<String> getDeniedPermissions(Activity activity, String[] stringArray) {
        if (stringArray != null && stringArray.length != 0) {
            ArrayList<String> arrayList;
            ArrayList<String> arrayList2 = arrayList;
            arrayList = new ArrayList<String>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                if (AgentWebUtils.hasPermission((Context)activity, stringArray[i])) continue;
                arrayList2.add(stringArray[i]);
            }
            return arrayList2;
        }
        return Collections.EMPTY_LIST;
    }

    public static AbsAgentWebUIController getAgentWebUIControllerByWebView(WebView webView) {
        return AgentWebUtils.getWebParentLayoutByWebView(webView).provide();
    }

    public static String getApplicationName(Context context) {
        PackageManager packageManager = null;
        packageManager = context.getApplicationContext().getPackageManager();
        try {
            context = packageManager.getApplicationInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            context = null;
        }
        return (String)packageManager.getApplicationLabel((ApplicationInfo)context);
    }

    static WebParentLayout getWebParentLayoutByWebView(WebView webView) {
        if (webView.getParent() instanceof ViewGroup) {
            webView = (ViewGroup)webView.getParent();
            while (webView != null) {
                String string2 = TAG;
                LogUtils.i(string2, "ViewGroup:" + webView);
                if (webView.getId() == R.id.web_parent_layout_id) {
                    WebParentLayout webParentLayout = (WebParentLayout)webView;
                    LogUtils.i(string2, "found WebParentLayout");
                    return webParentLayout;
                }
                if ((webView = webView.getParent()) instanceof ViewGroup) {
                    webView = (ViewGroup)webView;
                    continue;
                }
                webView = null;
            }
            throw new IllegalStateException("please check webcreator's create method was be called ?");
        }
        throw new IllegalStateException("please check webcreator's create method was be called ?");
    }

    public static void runInUiThread(Runnable runnable) {
        if (mHandler == null) {
            mHandler = new Handler(Looper.getMainLooper());
        }
        mHandler.post(runnable);
    }

    public static boolean showFileChooserCompat(Activity object, WebView object2, ValueCallback<Uri[]> valueCallback, WebChromeClient.FileChooserParams objectArray, PermissionInterceptor permissionInterceptor, ValueCallback valueCallback2, String classArray, Handler.Callback callback) {
        block42: {
            block41: {
                Class[] classArray2;
                Object[] objectArray2;
                ValueCallback<Uri[]> valueCallback3 = valueCallback;
                Class<?> clazz = Class.forName("com.just.agentweb.filechooser.FileChooser");
                String string2 = "newBuilder";
                Class[] classArray3 = new Class[2];
                classArray3[0] = Activity.class;
                classArray3[1] = WebView.class;
                Method method = clazz.getDeclaredMethod(string2, classArray3);
                object = method.invoke(null, object, object2);
                object2 = object.getClass();
                if (valueCallback3 != null) {
                    Object object3 = object2;
                    objectArray2 = "setUriValueCallbacks";
                    Class[] classArray4 = new Class[1];
                    classArray2 = classArray4;
                    classArray4[0] = ValueCallback.class;
                    Method method2 = ((Class)object3).getDeclaredMethod((String)objectArray2, classArray2);
                    Method method3 = method2;
                    ((AccessibleObject)method2).setAccessible(true);
                    Object[] objectArray3 = new Object[1];
                    objectArray2 = objectArray3;
                    objectArray3[0] = valueCallback;
                    method3.invoke(object, objectArray2);
                }
                if (objectArray != null) {
                    Object object4 = object2;
                    objectArray2 = "setFileChooserParams";
                    Class[] classArray5 = new Class[1];
                    classArray2 = classArray5;
                    classArray5[0] = WebChromeClient.FileChooserParams.class;
                    Method method4 = ((Class)object4).getDeclaredMethod((String)objectArray2, classArray2);
                    Method method5 = method4;
                    ((AccessibleObject)method4).setAccessible(true);
                    Object[] objectArray4 = new Object[1];
                    objectArray2 = objectArray4;
                    objectArray4[0] = objectArray;
                    method5.invoke(object, objectArray2);
                }
                if (valueCallback2 != null) {
                    Object object5 = object2;
                    objectArray = "setUriValueCallback";
                    Class[] classArray6 = new Class[1];
                    objectArray2 = classArray6;
                    classArray6[0] = ValueCallback.class;
                    Method method6 = ((Class)object5).getDeclaredMethod((String)objectArray, (Class<?>[])objectArray2);
                    Method method7 = method6;
                    ((AccessibleObject)method6).setAccessible(true);
                    Object[] objectArray5 = new Object[1];
                    objectArray = objectArray5;
                    objectArray5[0] = valueCallback2;
                    method7.invoke(object, objectArray);
                }
                if (TextUtils.isEmpty((CharSequence)classArray)) break block41;
                Object object6 = object2;
                objectArray = "setAcceptType";
                Class[] classArray7 = new Class[1];
                objectArray2 = classArray7;
                classArray7[0] = String.class;
                Method method8 = ((Class)object6).getDeclaredMethod((String)objectArray, (Class<?>[])objectArray2);
                Method method9 = method8;
                ((AccessibleObject)method8).setAccessible(true);
                Object[] objectArray6 = new Object[1];
                objectArray = objectArray6;
                objectArray6[0] = classArray;
                method9.invoke(object, objectArray);
            }
            if (callback != null) {
                Object object7 = object2;
                objectArray = "setJsChannelCallback";
                Class[] classArray8 = new Class[1];
                classArray = classArray8;
                classArray8[0] = Handler.Callback.class;
                Method method = ((Class)object7).getDeclaredMethod((String)objectArray, classArray);
                Method method10 = method;
                ((AccessibleObject)method).setAccessible(true);
                Object[] objectArray7 = new Object[1];
                objectArray = objectArray7;
                objectArray7[0] = callback;
                method10.invoke(object, objectArray);
            }
            Object object8 = object2;
            Object object9 = object8;
            Object object10 = object8;
            String string3 = "setPermissionInterceptor";
            Class[] classArray9 = new Class[1];
            classArray9[0] = PermissionInterceptor.class;
            Method method = ((Class)object9).getDeclaredMethod(string3, classArray9);
            ((AccessibleObject)method).setAccessible(true);
            method.invoke(object, permissionInterceptor);
            Method method11 = ((Class)object10).getDeclaredMethod("build", new Class[0]);
            ((AccessibleObject)method11).setAccessible(true);
            object = method11.invoke(object, new Object[0]);
            Method method12 = object.getClass().getDeclaredMethod("openFileChooser", new Class[0]);
            try {
                ((AccessibleObject)method12).setAccessible(true);
                method12.invoke(object, new Object[0]);
            }
            catch (Throwable throwable) {
                if (LogUtils.isDebug()) {
                    throwable.printStackTrace();
                }
                if (throwable instanceof ClassNotFoundException) {
                    LogUtils.e(TAG, "Please check whether compile'com.just.agentweb:filechooser:x.x.x' dependency was added.");
                }
                if (valueCallback != null) {
                    LogUtils.i(TAG, "onReceiveValue empty");
                    return false;
                }
                if (valueCallback2 == null) break block42;
                valueCallback2.onReceiveValue(null);
            }
        }
        return true;
    }

    public static String md5(String string2) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            if (LogUtils.isDebug()) {
                exception.printStackTrace();
            }
            return "";
        }
        messageDigest.update(string2.getBytes());
        int n = 1;
        return new BigInteger(n, messageDigest.digest()).toString(16);
    }
}

