/*
 * Decompiled with CFR 0.152.
 */
package com.just.agentweb;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Build;
import android.text.TextUtils;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import com.just.agentweb.AgentWebUtils;
import com.just.agentweb.LogUtils;
import java.io.File;

public class AgentWebConfig {
    static final String FILE_CACHE_PATH = "agentweb-cache";
    static final String AGENTWEB_CACHE_PATCH = File.separator + "agentweb-cache";
    static String AGENTWEB_FILE_PATH;
    public static boolean DEBUG;
    static final boolean IS_KITKAT_OR_BELOW_KITKAT;
    public static final int WEBVIEW_DEFAULT_TYPE = 1;
    public static final int WEBVIEW_AGENTWEB_SAFE_TYPE = 2;
    public static final int WEBVIEW_CUSTOM_TYPE = 3;
    private static volatile boolean IS_INITIALIZED;
    private static final String TAG;
    public static final String AGENTWEB_NAME = "AgentWeb";
    public static final String AGENTWEB_VERSION = "AgentWeb/5.0.8";
    public static int MAX_FILE_LENGTH;

    public static String getCookiesByUrl(String string2) {
        return CookieManager.getInstance() == null ? null : CookieManager.getInstance().getCookie(string2);
    }

    public static void debug() {
        DEBUG = true;
        if (Build.VERSION.SDK_INT >= 19) {
            WebView.setWebContentsDebuggingEnabled((boolean)true);
        }
    }

    public static void removeExpiredCookies() {
        CookieManager cookieManager = CookieManager.getInstance();
        if (cookieManager != null) {
            cookieManager.removeExpiredCookie();
            AgentWebConfig.toSyncCookies();
        }
    }

    public static void removeAllCookies() {
        AgentWebConfig.removeAllCookies(null);
    }

    public static void removeSessionCookies() {
        AgentWebConfig.removeSessionCookies(null);
    }

    public static void syncCookie(String string2, String string3) {
        CookieManager cookieManager = CookieManager.getInstance();
        if (cookieManager != null) {
            cookieManager.setCookie(string2, string3);
            AgentWebConfig.toSyncCookies();
        }
    }

    public static void removeSessionCookies(ValueCallback<Boolean> object) {
        if (object == null) {
            object = AgentWebConfig.getDefaultIgnoreCallback();
        }
        if (CookieManager.getInstance() == null) {
            Boolean bl;
            ValueCallback<Boolean> valueCallback = object;
            object = bl;
            bl = new Boolean(false);
            valueCallback.onReceiveValue(object);
            return;
        }
        if (Build.VERSION.SDK_INT < 21) {
            CookieManager.getInstance().removeSessionCookie();
            AgentWebConfig.toSyncCookies();
            object.onReceiveValue((Object)new Boolean(true));
            return;
        }
        CookieManager.getInstance().removeSessionCookies(object);
        AgentWebConfig.toSyncCookies();
    }

    public static String getCachePath(Context context) {
        return context.getCacheDir().getAbsolutePath() + AGENTWEB_CACHE_PATCH;
    }

    public static String getExternalCachePath(Context context) {
        return AgentWebUtils.getAgentWebFilePath(context);
    }

    public static void removeAllCookies(ValueCallback<Boolean> valueCallback) {
        if (valueCallback == null) {
            valueCallback = AgentWebConfig.getDefaultIgnoreCallback();
        }
        if (Build.VERSION.SDK_INT < 21) {
            CookieManager.getInstance().removeAllCookie();
            AgentWebConfig.toSyncCookies();
            valueCallback.onReceiveValue((Object)(CookieManager.getInstance().hasCookies() ^ true));
            return;
        }
        CookieManager.getInstance().removeAllCookies(valueCallback);
        AgentWebConfig.toSyncCookies();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized void clearDiskCache(Context object) {
        Object object2 = object;
        AgentWebUtils.clearCacheFolder(new File(AgentWebConfig.getCachePath(object)), 0);
        String string2 = AgentWebConfig.getExternalCachePath(object2);
        if (TextUtils.isEmpty((CharSequence)string2)) return;
        try {
            AgentWebUtils.clearCacheFolder(new File(string2), 0);
        }
        catch (Throwable throwable) {
            if (!LogUtils.isDebug()) return;
            throwable.printStackTrace();
        }
        return;
    }

    static synchronized void initCookiesManager(Context context) {
        if (!IS_INITIALIZED) {
            AgentWebConfig.createCookiesSyncInstance(context);
            IS_INITIALIZED = true;
        }
    }

    private static void createCookiesSyncInstance(Context context) {
        if (Build.VERSION.SDK_INT < 21) {
            CookieSyncManager.createInstance((Context)context);
        }
    }

    private static void toSyncCookies() {
        if (Build.VERSION.SDK_INT < 21) {
            CookieSyncManager.getInstance().sync();
            return;
        }
        AsyncTask.THREAD_POOL_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                CookieManager.getInstance().flush();
            }
        });
    }

    static String getDatabasesCachePath(Context context) {
        return context.getApplicationContext().getDir("database", 0).getPath();
    }

    private static ValueCallback<Boolean> getDefaultIgnoreCallback() {
        return new ValueCallback<Boolean>(){

            public void onReceiveValue(Boolean bl) {
                LogUtils.i(TAG, "removeExpiredCookies:" + bl);
            }
        };
    }

    static {
        DEBUG = false;
        IS_KITKAT_OR_BELOW_KITKAT = Build.VERSION.SDK_INT <= 19;
        IS_INITIALIZED = false;
        TAG = AgentWebConfig.class.getSimpleName();
        MAX_FILE_LENGTH = 0x500000;
    }
}

