/*
 * Decompiled with CFR 0.152.
 */
package com.just.agentweb;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import androidx.collection.ArrayMap;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.just.agentweb.AbsAgentWebSettings;
import com.just.agentweb.AbsAgentWebUIController;
import com.just.agentweb.AgentWebConfig;
import com.just.agentweb.AgentWebJsInterfaceCompat;
import com.just.agentweb.AgentWebUIControllerImplBase;
import com.just.agentweb.AgentWebUtils;
import com.just.agentweb.BaseIndicatorSpec;
import com.just.agentweb.BaseIndicatorView;
import com.just.agentweb.DefaultChromeClient;
import com.just.agentweb.DefaultWebClient;
import com.just.agentweb.DefaultWebCreator;
import com.just.agentweb.DefaultWebLifeCycleImpl;
import com.just.agentweb.EventHandlerImpl;
import com.just.agentweb.EventInterceptor;
import com.just.agentweb.HookManager;
import com.just.agentweb.HttpHeaders;
import com.just.agentweb.IAgentWebSettings;
import com.just.agentweb.IEventHandler;
import com.just.agentweb.IUrlLoader;
import com.just.agentweb.IVideo;
import com.just.agentweb.IWebLayout;
import com.just.agentweb.IndicatorController;
import com.just.agentweb.IndicatorHandler;
import com.just.agentweb.JsAccessEntrace;
import com.just.agentweb.JsAccessEntraceImpl;
import com.just.agentweb.JsInterfaceHolder;
import com.just.agentweb.JsInterfaceHolderImpl;
import com.just.agentweb.LogUtils;
import com.just.agentweb.MiddlewareWebChromeBase;
import com.just.agentweb.MiddlewareWebClientBase;
import com.just.agentweb.PermissionInterceptor;
import com.just.agentweb.UrlLoaderImpl;
import com.just.agentweb.VideoImpl;
import com.just.agentweb.WebChromeClient;
import com.just.agentweb.WebCreator;
import com.just.agentweb.WebLifeCycle;
import com.just.agentweb.WebListenerManager;
import com.just.agentweb.WebParentLayout;
import com.just.agentweb.WebSecurityCheckLogic;
import com.just.agentweb.WebSecurityController;
import com.just.agentweb.WebSecurityControllerImpl;
import com.just.agentweb.WebSecurityLogicImpl;
import com.just.agentweb.WebViewClient;
import java.lang.ref.WeakReference;
import java.util.Map;

public final class AgentWeb {
    private static final String TAG = "AgentWeb";
    private static final int ACTIVITY_TAG = 0;
    private static final int FRAGMENT_TAG = 1;
    private Activity mActivity;
    private ViewGroup mViewGroup;
    private WebCreator mWebCreator;
    private IAgentWebSettings mAgentWebSettings;
    private AgentWeb mAgentWeb = null;
    private IndicatorController mIndicatorController;
    private WebChromeClient mWebChromeClient;
    private WebViewClient mWebViewClient;
    private boolean mEnableIndicator;
    private IEventHandler mIEventHandler;
    private ArrayMap<String, Object> mJavaObjects;
    private int mTagTarget;
    private WebListenerManager mWebListenerManager;
    private WebSecurityController<WebSecurityCheckLogic> mWebSecurityController;
    private WebSecurityCheckLogic mWebSecurityCheckLogic;
    private android.webkit.WebChromeClient mTargetChromeClient;
    private SecurityType mSecurityType;
    private AgentWebJsInterfaceCompat mAgentWebJsInterfaceCompat;
    private JsAccessEntrace mJsAccessEntrace;
    private IUrlLoader mIUrlLoader;
    private WebLifeCycle mWebLifeCycle;
    private IVideo mIVideo;
    private boolean mWebClientHelper;
    private PermissionInterceptor mPermissionInterceptor;
    private boolean mIsInterceptUnkownUrl;
    private int mUrlHandleWays;
    private MiddlewareWebClientBase mMiddleWrareWebClientBaseHeader;
    private MiddlewareWebChromeBase mMiddlewareWebChromeBaseHeader;
    private EventInterceptor mEventInterceptor;
    private JsInterfaceHolder mJsInterfaceHolder;

    private AgentWeb(AgentBuilder agentBuilder) {
        WebSecurityControllerImpl webSecurityControllerImpl;
        DefaultWebLifeCycleImpl defaultWebLifeCycleImpl;
        UrlLoaderImpl urlLoaderImpl;
        Object object;
        ArrayMap arrayMap;
        Object object2 = arrayMap;
        arrayMap = new ArrayMap();
        this.mJavaObjects = object2;
        this.mTagTarget = 0;
        this.mWebSecurityController = null;
        this.mWebSecurityCheckLogic = null;
        this.mSecurityType = SecurityType.DEFAULT_CHECK;
        this.mAgentWebJsInterfaceCompat = null;
        this.mJsAccessEntrace = null;
        this.mIUrlLoader = null;
        this.mIVideo = null;
        this.mWebClientHelper = true;
        this.mIsInterceptUnkownUrl = true;
        this.mUrlHandleWays = -1;
        this.mJsInterfaceHolder = null;
        this.mTagTarget = agentBuilder.mTag;
        this.mActivity = agentBuilder.mActivity;
        this.mViewGroup = agentBuilder.mViewGroup;
        this.mIEventHandler = agentBuilder.mIEventHandler;
        this.mEnableIndicator = agentBuilder.mEnableIndicator;
        if (agentBuilder.mWebCreator == null) {
            int n = agentBuilder.mIndex;
            object = agentBuilder.mLayoutParams;
            int n2 = agentBuilder.mIndicatorColor;
            int n3 = agentBuilder.mHeight;
            WebView webView = agentBuilder.mWebView;
            IWebLayout iWebLayout = agentBuilder.mWebLayout;
            object2 = this.configWebCreator(agentBuilder.mBaseIndicatorView, n, (ViewGroup.LayoutParams)object, n2, n3, webView, iWebLayout);
        } else {
            object2 = agentBuilder.mWebCreator;
        }
        this.mWebCreator = object2;
        this.mIndicatorController = agentBuilder.mIndicatorController;
        this.mWebChromeClient = agentBuilder.mWebChromeClient;
        this.mWebViewClient = agentBuilder.mWebViewClient;
        this.mAgentWeb = this;
        this.mAgentWebSettings = agentBuilder.mAgentWebSettings;
        if (agentBuilder.mJavaObject != null && !agentBuilder.mJavaObject.isEmpty()) {
            this.mJavaObjects.putAll((Map)agentBuilder.mJavaObject);
            LogUtils.i(TAG, "mJavaObject size:" + this.mJavaObjects.size());
        }
        if (agentBuilder.mPermissionInterceptor == null) {
            object2 = null;
        } else {
            PermissionInterceptorWrapper permissionInterceptorWrapper;
            object2 = permissionInterceptorWrapper;
            permissionInterceptorWrapper = new PermissionInterceptorWrapper(agentBuilder.mPermissionInterceptor);
        }
        this.mPermissionInterceptor = object2;
        this.mSecurityType = agentBuilder.mSecurityType;
        object2 = urlLoaderImpl;
        urlLoaderImpl = new UrlLoaderImpl(this.mWebCreator.create().getWebView(), agentBuilder.mHttpHeaders);
        this.mIUrlLoader = object2;
        if (this.mWebCreator.getWebParentLayout() instanceof WebParentLayout) {
            object2 = (WebParentLayout)this.mWebCreator.getWebParentLayout();
            object = agentBuilder.mAgentWebUIController == null ? AgentWebUIControllerImplBase.build() : agentBuilder.mAgentWebUIController;
            ArrayMap arrayMap2 = object2;
            arrayMap2.bindController((AbsAgentWebUIController)object);
            arrayMap2.setErrorLayoutRes(agentBuilder.mErrorLayout, agentBuilder.mReloadId);
            arrayMap2.setErrorView(agentBuilder.mErrorView);
        }
        object2 = defaultWebLifeCycleImpl;
        defaultWebLifeCycleImpl = new DefaultWebLifeCycleImpl(this.mWebCreator.getWebView());
        this.mWebLifeCycle = object2;
        object2 = webSecurityControllerImpl;
        webSecurityControllerImpl = new WebSecurityControllerImpl(this.mWebCreator.getWebView(), this.mAgentWeb.mJavaObjects, this.mSecurityType);
        this.mWebSecurityController = object2;
        this.mWebClientHelper = agentBuilder.mWebClientHelper;
        this.mIsInterceptUnkownUrl = agentBuilder.mIsInterceptUnkownUrl;
        if (agentBuilder.mOpenOtherPage != null) {
            this.mUrlHandleWays = ((AgentBuilder)agentBuilder).mOpenOtherPage.code;
        }
        this.mMiddleWrareWebClientBaseHeader = agentBuilder.mMiddlewareWebClientBaseHeader;
        this.mMiddlewareWebChromeBaseHeader = agentBuilder.mChromeMiddleWareHeader;
        this.init();
    }

    public static AgentBuilder with(Activity activity) {
        if (activity != null) {
            return new AgentBuilder(activity);
        }
        throw new NullPointerException("activity can not be null .");
    }

    public static AgentBuilder with(Fragment fragment) {
        FragmentActivity fragmentActivity = fragment.getActivity();
        if (fragmentActivity != null) {
            return new AgentBuilder((Activity)fragmentActivity, fragment);
        }
        throw new NullPointerException("activity can not be null .");
    }

    private void doSafeCheck() {
        WebSecurityCheckLogic webSecurityCheckLogic = this.mWebSecurityCheckLogic;
        if (webSecurityCheckLogic == null) {
            this.mWebSecurityCheckLogic = webSecurityCheckLogic = WebSecurityLogicImpl.getInstance(this.mWebCreator.getWebViewType());
        }
        this.mWebSecurityController.check(webSecurityCheckLogic);
    }

    private void doCompat() {
        AgentWebJsInterfaceCompat agentWebJsInterfaceCompat;
        AgentWebJsInterfaceCompat agentWebJsInterfaceCompat2 = agentWebJsInterfaceCompat;
        AgentWeb agentWeb = this;
        this.mAgentWebJsInterfaceCompat = new AgentWebJsInterfaceCompat(agentWeb, agentWeb.mActivity);
        this.mJavaObjects.put((Object)"agentWeb", (Object)agentWebJsInterfaceCompat2);
    }

    private WebCreator configWebCreator(BaseIndicatorView object, int n, ViewGroup.LayoutParams layoutParams, int n2, int n3, WebView webView, IWebLayout iWebLayout) {
        AgentWeb agentWeb;
        if (object != null && agentWeb.mEnableIndicator) {
            AgentWeb agentWeb2 = agentWeb;
            agentWeb = agentWeb2.mActivity;
            return new DefaultWebCreator((Activity)agentWeb, agentWeb2.mViewGroup, layoutParams, n, (BaseIndicatorView)object, webView, iWebLayout);
        }
        if (agentWeb.mEnableIndicator) {
            DefaultWebCreator defaultWebCreator;
            object = defaultWebCreator;
            AgentWeb agentWeb3 = agentWeb;
            agentWeb = agentWeb3.mActivity;
            defaultWebCreator = new DefaultWebCreator((Activity)agentWeb, agentWeb3.mViewGroup, layoutParams, n, n2, n3, webView, iWebLayout);
        } else {
            DefaultWebCreator defaultWebCreator;
            object = defaultWebCreator;
            AgentWeb agentWeb4 = agentWeb;
            agentWeb = agentWeb4.mActivity;
            defaultWebCreator = new DefaultWebCreator((Activity)agentWeb, agentWeb4.mViewGroup, layoutParams, n, webView, iWebLayout);
        }
        return object;
    }

    private AgentWeb go(String object) {
        this.getUrlLoader().loadUrl((String)object);
        if (!TextUtils.isEmpty((CharSequence)object) && (object = this.getIndicatorController()) != null && object.offerIndicator() != null) {
            this.getIndicatorController().offerIndicator().show();
        }
        return this;
    }

    private EventInterceptor getInterceptor() {
        Object object = this.mEventInterceptor;
        if (object != null) {
            return object;
        }
        object = this.mIVideo;
        if (object instanceof VideoImpl) {
            this.mEventInterceptor = (EventInterceptor)object;
            return this.mEventInterceptor;
        }
        return null;
    }

    private void init() {
        AgentWeb agentWeb = this;
        agentWeb.doCompat();
        agentWeb.doSafeCheck();
    }

    private IVideo getIVideo() {
        IVideo iVideo = this.mIVideo;
        if (iVideo == null) {
            VideoImpl videoImpl;
            iVideo = videoImpl;
            videoImpl = new VideoImpl(this.mActivity, this.mWebCreator.getWebView());
        }
        return iVideo;
    }

    private android.webkit.WebViewClient getWebViewClient() {
        AgentWeb agentWeb = this;
        LogUtils.i(TAG, "getDelegate:" + (Object)((Object)this.mMiddleWrareWebClientBaseHeader));
        DefaultWebClient defaultWebClient = DefaultWebClient.createBuilder().setActivity(this.mActivity).setWebClientHelper(this.mWebClientHelper).setPermissionInterceptor(this.mPermissionInterceptor).setWebView(this.mWebCreator.getWebView()).setInterceptUnkownUrl(this.mIsInterceptUnkownUrl).setUrlHandleWays(this.mUrlHandleWays).build();
        MiddlewareWebClientBase middlewareWebClientBase = agentWeb.mMiddleWrareWebClientBaseHeader;
        MiddlewareWebClientBase middlewareWebClientBase2 = agentWeb.mWebViewClient;
        if (middlewareWebClientBase2 != null) {
            middlewareWebClientBase2.enq(middlewareWebClientBase);
            middlewareWebClientBase = this.mWebViewClient;
        }
        if (middlewareWebClientBase != null) {
            int n = 1;
            middlewareWebClientBase2 = middlewareWebClientBase;
            while (middlewareWebClientBase2.next() != null) {
                middlewareWebClientBase2 = middlewareWebClientBase2.next();
                ++n;
            }
            LogUtils.i(TAG, "MiddlewareWebClientBase middleware count:" + n);
            middlewareWebClientBase2.setDelegate(defaultWebClient);
            return middlewareWebClientBase;
        }
        return defaultWebClient;
    }

    private AgentWeb ready() {
        boolean bl;
        AgentWebConfig.initCookiesManager(this.mActivity.getApplicationContext());
        Object object = this.mAgentWebSettings;
        if (object == null) {
            object = AbsAgentWebSettings.getInstance();
            this.mAgentWebSettings = object;
        }
        if (bl = object instanceof AbsAgentWebSettings) {
            ((AbsAgentWebSettings)object).bindAgentWeb(this);
        }
        if (this.mWebListenerManager == null && bl) {
            this.mWebListenerManager = (WebListenerManager)object;
        }
        object.toSetting(this.mWebCreator.getWebView());
        if (this.mJsInterfaceHolder == null) {
            this.mJsInterfaceHolder = JsInterfaceHolderImpl.getJsInterfaceHolder(this.mWebCreator, this.mSecurityType);
        }
        LogUtils.i(TAG, "mJavaObjects:" + this.mJavaObjects.size());
        object = this.mJavaObjects;
        if (object != null && !object.isEmpty()) {
            this.mJsInterfaceHolder.addJavaObjects((Map<String, Object>)this.mJavaObjects);
        }
        if ((object = this.mWebListenerManager) != null) {
            object.setDownloader(this.mWebCreator.getWebView(), null);
            this.mWebListenerManager.setWebChromeClient(this.mWebCreator.getWebView(), this.getChromeClient());
            this.mWebListenerManager.setWebViewClient(this.mWebCreator.getWebView(), this.getWebViewClient());
        }
        return this;
    }

    private android.webkit.WebChromeClient getChromeClient() {
        DefaultChromeClient defaultChromeClient;
        Object object = this.mIndicatorController;
        if (object == null) {
            object = IndicatorHandler.getInstance().inJectIndicator((BaseIndicatorSpec)this.mWebCreator.offer());
        }
        AgentWeb agentWeb = this;
        DefaultChromeClient defaultChromeClient2 = defaultChromeClient;
        AgentWeb agentWeb2 = this;
        Object object2 = this.mActivity;
        agentWeb2.mIndicatorController = object;
        Object object3 = agentWeb2.getIVideo();
        agentWeb2.mIVideo = object3;
        PermissionInterceptor permissionInterceptor = agentWeb2.mPermissionInterceptor;
        Activity activity = object2;
        object2 = this.mWebCreator.getWebView();
        defaultChromeClient = new DefaultChromeClient(activity, (IndicatorController)object, null, (IVideo)object3, permissionInterceptor, (WebView)object2);
        LogUtils.i(TAG, "WebChromeClient:" + (Object)((Object)this.mWebChromeClient));
        object = agentWeb.mMiddlewareWebChromeBaseHeader;
        object2 = agentWeb.mWebChromeClient;
        if (object2 != null) {
            ((MiddlewareWebChromeBase)((Object)object2)).enq((MiddlewareWebChromeBase)((Object)object));
            object = this.mWebChromeClient;
        }
        if (object != null) {
            int n = 1;
            object3 = object;
            while (((MiddlewareWebChromeBase)((Object)object3)).next() != null) {
                object3 = ((MiddlewareWebChromeBase)((Object)object3)).next();
                ++n;
            }
            LogUtils.i(TAG, "MiddlewareWebClientBase middleware count:" + n);
            ((MiddlewareWebChromeBase)((Object)object3)).setDelegate(defaultChromeClient2);
            this.mTargetChromeClient = object;
            return object;
        }
        this.mTargetChromeClient = defaultChromeClient2;
        return defaultChromeClient2;
    }

    public PermissionInterceptor getPermissionInterceptor() {
        return this.mPermissionInterceptor;
    }

    public WebLifeCycle getWebLifeCycle() {
        return this.mWebLifeCycle;
    }

    public JsAccessEntrace getJsAccessEntrace() {
        JsAccessEntrace jsAccessEntrace = this.mJsAccessEntrace;
        if (jsAccessEntrace == null) {
            this.mJsAccessEntrace = jsAccessEntrace = JsAccessEntraceImpl.getInstance(this.mWebCreator.getWebView());
        }
        return jsAccessEntrace;
    }

    public AgentWeb clearWebCache() {
        if (this.getWebCreator().getWebView() != null) {
            AgentWebUtils.clearWebViewAllCache((Context)this.mActivity, this.getWebCreator().getWebView());
        } else {
            AgentWebUtils.clearWebViewAllCache((Context)this.mActivity);
        }
        return this;
    }

    public boolean handleKeyEvent(int n, KeyEvent keyEvent) {
        if (this.mIEventHandler == null) {
            this.mIEventHandler = EventHandlerImpl.getInstantce(this.mWebCreator.getWebView(), this.getInterceptor());
        }
        return this.mIEventHandler.onKeyDown(n, keyEvent);
    }

    public boolean back() {
        if (this.mIEventHandler == null) {
            this.mIEventHandler = EventHandlerImpl.getInstantce(this.mWebCreator.getWebView(), this.getInterceptor());
        }
        return this.mIEventHandler.back();
    }

    public WebCreator getWebCreator() {
        return this.mWebCreator;
    }

    public IEventHandler getIEventHandler() {
        IEventHandler iEventHandler = this.mIEventHandler;
        if (iEventHandler == null) {
            this.mIEventHandler = iEventHandler = EventHandlerImpl.getInstantce(this.mWebCreator.getWebView(), this.getInterceptor());
        }
        return iEventHandler;
    }

    public IAgentWebSettings getAgentWebSettings() {
        return this.mAgentWebSettings;
    }

    public IndicatorController getIndicatorController() {
        return this.mIndicatorController;
    }

    public JsInterfaceHolder getJsInterfaceHolder() {
        return this.mJsInterfaceHolder;
    }

    public IUrlLoader getUrlLoader() {
        return this.mIUrlLoader;
    }

    public void destroy() {
        this.mWebLifeCycle.onDestroy();
    }

    Activity getActivity() {
        return this.mActivity;
    }

    public static final class AgentBuilder {
        private Activity mActivity;
        private Fragment mFragment;
        private ViewGroup mViewGroup;
        private boolean mIsNeedDefaultProgress;
        private int mIndex;
        private BaseIndicatorView mBaseIndicatorView;
        private IndicatorController mIndicatorController;
        private boolean mEnableIndicator;
        private ViewGroup.LayoutParams mLayoutParams;
        private WebViewClient mWebViewClient;
        private WebChromeClient mWebChromeClient;
        private int mIndicatorColor;
        private IAgentWebSettings mAgentWebSettings;
        private WebCreator mWebCreator;
        private HttpHeaders mHttpHeaders;
        private IEventHandler mIEventHandler;
        private int mHeight;
        private ArrayMap<String, Object> mJavaObject;
        private SecurityType mSecurityType;
        private WebView mWebView;
        private boolean mWebClientHelper;
        private IWebLayout mWebLayout;
        private PermissionInterceptor mPermissionInterceptor;
        private AbsAgentWebUIController mAgentWebUIController;
        private DefaultWebClient.OpenOtherPageWays mOpenOtherPage;
        private boolean mIsInterceptUnkownUrl;
        private MiddlewareWebClientBase mMiddlewareWebClientBaseHeader;
        private MiddlewareWebClientBase mMiddlewareWebClientBaseTail;
        private MiddlewareWebChromeBase mChromeMiddleWareHeader;
        private MiddlewareWebChromeBase mChromeMiddleWareTail;
        private View mErrorView;
        private int mErrorLayout;
        private int mReloadId;
        private int mTag;

        public AgentBuilder(Activity activity, Fragment fragment) {
            AgentBuilder agentBuilder = this;
            this.mIndex = -1;
            this.mIndicatorController = null;
            this.mEnableIndicator = true;
            this.mLayoutParams = null;
            this.mIndicatorColor = -1;
            this.mHttpHeaders = null;
            this.mHeight = -1;
            this.mSecurityType = SecurityType.DEFAULT_CHECK;
            this.mWebClientHelper = true;
            this.mWebLayout = null;
            this.mPermissionInterceptor = null;
            this.mOpenOtherPage = null;
            this.mIsInterceptUnkownUrl = true;
            this.mChromeMiddleWareHeader = null;
            this.mChromeMiddleWareTail = null;
            this.mActivity = activity;
            agentBuilder.mFragment = fragment;
            agentBuilder.mTag = 1;
        }

        public AgentBuilder(Activity activity) {
            AgentBuilder agentBuilder = this;
            this.mIndex = -1;
            this.mIndicatorController = null;
            this.mEnableIndicator = true;
            this.mLayoutParams = null;
            this.mIndicatorColor = -1;
            this.mHttpHeaders = null;
            this.mHeight = -1;
            this.mSecurityType = SecurityType.DEFAULT_CHECK;
            this.mWebClientHelper = true;
            this.mWebLayout = null;
            this.mPermissionInterceptor = null;
            this.mOpenOtherPage = null;
            this.mIsInterceptUnkownUrl = true;
            this.mChromeMiddleWareHeader = null;
            this.mChromeMiddleWareTail = null;
            agentBuilder.mActivity = activity;
            agentBuilder.mTag = 0;
        }

        private PreAgentWeb buildAgentWeb() {
            if (this.mTag == 1 && this.mViewGroup == null) {
                throw new NullPointerException("ViewGroup is null,Please check your parameters .");
            }
            return new PreAgentWeb(HookManager.hookAgentWeb(new AgentWeb(this), this));
        }

        private void addJavaObject(String string2, Object object) {
            if (this.mJavaObject == null) {
                ArrayMap arrayMap;
                ArrayMap arrayMap2 = arrayMap;
                arrayMap = new ArrayMap();
                this.mJavaObject = arrayMap2;
            }
            this.mJavaObject.put((Object)string2, object);
        }

        private void addHeader(String string2, String string3, String string4) {
            if (this.mHttpHeaders == null) {
                this.mHttpHeaders = HttpHeaders.create();
            }
            this.mHttpHeaders.additionalHttpHeader(string2, string3, string4);
        }

        private void addHeader(String string2, Map<String, String> map) {
            if (this.mHttpHeaders == null) {
                this.mHttpHeaders = HttpHeaders.create();
            }
            this.mHttpHeaders.additionalHttpHeaders(string2, map);
        }

        static /* synthetic */ boolean access$402(AgentBuilder agentBuilder, boolean bl) {
            agentBuilder.mEnableIndicator = bl;
            return bl;
        }

        static /* synthetic */ int access$902(AgentBuilder agentBuilder, int n) {
            agentBuilder.mIndicatorColor = n;
            return n;
        }

        static /* synthetic */ int access$1002(AgentBuilder agentBuilder, int n) {
            agentBuilder.mHeight = n;
            return n;
        }

        static /* synthetic */ BaseIndicatorView access$602(AgentBuilder agentBuilder, BaseIndicatorView baseIndicatorView) {
            agentBuilder.mBaseIndicatorView = baseIndicatorView;
            return baseIndicatorView;
        }

        static /* synthetic */ boolean access$3402(AgentBuilder agentBuilder, boolean bl) {
            agentBuilder.mIsNeedDefaultProgress = bl;
            return bl;
        }

        static /* synthetic */ IEventHandler access$302(AgentBuilder agentBuilder, IEventHandler iEventHandler) {
            agentBuilder.mIEventHandler = iEventHandler;
            return iEventHandler;
        }

        static /* synthetic */ boolean access$2602(AgentBuilder agentBuilder, boolean bl) {
            agentBuilder.mWebClientHelper = bl;
            return bl;
        }

        static /* synthetic */ WebChromeClient access$1402(AgentBuilder agentBuilder, WebChromeClient webChromeClient) {
            agentBuilder.mWebChromeClient = webChromeClient;
            return webChromeClient;
        }

        static /* synthetic */ WebViewClient access$1502(AgentBuilder agentBuilder, WebViewClient webViewClient) {
            agentBuilder.mWebViewClient = webViewClient;
            return webViewClient;
        }

        static /* synthetic */ MiddlewareWebClientBase access$2902(AgentBuilder agentBuilder, MiddlewareWebClientBase middlewareWebClientBase) {
            agentBuilder.mMiddlewareWebClientBaseHeader = middlewareWebClientBase;
            return middlewareWebClientBase;
        }

        static /* synthetic */ MiddlewareWebClientBase access$3502(AgentBuilder agentBuilder, MiddlewareWebClientBase middlewareWebClientBase) {
            agentBuilder.mMiddlewareWebClientBaseTail = middlewareWebClientBase;
            return middlewareWebClientBase;
        }

        static /* synthetic */ MiddlewareWebChromeBase access$3002(AgentBuilder agentBuilder, MiddlewareWebChromeBase middlewareWebChromeBase) {
            agentBuilder.mChromeMiddleWareHeader = middlewareWebChromeBase;
            return middlewareWebChromeBase;
        }

        static /* synthetic */ MiddlewareWebChromeBase access$3602(AgentBuilder agentBuilder, MiddlewareWebChromeBase middlewareWebChromeBase) {
            agentBuilder.mChromeMiddleWareTail = middlewareWebChromeBase;
            return middlewareWebChromeBase;
        }

        static /* synthetic */ View access$2502(AgentBuilder agentBuilder, View view) {
            agentBuilder.mErrorView = view;
            return view;
        }

        static /* synthetic */ int access$2302(AgentBuilder agentBuilder, int n) {
            agentBuilder.mErrorLayout = n;
            return n;
        }

        static /* synthetic */ int access$2402(AgentBuilder agentBuilder, int n) {
            agentBuilder.mReloadId = n;
            return n;
        }

        static /* synthetic */ IAgentWebSettings access$1602(AgentBuilder agentBuilder, IAgentWebSettings iAgentWebSettings) {
            agentBuilder.mAgentWebSettings = iAgentWebSettings;
            return iAgentWebSettings;
        }

        static /* synthetic */ SecurityType access$2002(AgentBuilder agentBuilder, SecurityType securityType) {
            agentBuilder.mSecurityType = securityType;
            return securityType;
        }

        static /* synthetic */ WebView access$1102(AgentBuilder agentBuilder, WebView webView) {
            agentBuilder.mWebView = webView;
            return webView;
        }

        static /* synthetic */ IWebLayout access$1202(AgentBuilder agentBuilder, IWebLayout iWebLayout) {
            agentBuilder.mWebLayout = iWebLayout;
            return iWebLayout;
        }

        static /* synthetic */ PermissionInterceptor access$1802(AgentBuilder agentBuilder, PermissionInterceptor permissionInterceptor) {
            agentBuilder.mPermissionInterceptor = permissionInterceptor;
            return permissionInterceptor;
        }

        static /* synthetic */ AbsAgentWebUIController access$2202(AgentBuilder agentBuilder, AbsAgentWebUIController absAgentWebUIController) {
            agentBuilder.mAgentWebUIController = absAgentWebUIController;
            return absAgentWebUIController;
        }

        static /* synthetic */ DefaultWebClient.OpenOtherPageWays access$2802(AgentBuilder agentBuilder, DefaultWebClient.OpenOtherPageWays openOtherPageWays) {
            agentBuilder.mOpenOtherPage = openOtherPageWays;
            return openOtherPageWays;
        }

        static /* synthetic */ boolean access$2702(AgentBuilder agentBuilder, boolean bl) {
            agentBuilder.mIsInterceptUnkownUrl = bl;
            return bl;
        }

        public IndicatorBuilder setAgentWebParent(ViewGroup viewGroup, ViewGroup.LayoutParams layoutParams) {
            AgentBuilder agentBuilder = this;
            agentBuilder.mViewGroup = viewGroup;
            agentBuilder.mLayoutParams = layoutParams;
            return new IndicatorBuilder(this);
        }

        public IndicatorBuilder setAgentWebParent(ViewGroup viewGroup, int n, ViewGroup.LayoutParams layoutParams) {
            AgentBuilder agentBuilder = this;
            agentBuilder.mViewGroup = viewGroup;
            agentBuilder.mLayoutParams = layoutParams;
            agentBuilder.mIndex = n;
            return new IndicatorBuilder(this);
        }
    }

    public static enum SecurityType {
        DEFAULT_CHECK,
        STRICT_CHECK;

    }

    private static final class PermissionInterceptorWrapper
    implements PermissionInterceptor {
        private WeakReference<PermissionInterceptor> mWeakReference;

        private PermissionInterceptorWrapper(PermissionInterceptor permissionInterceptor) {
            WeakReference<PermissionInterceptor> weakReference;
            WeakReference<PermissionInterceptor> weakReference2 = weakReference;
            weakReference = new WeakReference<PermissionInterceptor>(permissionInterceptor);
            v1.mWeakReference = weakReference2;
        }

        @Override
        public boolean intercept(String string2, String[] stringArray, String string3) {
            if (this.mWeakReference.get() == null) {
                return false;
            }
            return ((PermissionInterceptor)this.mWeakReference.get()).intercept(string2, stringArray, string3);
        }
    }

    public static class CommonBuilder {
        private AgentBuilder mAgentBuilder;

        public CommonBuilder(AgentBuilder agentBuilder) {
            this.mAgentBuilder = agentBuilder;
        }

        public CommonBuilder setEventHanadler(IEventHandler iEventHandler) {
            CommonBuilder commonBuilder = this;
            AgentBuilder.access$302(commonBuilder.mAgentBuilder, iEventHandler);
            return commonBuilder;
        }

        public CommonBuilder closeWebViewClientHelper() {
            CommonBuilder commonBuilder = this;
            AgentBuilder.access$2602(commonBuilder.mAgentBuilder, false);
            return commonBuilder;
        }

        public CommonBuilder setWebChromeClient(WebChromeClient webChromeClient) {
            CommonBuilder commonBuilder = this;
            AgentBuilder.access$1402(commonBuilder.mAgentBuilder, webChromeClient);
            return commonBuilder;
        }

        public CommonBuilder setWebViewClient(WebViewClient webViewClient) {
            CommonBuilder commonBuilder = this;
            AgentBuilder.access$1502(commonBuilder.mAgentBuilder, webViewClient);
            return commonBuilder;
        }

        public CommonBuilder useMiddlewareWebClient(MiddlewareWebClientBase middlewareWebClientBase) {
            if (middlewareWebClientBase == null) {
                return this;
            }
            if (this.mAgentBuilder.mMiddlewareWebClientBaseHeader == null) {
                AgentBuilder agentBuilder = this.mAgentBuilder;
                AgentBuilder.access$2902(agentBuilder, AgentBuilder.access$3502(agentBuilder, middlewareWebClientBase));
            } else {
                CommonBuilder commonBuilder = this;
                commonBuilder.mAgentBuilder.mMiddlewareWebClientBaseTail.enq(middlewareWebClientBase);
                AgentBuilder.access$3502(commonBuilder.mAgentBuilder, middlewareWebClientBase);
            }
            return this;
        }

        public CommonBuilder useMiddlewareWebChrome(MiddlewareWebChromeBase middlewareWebChromeBase) {
            if (middlewareWebChromeBase == null) {
                return this;
            }
            if (this.mAgentBuilder.mChromeMiddleWareHeader == null) {
                AgentBuilder agentBuilder = this.mAgentBuilder;
                AgentBuilder.access$3002(agentBuilder, AgentBuilder.access$3602(agentBuilder, middlewareWebChromeBase));
            } else {
                CommonBuilder commonBuilder = this;
                commonBuilder.mAgentBuilder.mChromeMiddleWareTail.enq(middlewareWebChromeBase);
                AgentBuilder.access$3602(commonBuilder.mAgentBuilder, middlewareWebChromeBase);
            }
            return this;
        }

        public CommonBuilder setMainFrameErrorView(View view) {
            CommonBuilder commonBuilder = this;
            AgentBuilder.access$2502(commonBuilder.mAgentBuilder, view);
            return commonBuilder;
        }

        public CommonBuilder setMainFrameErrorView(int n, int n2) {
            CommonBuilder commonBuilder = this;
            AgentBuilder.access$2302(commonBuilder.mAgentBuilder, n);
            AgentBuilder.access$2402(commonBuilder.mAgentBuilder, n2);
            return commonBuilder;
        }

        public CommonBuilder setAgentWebWebSettings(IAgentWebSettings iAgentWebSettings) {
            CommonBuilder commonBuilder = this;
            AgentBuilder.access$1602(commonBuilder.mAgentBuilder, iAgentWebSettings);
            return commonBuilder;
        }

        public PreAgentWeb createAgentWeb() {
            return this.mAgentBuilder.buildAgentWeb();
        }

        public CommonBuilder addJavascriptInterface(String string2, Object object) {
            CommonBuilder commonBuilder = this;
            commonBuilder.mAgentBuilder.addJavaObject(string2, object);
            return commonBuilder;
        }

        public CommonBuilder setSecurityType(SecurityType securityType) {
            CommonBuilder commonBuilder = this;
            AgentBuilder.access$2002(commonBuilder.mAgentBuilder, securityType);
            return commonBuilder;
        }

        public CommonBuilder setWebView(WebView webView) {
            CommonBuilder commonBuilder = this;
            AgentBuilder.access$1102(commonBuilder.mAgentBuilder, webView);
            return commonBuilder;
        }

        public CommonBuilder setWebLayout(IWebLayout iWebLayout) {
            CommonBuilder commonBuilder = this;
            AgentBuilder.access$1202(commonBuilder.mAgentBuilder, iWebLayout);
            return commonBuilder;
        }

        public CommonBuilder additionalHttpHeader(String string2, String string3, String string4) {
            CommonBuilder commonBuilder = this;
            commonBuilder.mAgentBuilder.addHeader(string2, string3, string4);
            return commonBuilder;
        }

        public CommonBuilder additionalHttpHeader(String string2, Map<String, String> map) {
            CommonBuilder commonBuilder = this;
            commonBuilder.mAgentBuilder.addHeader(string2, map);
            return commonBuilder;
        }

        public CommonBuilder setPermissionInterceptor(PermissionInterceptor permissionInterceptor) {
            CommonBuilder commonBuilder = this;
            AgentBuilder.access$1802(commonBuilder.mAgentBuilder, permissionInterceptor);
            return commonBuilder;
        }

        public CommonBuilder setAgentWebUIController(AgentWebUIControllerImplBase agentWebUIControllerImplBase) {
            CommonBuilder commonBuilder = this;
            AgentBuilder.access$2202(commonBuilder.mAgentBuilder, agentWebUIControllerImplBase);
            return commonBuilder;
        }

        public CommonBuilder setOpenOtherPageWays(DefaultWebClient.OpenOtherPageWays openOtherPageWays) {
            CommonBuilder commonBuilder = this;
            AgentBuilder.access$2802(commonBuilder.mAgentBuilder, openOtherPageWays);
            return commonBuilder;
        }

        public CommonBuilder interceptUnkownUrl() {
            CommonBuilder commonBuilder = this;
            AgentBuilder.access$2702(commonBuilder.mAgentBuilder, true);
            return commonBuilder;
        }

        public CommonBuilder isInterceptUnkownUrl(boolean bl) {
            CommonBuilder commonBuilder = this;
            AgentBuilder.access$2702(commonBuilder.mAgentBuilder, bl);
            return commonBuilder;
        }
    }

    public static class IndicatorBuilder {
        private AgentBuilder mAgentBuilder;

        public IndicatorBuilder(AgentBuilder agentBuilder) {
            this.mAgentBuilder = agentBuilder;
        }

        public CommonBuilder useDefaultIndicator(int n) {
            IndicatorBuilder indicatorBuilder = this;
            AgentBuilder.access$402(indicatorBuilder.mAgentBuilder, true);
            AgentBuilder.access$902(indicatorBuilder.mAgentBuilder, n);
            return new CommonBuilder(this.mAgentBuilder);
        }

        public CommonBuilder useDefaultIndicator() {
            AgentBuilder.access$402(this.mAgentBuilder, true);
            return new CommonBuilder(this.mAgentBuilder);
        }

        public CommonBuilder closeIndicator() {
            IndicatorBuilder indicatorBuilder = this;
            AgentBuilder.access$402(indicatorBuilder.mAgentBuilder, false);
            AgentBuilder.access$902(indicatorBuilder.mAgentBuilder, -1);
            AgentBuilder.access$1002(indicatorBuilder.mAgentBuilder, -1);
            return new CommonBuilder(this.mAgentBuilder);
        }

        public CommonBuilder setCustomIndicator(BaseIndicatorView baseIndicatorView) {
            if (baseIndicatorView != null) {
                IndicatorBuilder indicatorBuilder = this;
                AgentBuilder.access$402(indicatorBuilder.mAgentBuilder, true);
                AgentBuilder.access$602(indicatorBuilder.mAgentBuilder, baseIndicatorView);
                AgentBuilder.access$3402(indicatorBuilder.mAgentBuilder, false);
            } else {
                IndicatorBuilder indicatorBuilder = this;
                AgentBuilder.access$402(indicatorBuilder.mAgentBuilder, true);
                AgentBuilder.access$3402(indicatorBuilder.mAgentBuilder, true);
            }
            return new CommonBuilder(this.mAgentBuilder);
        }

        public CommonBuilder useDefaultIndicator(int n, int n2) {
            IndicatorBuilder indicatorBuilder = this;
            AgentBuilder.access$902(indicatorBuilder.mAgentBuilder, n);
            AgentBuilder.access$1002(indicatorBuilder.mAgentBuilder, n2);
            return new CommonBuilder(this.mAgentBuilder);
        }
    }

    public static class PreAgentWeb {
        private AgentWeb mAgentWeb;
        private boolean isReady = false;

        PreAgentWeb(AgentWeb agentWeb) {
            this.mAgentWeb = agentWeb;
        }

        public PreAgentWeb ready() {
            if (!this.isReady) {
                this.mAgentWeb.ready();
                this.isReady = true;
            }
            return this;
        }

        public AgentWeb get() {
            PreAgentWeb preAgentWeb = this;
            preAgentWeb.ready();
            return preAgentWeb.mAgentWeb;
        }

        public AgentWeb go(String string2) {
            if (!this.isReady) {
                this.ready();
            }
            return this.mAgentWeb.go(string2);
        }
    }
}

