/*
 * Decompiled with CFR 0.152.
 */
package com.just.agentweb;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.View;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.just.agentweb.Action;
import com.just.agentweb.AgentWebUtils;
import com.just.agentweb.LogUtils;
import java.io.File;
import java.util.Iterator;

public final class AgentActionFragment
extends Fragment {
    public static final String KEY_URI = "KEY_URI";
    public static final String KEY_FROM_INTENTION = "KEY_FROM_INTENTION";
    private static final String TAG = "AgentActionFragment";
    public static final int REQUEST_CODE = 596;
    public static final String FRAGMENT_TAG = "AgentWebActionFragment";
    private Action mAction;
    private boolean isViewCreated = false;

    public static void start(Activity activity, Action action) {
        AgentActionFragment agentActionFragment = (AgentActionFragment)(activity = ((FragmentActivity)activity).getSupportFragmentManager()).findFragmentByTag(FRAGMENT_TAG);
        if (agentActionFragment == null) {
            AgentActionFragment agentActionFragment2;
            agentActionFragment = agentActionFragment2;
            agentActionFragment2 = new AgentActionFragment();
            activity.beginTransaction().add((Fragment)agentActionFragment, FRAGMENT_TAG).commitAllowingStateLoss();
        }
        agentActionFragment.mAction = action;
        if (agentActionFragment.isViewCreated) {
            agentActionFragment.runAction();
        }
    }

    private void resetAction() {
    }

    private void runAction() {
        Action action = this.mAction;
        if (action == null) {
            this.resetAction();
            return;
        }
        if (action.getAction() == 1) {
            if (Build.VERSION.SDK_INT >= 23) {
                AgentActionFragment agentActionFragment = this;
                agentActionFragment.requestPermission(agentActionFragment.mAction);
            } else {
                this.resetAction();
            }
        } else if (this.mAction.getAction() == 3) {
            this.captureCamera();
        } else if (this.mAction.getAction() == 4) {
            this.recordVideo();
        } else {
            this.choose();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void choose() {
        try {
            if (this.mAction.getChooserListener() == null) {
                return;
            }
            Intent intent = this.mAction.getIntent();
            if (intent == null) {
                this.resetAction();
                return;
            }
            this.startActivityForResult(intent, 596);
            return;
        }
        catch (Throwable throwable) {
            LogUtils.i(TAG, "\u627e\u4e0d\u5230\u6587\u4ef6\u9009\u62e9\u5668");
            this.chooserActionCallback(-1, null);
            if (!LogUtils.isDebug()) return;
            throwable.printStackTrace();
        }
    }

    private void chooserActionCallback(int n, Intent intent) {
        if (this.mAction.getChooserListener() != null) {
            this.mAction.getChooserListener().onChoiceResult(596, n, intent);
        }
        this.resetAction();
    }

    private void requestPermission(Action object) {
        if (AgentWebUtils.isEmptyCollection(object = ((Action)object).getPermissions())) {
            agentActionFragment2.resetAction();
            return;
        }
        if (agentActionFragment2.mAction.getRationaleListener() != null) {
            Bundle bundle;
            boolean bl = false;
            Iterator iterator = object.iterator();
            while (iterator.hasNext() && !(bl = agentActionFragment2.shouldShowRequestPermissionRationale((String)iterator.next()))) {
            }
            AgentActionFragment agentActionFragment = agentActionFragment2;
            AgentActionFragment agentActionFragment2 = bundle;
            bundle = new Bundle();
            agentActionFragment.mAction.getRationaleListener().onRationaleResult(bl, (Bundle)agentActionFragment2);
            agentActionFragment.resetAction();
            return;
        }
        if (agentActionFragment2.mAction.getPermissionListener() != null) {
            agentActionFragment2.requestPermissions(object.toArray(new String[0]), 1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void captureCamera() {
        try {
            if (this.mAction.getChooserListener() == null) {
                this.resetAction();
                return;
            }
            File file = AgentWebUtils.createImageFile((Context)this.getActivity());
            if (file == null) {
                this.mAction.getChooserListener().onChoiceResult(596, 0, null);
            }
            AgentActionFragment agentActionFragment = this;
            Intent intent = AgentWebUtils.getIntentCaptureCompat((Context)agentActionFragment.getActivity(), file);
            this.mAction.setUri((Uri)intent.getParcelableExtra("output"));
            agentActionFragment.startActivityForResult(intent, 596);
            return;
        }
        catch (Throwable throwable) {
            LogUtils.e(TAG, "\u627e\u4e0d\u5230\u7cfb\u7edf\u76f8\u673a");
            if (this.mAction.getChooserListener() != null) {
                this.mAction.getChooserListener().onChoiceResult(596, 0, null);
            }
            this.resetAction();
            if (!LogUtils.isDebug()) return;
            throwable.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void recordVideo() {
        try {
            if (this.mAction.getChooserListener() == null) {
                this.resetAction();
                return;
            }
            File file = AgentWebUtils.createVideoFile((Context)this.getActivity());
            if (file == null) {
                AgentActionFragment agentActionFragment = this;
                agentActionFragment.mAction.getChooserListener().onChoiceResult(596, 0, null);
                agentActionFragment.resetAction();
                return;
            }
            AgentActionFragment agentActionFragment = this;
            Intent intent = AgentWebUtils.getIntentVideoCompat((Context)agentActionFragment.getActivity(), file);
            this.mAction.setUri((Uri)intent.getParcelableExtra("output"));
            agentActionFragment.startActivityForResult(intent, 596);
            return;
        }
        catch (Throwable throwable) {
            LogUtils.e(TAG, "\u627e\u4e0d\u5230\u7cfb\u7edf\u76f8\u673a");
            if (this.mAction.getChooserListener() != null) {
                this.mAction.getChooserListener().onChoiceResult(596, 0, null);
            }
            this.resetAction();
            if (!LogUtils.isDebug()) return;
            throwable.printStackTrace();
        }
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        if (bundle != null) {
            LogUtils.i(TAG, "savedInstanceState:" + bundle);
            return;
        }
        this.isViewCreated = true;
        this.runAction();
    }

    public void onViewCreated(View view, Bundle bundle) {
        super.onViewCreated(view, bundle);
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        Action action = this.mAction;
        if (action == null) {
            return;
        }
        if (n == 596) {
            if (action.getUri() != null) {
                this.chooserActionCallback(n2, new Intent().putExtra(KEY_URI, (Parcelable)this.mAction.getUri()));
            } else {
                this.chooserActionCallback(n2, intent);
            }
        }
        this.resetAction();
    }

    public void onRequestPermissionsResult(int n, String[] stringArray, int[] nArray) {
        if (this.mAction.getPermissionListener() != null) {
            Bundle bundle;
            Bundle bundle2 = bundle;
            bundle2();
            bundle.putInt(KEY_FROM_INTENTION, this.mAction.getFromIntention());
            this.mAction.getPermissionListener().onRequestPermissionsResult(stringArray, nArray, bundle2);
        }
        this.resetAction();
    }

    public void onDestroy() {
        super.onDestroy();
    }

    public static interface ChooserListener {
        public void onChoiceResult(int var1, int var2, Intent var3);
    }

    public static interface RationaleListener {
        public void onRationaleResult(boolean var1, Bundle var2);
    }

    public static interface PermissionListener {
        public void onRequestPermissionsResult(String[] var1, int[] var2, Bundle var3);
    }
}

