/*
 * Decompiled with CFR 0.152.
 */
package com.just.agentweb;

import android.os.Build;
import android.webkit.DownloadListener;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.just.agentweb.AgentWeb;
import com.just.agentweb.AgentWebConfig;
import com.just.agentweb.AgentWebSettingsImpl;
import com.just.agentweb.AgentWebUtils;
import com.just.agentweb.IAgentWebSettings;
import com.just.agentweb.LogUtils;
import com.just.agentweb.WebListenerManager;

public abstract class AbsAgentWebSettings
implements IAgentWebSettings,
WebListenerManager {
    private static final String TAG = "AbsAgentWebSettings";
    public static final String USERAGENT_UC = " UCBrowser/11.6.4.950 ";
    public static final String USERAGENT_QQ_BROWSER = " MQQBrowser/8.0 ";
    public static final String USERAGENT_AGENTWEB = " AgentWeb/5.0.8 ";
    private WebSettings mWebSettings;
    protected AgentWeb mAgentWeb;

    public static AbsAgentWebSettings getInstance() {
        return new AgentWebSettingsImpl();
    }

    private void settings(WebView webView) {
        WebView webView2 = webView;
        this.mWebSettings = webView2.getSettings();
        this.mWebSettings.setJavaScriptEnabled(true);
        this.mWebSettings.setSupportZoom(true);
        this.mWebSettings.setBuiltInZoomControls(false);
        this.mWebSettings.setSavePassword(false);
        if (AgentWebUtils.checkNetwork(webView2.getContext().getApplicationContext())) {
            this.mWebSettings.setCacheMode(-1);
        } else {
            this.mWebSettings.setCacheMode(1);
        }
        int n = Build.VERSION.SDK_INT;
        if (n >= 21) {
            this.mWebSettings.setMixedContentMode(0);
            webView.setLayerType(2, null);
        } else if (n >= 19) {
            webView.setLayerType(2, null);
        } else if (n < 19) {
            webView.setLayerType(1, null);
        }
        this.mWebSettings.setTextZoom(100);
        this.mWebSettings.setDatabaseEnabled(true);
        this.mWebSettings.setLoadsImagesAutomatically(true);
        this.mWebSettings.setSupportMultipleWindows(false);
        this.mWebSettings.setBlockNetworkImage(false);
        this.mWebSettings.setAllowFileAccess(true);
        if (n >= 16) {
            this.mWebSettings.setAllowFileAccessFromFileURLs(false);
            this.mWebSettings.setAllowUniversalAccessFromFileURLs(false);
        }
        this.mWebSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        if (n >= 19) {
            this.mWebSettings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.SINGLE_COLUMN);
        } else {
            this.mWebSettings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NORMAL);
        }
        this.mWebSettings.setLoadWithOverviewMode(false);
        this.mWebSettings.setUseWideViewPort(false);
        this.mWebSettings.setDomStorageEnabled(true);
        this.mWebSettings.setNeedInitialFocus(true);
        this.mWebSettings.setDefaultTextEncodingName("utf-8");
        this.mWebSettings.setDefaultFontSize(16);
        this.mWebSettings.setMinimumFontSize(12);
        this.mWebSettings.setGeolocationEnabled(true);
        String string = AgentWebConfig.getCachePath(webView.getContext());
        String string2 = TAG;
        LogUtils.i(string2, "dir:" + string + "   appcache:" + AgentWebConfig.getCachePath(webView.getContext()));
        this.mWebSettings.setGeolocationDatabasePath(string);
        this.mWebSettings.setDatabasePath(string);
        this.mWebSettings.setUserAgentString(this.getWebSettings().getUserAgentString().concat(USERAGENT_AGENTWEB).concat(USERAGENT_UC));
        LogUtils.i(string2, "UserAgentString : " + this.mWebSettings.getUserAgentString());
    }

    final void bindAgentWeb(AgentWeb agentWeb) {
        this.mAgentWeb = agentWeb;
        this.bindAgentWebSupport(agentWeb);
    }

    protected abstract void bindAgentWebSupport(AgentWeb var1);

    @Override
    public IAgentWebSettings toSetting(WebView webView) {
        AbsAgentWebSettings absAgentWebSettings = this;
        absAgentWebSettings.settings(webView);
        return absAgentWebSettings;
    }

    public WebSettings getWebSettings() {
        return this.mWebSettings;
    }

    @Override
    public WebListenerManager setWebChromeClient(WebView webView, WebChromeClient webChromeClient) {
        webView.setWebChromeClient(webChromeClient);
        return this;
    }

    @Override
    public WebListenerManager setWebViewClient(WebView webView, WebViewClient webViewClient) {
        webView.setWebViewClient(webViewClient);
        return this;
    }

    @Override
    public WebListenerManager setDownloader(WebView webView, DownloadListener downloadListener) {
        webView.setDownloadListener(downloadListener);
        return this;
    }
}

